/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.PrefixFilter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.ql.stats.StatsAggregator;

public class HBaseStatsAggregator
implements StatsAggregator {
    private HTable htable;
    private byte[] rowCountFamily;
    private byte[] rowCountColumn;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());

    public boolean connect(Configuration hiveconf) {
        try {
            HBaseConfiguration hbaseConf = new HBaseConfiguration(hiveconf);
            HBaseAdmin hbase = new HBaseAdmin((Configuration)hbaseConf);
            this.rowCountFamily = Bytes.toBytes((String)"ROW_COUNT_FAMILY");
            this.rowCountColumn = Bytes.toBytes((String)"ROW_COUNT");
            this.htable = new HTable("PARTITION_STAT_TBL");
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during HBase connection. ", (Throwable)e);
            return false;
        }
    }

    public String aggregateStats(String rowID, String key) {
        if (key != "numRows") {
            this.LOG.warn((Object)"Warning. Invalid statistic. Currently row count is the only supported statistic");
            return null;
        }
        int retValue = 0;
        try {
            Scan scan = new Scan();
            scan.addColumn(this.rowCountFamily, this.rowCountColumn);
            PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)rowID));
            scan.setFilter((Filter)filter);
            ResultScanner scanner = this.htable.getScanner(scan);
            ArrayList<Delete> toDelete = new ArrayList<Delete>();
            for (Result result : scanner) {
                retValue += Integer.parseInt(Bytes.toString((byte[])result.getValue(this.rowCountFamily, this.rowCountColumn)));
                Delete delete = new Delete(result.getRow());
                toDelete.add(delete);
            }
            this.htable.delete(toDelete);
            return Integer.toString(retValue);
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during publishing aggregation. ", (Throwable)e);
            return null;
        }
    }

    public boolean closeConnection() {
        return true;
    }

    public boolean cleanUp(String rowID) {
        try {
            Scan scan = new Scan();
            PrefixFilter filter = new PrefixFilter(Bytes.toBytes((String)rowID));
            scan.setFilter((Filter)filter);
            ResultScanner scanner = this.htable.getScanner(scan);
            ArrayList<Delete> toDelete = new ArrayList<Delete>();
            for (Result result : scanner) {
                Delete delete = new Delete(result.getRow());
                toDelete.add(delete);
            }
            this.htable.delete(toDelete);
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Error during publishing aggregation. ", (Throwable)e);
            return false;
        }
    }
}

