/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.ql.stats.StatsPublisher;

public class HBaseStatsPublisher
implements StatsPublisher {
    private HTable htable;
    private byte[] rowCountFamily;
    private byte[] rowCountColumn;
    private final Log LOG = LogFactory.getLog((String)this.getClass().getName());

    public boolean connect(Configuration hiveconf) {
        try {
            HBaseConfiguration hbaseConf = new HBaseConfiguration(hiveconf);
            HBaseAdmin hbase = new HBaseAdmin((Configuration)hbaseConf);
            this.rowCountFamily = Bytes.toBytes((String)"ROW_COUNT_FAMILY");
            this.rowCountColumn = Bytes.toBytes((String)"ROW_COUNT");
            this.htable = new HTable("PARTITION_STAT_TBL");
            this.htable.setAutoFlush(false);
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during HBase connection. " + e));
            return false;
        }
        return true;
    }

    public boolean publishStat(String rowID, String key, String value) {
        if (key != "numRows") {
            this.LOG.warn((Object)"Warning. Invalid statistic. Currently row count is the only supported statistic");
            return false;
        }
        try {
            Get get = new Get(Bytes.toBytes((String)rowID));
            Result result = this.htable.get(get);
            int val = Integer.parseInt(value);
            int oldVal = 0;
            if (!result.isEmpty()) {
                oldVal = Integer.parseInt(Bytes.toString((byte[])result.getValue(this.rowCountFamily, this.rowCountColumn)));
            }
            if (oldVal < val) {
                Put row = new Put(Bytes.toBytes((String)rowID));
                row.add(this.rowCountFamily, this.rowCountColumn, Bytes.toBytes((String)Integer.toString(val)));
                this.htable.put(row);
            }
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during publishing statistics. " + e));
            return false;
        }
    }

    public boolean closeConnection() {
        try {
            this.htable.flushCommits();
            return true;
        }
        catch (IOException e) {
            this.LOG.error((Object)"Cannot commit changes in stats publishing.", (Throwable)e);
            return false;
        }
    }

    public boolean init(Configuration hiveconf) {
        try {
            HBaseConfiguration hbaseConf = new HBaseConfiguration(hiveconf);
            HBaseAdmin hbase = new HBaseAdmin((Configuration)hbaseConf);
            this.rowCountFamily = Bytes.toBytes((String)"ROW_COUNT_FAMILY");
            this.rowCountColumn = Bytes.toBytes((String)"ROW_COUNT");
            if (!hbase.tableExists("PARTITION_STAT_TBL")) {
                HTableDescriptor table = new HTableDescriptor("PARTITION_STAT_TBL");
                HColumnDescriptor rowCount = new HColumnDescriptor(this.rowCountFamily);
                table.addFamily(rowCount);
                hbase.createTable(table);
            }
        }
        catch (IOException e) {
            this.LOG.error((Object)("Error during HBase initialization. " + e));
            return false;
        }
        return true;
    }
}

