/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.ZooKeeperConnectionException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HiveHBaseTableInputFormat;
import org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.metadata.DefaultStorageHandler;
import org.apache.hadoop.hive.ql.metadata.HiveStoragePredicateHandler;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;

public class HBaseStorageHandler
extends DefaultStorageHandler
implements HiveMetaHook,
HiveStoragePredicateHandler {
    private HBaseConfiguration hbaseConf;
    private HBaseAdmin admin;

    private HBaseAdmin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                this.admin = new HBaseAdmin((Configuration)this.hbaseConf);
            }
            return this.admin;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (ZooKeeperConnectionException zkce) {
            throw new MetaException(StringUtils.stringifyException((Throwable)zkce));
        }
    }

    private String getHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null) {
            tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name");
        }
        if (tableName == null) {
            tableName = tbl.getTableName();
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            String tableName = this.getHBaseTableName(tbl);
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (deleteData && !isExternal) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        try {
            HTableDescriptor tableDesc;
            String tableName = this.getHBaseTableName(tbl);
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String hbaseColumnsMapping = (String)serdeParam.get("hbase.columns.mapping");
            if (hbaseColumnsMapping == null) {
                throw new MetaException("No hbase.columns.mapping defined in Serde.");
            }
            ArrayList<String> hbaseColumnFamilies = new ArrayList<String>();
            ArrayList<String> hbaseColumnQualifiers = new ArrayList<String>();
            ArrayList<byte[]> hbaseColumnFamiliesBytes = new ArrayList<byte[]>();
            ArrayList<byte[]> hbaseColumnQualifiersBytes = new ArrayList<byte[]>();
            int iKey = HBaseSerDe.parseColumnMapping(hbaseColumnsMapping, hbaseColumnFamilies, hbaseColumnFamiliesBytes, hbaseColumnQualifiers, hbaseColumnQualifiersBytes);
            if (!this.getHBaseAdmin().tableExists(tableName)) {
                if (isExternal) throw new MetaException("HBase table " + tableName + " doesn't exist while the table is declared as an external table.");
                tableDesc = new HTableDescriptor(tableName);
                HashSet<String> uniqueColumnFamilies = new HashSet<String>(hbaseColumnFamilies);
                uniqueColumnFamilies.remove(hbaseColumnFamilies.get(iKey));
                for (String columnFamily : uniqueColumnFamilies) {
                    tableDesc.addFamily(new HColumnDescriptor(Bytes.toBytes((String)columnFamily)));
                }
                this.getHBaseAdmin().createTable(tableDesc);
            } else {
                if (!isExternal) {
                    throw new MetaException("Table " + tableName + " already exists" + " within HBase; use CREATE EXTERNAL TABLE instead to" + " register it in Hive.");
                }
                tableDesc = this.getHBaseAdmin().getTableDescriptor(Bytes.toBytes((String)tableName));
                for (int i = 0; i < hbaseColumnFamilies.size(); ++i) {
                    if (i == iKey || tableDesc.hasFamily((byte[])hbaseColumnFamiliesBytes.get(i))) continue;
                    throw new MetaException("Column Family " + (String)hbaseColumnFamilies.get(i) + " is not defined in hbase table " + tableName);
                }
            }
            new HTable((Configuration)this.hbaseConf, tableDesc.getName());
            return;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
        catch (SerDeException se) {
            throw new MetaException(StringUtils.stringifyException((Throwable)se));
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getHBaseTableName(table);
        try {
            if (!isExternal && this.getHBaseAdmin().tableExists(tableName)) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public Configuration getConf() {
        return this.hbaseConf;
    }

    public void setConf(Configuration conf) {
        this.hbaseConf = new HBaseConfiguration(conf);
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveHBaseTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveHBaseTableOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return HBaseSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        jobProperties.put("hbase.columns.mapping", tableProperties.getProperty("hbase.columns.mapping"));
        String tableName = tableProperties.getProperty("hbase.table.name");
        if (tableName == null) {
            tableName = tableProperties.getProperty("name");
        }
        jobProperties.put("hbase.table.name", tableName);
    }

    public HiveStoragePredicateHandler.DecomposedPredicate decomposePredicate(JobConf jobConf, Deserializer deserializer, ExprNodeDesc predicate) {
        String columnNameProperty = jobConf.get("columns");
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        HBaseSerDe hbaseSerde = (HBaseSerDe)deserializer;
        IndexPredicateAnalyzer analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(columnNames.get(hbaseSerde.getKeyColumnOffset()));
        ArrayList searchConditions = new ArrayList();
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(predicate, searchConditions);
        if (searchConditions.size() != 1) {
            return null;
        }
        HiveStoragePredicateHandler.DecomposedPredicate decomposedPredicate = new HiveStoragePredicateHandler.DecomposedPredicate();
        decomposedPredicate.pushedPredicate = analyzer.translateSearchConditions(searchConditions);
        decomposedPredicate.residualPredicate = residualPredicate;
        return decomposedPredicate;
    }
}

