/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.BinaryComparator;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilter;
import org.apache.hadoop.hbase.filter.WhileMatchFilter;
import org.apache.hadoop.hbase.filter.WritableByteArrayComparable;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableInputFormatBase;
import org.apache.hadoop.hbase.mapreduce.TableSplit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HBaseSplit;
import org.apache.hadoop.hive.ql.exec.ExprNodeConstantEvaluator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.index.IndexPredicateAnalyzer;
import org.apache.hadoop.hive.ql.index.IndexSearchCondition;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.ExprNodeDesc;
import org.apache.hadoop.hive.serde2.ByteStream;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskAttemptID;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;

public class HiveHBaseTableInputFormat
extends TableInputFormatBase
implements InputFormat<ImmutableBytesWritable, Result> {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableInputFormat.class);

    public org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, Result> getRecordReader(InputSplit split, JobConf jobConf, final Reporter reporter) throws IOException {
        int iKey;
        HBaseSplit hbaseSplit = (HBaseSplit)split;
        TableSplit tableSplit = hbaseSplit.getSplit();
        String hbaseTableName = jobConf.get("hbase.table.name");
        this.setHTable(new HTable((Configuration)new HBaseConfiguration((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName)));
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        ArrayList<String> hbaseColumnFamilies = new ArrayList<String>();
        ArrayList<String> hbaseColumnQualifiers = new ArrayList<String>();
        ArrayList<byte[]> hbaseColumnFamiliesBytes = new ArrayList<byte[]>();
        ArrayList<byte[]> hbaseColumnQualifiersBytes = new ArrayList<byte[]>();
        try {
            iKey = HBaseSerDe.parseColumnMapping(hbaseColumnsMapping, hbaseColumnFamilies, hbaseColumnFamiliesBytes, hbaseColumnQualifiers, hbaseColumnQualifiersBytes);
        }
        catch (SerDeException se) {
            throw new IOException(se);
        }
        ArrayList readColIDs = ColumnProjectionUtils.getReadColumnIDs((Configuration)jobConf);
        if (hbaseColumnFamilies.size() < readColIDs.size()) {
            throw new IOException("Cannot read more columns than the given table contains.");
        }
        boolean addAll = readColIDs.size() == 0;
        Scan scan = new Scan();
        boolean empty = true;
        if (!addAll) {
            Iterator i$ = readColIDs.iterator();
            while (i$.hasNext()) {
                int i = (Integer)i$.next();
                if (i == iKey) continue;
                if (hbaseColumnQualifiers.get(i) == null) {
                    scan.addFamily((byte[])hbaseColumnFamiliesBytes.get(i));
                } else {
                    scan.addColumn((byte[])hbaseColumnFamiliesBytes.get(i), (byte[])hbaseColumnQualifiersBytes.get(i));
                }
                empty = false;
            }
        }
        if (empty) {
            for (int i = 0; i < hbaseColumnFamilies.size(); ++i) {
                if (i == iKey) continue;
                if (hbaseColumnQualifiers.get(i) == null) {
                    scan.addFamily((byte[])hbaseColumnFamiliesBytes.get(i));
                } else {
                    scan.addColumn((byte[])hbaseColumnFamiliesBytes.get(i), (byte[])hbaseColumnQualifiersBytes.get(i));
                }
                if (!addAll) break;
            }
        }
        tableSplit = this.convertFilter(jobConf, scan, tableSplit, iKey);
        this.setScan(scan);
        Job job = new Job((Configuration)jobConf);
        TaskAttemptContext tac = new TaskAttemptContext(job.getConfiguration(), new TaskAttemptID()){

            public void progress() {
                reporter.progress();
            }
        };
        final RecordReader recordReader = this.createRecordReader((org.apache.hadoop.mapreduce.InputSplit)tableSplit, tac);
        return new org.apache.hadoop.mapred.RecordReader<ImmutableBytesWritable, Result>(){

            public void close() throws IOException {
                recordReader.close();
            }

            public ImmutableBytesWritable createKey() {
                return new ImmutableBytesWritable();
            }

            public Result createValue() {
                return new Result();
            }

            public long getPos() throws IOException {
                return 0L;
            }

            public float getProgress() throws IOException {
                float progress = 0.0f;
                try {
                    progress = recordReader.getProgress();
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return progress;
            }

            public boolean next(ImmutableBytesWritable rowKey, Result value) throws IOException {
                boolean next = false;
                try {
                    next = recordReader.nextKeyValue();
                    if (next) {
                        rowKey.set(((Result)recordReader.getCurrentValue()).getRow());
                        Writables.copyWritable((Writable)((Writable)recordReader.getCurrentValue()), (Writable)value);
                    }
                }
                catch (InterruptedException e) {
                    throw new IOException(e);
                }
                return next;
            }
        };
    }

    private TableSplit convertFilter(JobConf jobConf, Scan scan, TableSplit tableSplit, int iKey) throws IOException {
        byte[] startRow;
        ArrayList searchConditions;
        String filterExprSerialized = jobConf.get("hive.io.filter.expr.serialized");
        if (filterExprSerialized == null) {
            return tableSplit;
        }
        ExprNodeDesc filterExpr = Utilities.deserializeExpression((String)filterExprSerialized, (Configuration)jobConf);
        String columnNameProperty = jobConf.get("columns");
        List<String> columnNames = Arrays.asList(columnNameProperty.split(","));
        IndexPredicateAnalyzer analyzer = HiveHBaseTableInputFormat.newIndexPredicateAnalyzer(columnNames.get(iKey));
        ExprNodeDesc residualPredicate = analyzer.analyzePredicate(filterExpr, searchConditions = new ArrayList());
        if (residualPredicate != null) {
            throw new RuntimeException("Unexpected residual predicate " + residualPredicate.getExprString());
        }
        if (searchConditions.size() != 1) {
            throw new RuntimeException("Exactly one search condition expected in push down");
        }
        IndexSearchCondition sc = (IndexSearchCondition)searchConditions.get(0);
        ExprNodeConstantEvaluator eval = new ExprNodeConstantEvaluator(sc.getConstantDesc());
        try {
            ObjectInspector objInspector = eval.initialize(null);
            Object writable = eval.evaluate(null);
            ByteStream.Output serializeStream = new ByteStream.Output();
            LazyUtils.writePrimitiveUTF8((OutputStream)serializeStream, (Object)writable, (PrimitiveObjectInspector)((PrimitiveObjectInspector)objInspector), (boolean)false, (byte)0, null);
            startRow = new byte[serializeStream.getCount()];
            System.arraycopy(serializeStream.getData(), 0, startRow, 0, serializeStream.getCount());
        }
        catch (HiveException ex) {
            throw new IOException(ex);
        }
        byte[] stopRow = new byte[startRow.length + 1];
        System.arraycopy(startRow, 0, stopRow, 0, startRow.length);
        if (tableSplit != null) {
            tableSplit = new TableSplit(tableSplit.getTableName(), startRow, stopRow, tableSplit.getRegionLocation());
        }
        scan.setStartRow(startRow);
        scan.setStopRow(stopRow);
        scan.setFilter((Filter)new WhileMatchFilter((Filter)new RowFilter(CompareFilter.CompareOp.EQUAL, (WritableByteArrayComparable)new BinaryComparator(startRow))));
        return tableSplit;
    }

    static IndexPredicateAnalyzer newIndexPredicateAnalyzer(String keyColumnName) {
        IndexPredicateAnalyzer analyzer = new IndexPredicateAnalyzer();
        analyzer.addComparisonOp("org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPEqual");
        analyzer.clearAllowedColumnNames();
        analyzer.allowColumnName(keyColumnName);
        return analyzer;
    }

    public InputSplit[] getSplits(JobConf jobConf, int numSplits) throws IOException {
        int iKey;
        String hbaseTableName = jobConf.get("hbase.table.name");
        this.setHTable(new HTable((Configuration)new HBaseConfiguration((Configuration)jobConf), Bytes.toBytes((String)hbaseTableName)));
        String hbaseColumnsMapping = jobConf.get("hbase.columns.mapping");
        if (hbaseColumnsMapping == null) {
            throw new IOException("hbase.columns.mapping required for HBase Table.");
        }
        ArrayList<String> hbaseColumnFamilies = new ArrayList<String>();
        ArrayList<String> hbaseColumnQualifiers = new ArrayList<String>();
        ArrayList<byte[]> hbaseColumnFamiliesBytes = new ArrayList<byte[]>();
        ArrayList<byte[]> hbaseColumnQualifiersBytes = new ArrayList<byte[]>();
        try {
            iKey = HBaseSerDe.parseColumnMapping(hbaseColumnsMapping, hbaseColumnFamilies, hbaseColumnFamiliesBytes, hbaseColumnQualifiers, hbaseColumnQualifiersBytes);
        }
        catch (SerDeException se) {
            throw new IOException(se);
        }
        Scan scan = new Scan();
        this.convertFilter(jobConf, scan, null, iKey);
        for (int i = 0; i < hbaseColumnFamilies.size(); ++i) {
            if (i == iKey) continue;
            if (hbaseColumnQualifiers.get(i) == null) {
                scan.addFamily((byte[])hbaseColumnFamiliesBytes.get(i));
                continue;
            }
            scan.addColumn((byte[])hbaseColumnFamiliesBytes.get(i), (byte[])hbaseColumnQualifiersBytes.get(i));
        }
        this.setScan(scan);
        Job job = new Job((Configuration)jobConf);
        JobContext jobContext = new JobContext(job.getConfiguration(), job.getJobID());
        Path[] tablePaths = FileInputFormat.getInputPaths((JobContext)jobContext);
        List splits = super.getSplits(jobContext);
        InputSplit[] results = new InputSplit[splits.size()];
        for (int i = 0; i < splits.size(); ++i) {
            results[i] = new HBaseSplit((TableSplit)splits.get(i), tablePaths[0]);
        }
        return results;
    }
}

