/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.mapreduce.TableOutputFormat;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.RecordWriter;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.util.Progressable;

public class HiveHBaseTableOutputFormat
extends TableOutputFormat<ImmutableBytesWritable>
implements HiveOutputFormat<ImmutableBytesWritable, Put>,
OutputFormat<ImmutableBytesWritable, Put> {
    static final Log LOG = LogFactory.getLog(HiveHBaseTableOutputFormat.class);
    public static final String HBASE_WAL_ENABLED = "hive.hbase.wal.enabled";

    public FileSinkOperator.RecordWriter getHiveRecordWriter(JobConf jc, Path finalOutPath, Class<? extends Writable> valueClass, boolean isCompressed, Properties tableProperties, Progressable progressable) throws IOException {
        String hbaseTableName = jc.get("hbase.table.name");
        jc.set("hbase.mapred.outputtable", hbaseTableName);
        final boolean walEnabled = HiveConf.getBoolVar((Configuration)jc, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_HBASE_WAL_ENABLED);
        final HTable table = new HTable((Configuration)new HBaseConfiguration((Configuration)jc), hbaseTableName);
        table.setAutoFlush(false);
        return new FileSinkOperator.RecordWriter(){

            public void close(boolean abort) throws IOException {
                if (!abort) {
                    table.flushCommits();
                }
            }

            public void write(Writable w) throws IOException {
                Put put = (Put)w;
                put.setWriteToWAL(walEnabled);
                table.put(put);
            }
        };
    }

    public void checkOutputSpecs(FileSystem fs, JobConf jc) throws IOException {
        String hbaseTableName = jc.get("hbase.table.name");
        jc.set("hbase.mapred.outputtable", hbaseTableName);
        Job job = new Job((Configuration)jc);
        JobContext jobContext = new JobContext(job.getConfiguration(), job.getJobID());
        try {
            this.checkOutputSpecs(jobContext);
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
    }

    public RecordWriter<ImmutableBytesWritable, Put> getRecordWriter(FileSystem fileSystem, JobConf jobConf, String name, Progressable progressable) throws IOException {
        throw new RuntimeException("Error: Hive should not invoke this method.");
    }
}

