/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyMap;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyPrimitive;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.io.Writable;

public class LazyHBaseCellMap
extends LazyMap {
    private Result result;
    private byte[] columnFamilyBytes;

    public LazyHBaseCellMap(LazyMapObjectInspector oi) {
        super(oi);
    }

    public void init(Result r, byte[] columnFamilyBytes) {
        this.result = r;
        this.columnFamilyBytes = columnFamilyBytes;
        this.setParsed(false);
    }

    private void parse() {
        if (this.cachedMap == null) {
            this.cachedMap = new LinkedHashMap();
        } else {
            this.cachedMap.clear();
        }
        NavigableMap familyMap = this.result.getFamilyMap(this.columnFamilyBytes);
        if (familyMap != null) {
            for (Map.Entry e : familyMap.entrySet()) {
                if (e.getValue() == null || ((byte[])e.getValue()).length == 0) continue;
                LazyPrimitive key = LazyFactory.createLazyPrimitiveClass((PrimitiveObjectInspector)((PrimitiveObjectInspector)((LazyMapObjectInspector)this.getInspector()).getMapKeyObjectInspector()));
                ByteArrayRef keyRef = new ByteArrayRef();
                keyRef.setData((byte[])e.getKey());
                key.init(keyRef, 0, keyRef.getData().length);
                LazyObject value = LazyFactory.createLazyObject((ObjectInspector)((LazyMapObjectInspector)this.getInspector()).getMapValueObjectInspector());
                ByteArrayRef valueRef = new ByteArrayRef();
                valueRef.setData((byte[])e.getValue());
                value.init(valueRef, 0, valueRef.getData().length);
                this.cachedMap.put(key.getObject(), value.getObject());
            }
        }
        this.setParsed(true);
    }

    public Object getMapValueElement(Object key) {
        if (!this.getParsed()) {
            this.parse();
        }
        for (Map.Entry entry : this.cachedMap.entrySet()) {
            LazyPrimitive lazyKeyI = (LazyPrimitive)entry.getKey();
            Writable keyI = lazyKeyI.getWritableObject();
            if (keyI == null || !keyI.equals(key)) continue;
            LazyObject v = (LazyObject)entry.getValue();
            return v == null ? v : v.getObject();
        }
        return null;
    }

    public Map<Object, Object> getMap() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap;
    }

    public int getMapSize() {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.cachedMap.size();
    }
}

