/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.LazyHBaseCellMap;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazyMapObjectInspector;
import org.apache.hadoop.hive.serde2.lazy.objectinspector.LazySimpleStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class LazyHBaseRow
extends LazyStruct {
    private Result result;
    private List<String> hbaseColumnFamilies;
    private List<byte[]> hbaseColumnFamiliesBytes;
    private List<String> hbaseColumnQualifiers;
    private List<byte[]> hbaseColumnQualifiersBytes;
    private ArrayList<Object> cachedList;

    public LazyHBaseRow(LazySimpleStructObjectInspector oi) {
        super(oi);
    }

    public void init(Result r, List<String> hbaseColumnFamilies, List<byte[]> hbaseColumnFamiliesBytes, List<String> hbaseColumnQualifiers, List<byte[]> hbaseColumnQualifiersBytes) {
        this.result = r;
        this.hbaseColumnFamilies = hbaseColumnFamilies;
        this.hbaseColumnFamiliesBytes = hbaseColumnFamiliesBytes;
        this.hbaseColumnQualifiers = hbaseColumnQualifiers;
        this.hbaseColumnQualifiersBytes = hbaseColumnQualifiersBytes;
        this.setParsed(false);
    }

    private void parse() {
        if (this.getFields() == null) {
            List fieldRefs = ((StructObjectInspector)this.getInspector()).getAllStructFieldRefs();
            this.setFields(new LazyObject[fieldRefs.size()]);
            for (int i = 0; i < this.getFields().length; ++i) {
                String hbaseColumnFamily = this.hbaseColumnFamilies.get(i);
                String hbaseColumnQualifier = this.hbaseColumnQualifiers.get(i);
                this.getFields()[i] = hbaseColumnQualifier == null && !HBaseSerDe.isSpecialColumn(hbaseColumnFamily) ? new LazyHBaseCellMap((LazyMapObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector()) : LazyFactory.createLazyObject((ObjectInspector)((StructField)fieldRefs.get(i)).getFieldObjectInspector());
            }
            this.setFieldInited(new boolean[this.getFields().length]);
        }
        Arrays.fill(this.getFieldInited(), false);
        this.setParsed(true);
    }

    public Object getField(int fieldID) {
        if (!this.getParsed()) {
            this.parse();
        }
        return this.uncheckedGetField(fieldID);
    }

    private Object uncheckedGetField(int fieldID) {
        if (!this.getFieldInited()[fieldID]) {
            this.getFieldInited()[fieldID] = true;
            ByteArrayRef ref = null;
            String columnFamily = this.hbaseColumnFamilies.get(fieldID);
            String columnQualifier = this.hbaseColumnQualifiers.get(fieldID);
            byte[] columnFamilyBytes = this.hbaseColumnFamiliesBytes.get(fieldID);
            byte[] columnQualifierBytes = this.hbaseColumnQualifiersBytes.get(fieldID);
            if (HBaseSerDe.isSpecialColumn(columnFamily)) {
                assert (columnQualifier == null);
                ref = new ByteArrayRef();
                ref.setData(this.result.getRow());
            } else if (columnQualifier == null) {
                ((LazyHBaseCellMap)this.getFields()[fieldID]).init(this.result, columnFamilyBytes);
            } else {
                byte[] res = this.result.getValue(columnFamilyBytes, columnQualifierBytes);
                if (res == null) {
                    return null;
                }
                ref = new ByteArrayRef();
                ref.setData(res);
            }
            if (ref != null) {
                this.getFields()[fieldID].init(ref, 0, ref.getData().length);
            }
        }
        return this.getFields()[fieldID].getObject();
    }

    public ArrayList<Object> getFieldsAsList() {
        if (!this.getParsed()) {
            this.parse();
        }
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.getFields().length; ++i) {
            this.cachedList.add(this.uncheckedGetField(i));
        }
        return this.cachedList;
    }

    public Object getObject() {
        return this;
    }
}

