/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.api;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.metastore.api.HiveObjectType;
import org.apache.thrift.TBase;
import org.apache.thrift.TBaseHelper;
import org.apache.thrift.TException;
import org.apache.thrift.TFieldIdEnum;
import org.apache.thrift.meta_data.EnumMetaData;
import org.apache.thrift.meta_data.FieldMetaData;
import org.apache.thrift.meta_data.FieldValueMetaData;
import org.apache.thrift.meta_data.ListMetaData;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TList;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolUtil;
import org.apache.thrift.protocol.TStruct;

public class HiveObjectRef
implements TBase<HiveObjectRef, _Fields>,
Serializable,
Cloneable {
    private static final TStruct STRUCT_DESC = new TStruct("HiveObjectRef");
    private static final TField OBJECT_TYPE_FIELD_DESC = new TField("objectType", 8, 1);
    private static final TField DB_NAME_FIELD_DESC = new TField("dbName", 11, 2);
    private static final TField OBJECT_NAME_FIELD_DESC = new TField("objectName", 11, 3);
    private static final TField PART_VALUES_FIELD_DESC = new TField("partValues", 15, 4);
    private static final TField COLUMN_NAME_FIELD_DESC = new TField("columnName", 11, 5);
    private HiveObjectType objectType;
    private String dbName;
    private String objectName;
    private List<String> partValues;
    private String columnName;
    public static final Map<_Fields, FieldMetaData> metaDataMap;

    public HiveObjectRef() {
    }

    public HiveObjectRef(HiveObjectType objectType, String dbName, String objectName, List<String> partValues, String columnName) {
        this();
        this.objectType = objectType;
        this.dbName = dbName;
        this.objectName = objectName;
        this.partValues = partValues;
        this.columnName = columnName;
    }

    public HiveObjectRef(HiveObjectRef other) {
        if (other.isSetObjectType()) {
            this.objectType = other.objectType;
        }
        if (other.isSetDbName()) {
            this.dbName = other.dbName;
        }
        if (other.isSetObjectName()) {
            this.objectName = other.objectName;
        }
        if (other.isSetPartValues()) {
            ArrayList<String> __this__partValues = new ArrayList<String>();
            for (String other_element : other.partValues) {
                __this__partValues.add(other_element);
            }
            this.partValues = __this__partValues;
        }
        if (other.isSetColumnName()) {
            this.columnName = other.columnName;
        }
    }

    public HiveObjectRef deepCopy() {
        return new HiveObjectRef(this);
    }

    public void clear() {
        this.objectType = null;
        this.dbName = null;
        this.objectName = null;
        this.partValues = null;
        this.columnName = null;
    }

    public HiveObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(HiveObjectType objectType) {
        this.objectType = objectType;
    }

    public void unsetObjectType() {
        this.objectType = null;
    }

    public boolean isSetObjectType() {
        return this.objectType != null;
    }

    public void setObjectTypeIsSet(boolean value) {
        if (!value) {
            this.objectType = null;
        }
    }

    public String getDbName() {
        return this.dbName;
    }

    public void setDbName(String dbName) {
        this.dbName = dbName;
    }

    public void unsetDbName() {
        this.dbName = null;
    }

    public boolean isSetDbName() {
        return this.dbName != null;
    }

    public void setDbNameIsSet(boolean value) {
        if (!value) {
            this.dbName = null;
        }
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public void unsetObjectName() {
        this.objectName = null;
    }

    public boolean isSetObjectName() {
        return this.objectName != null;
    }

    public void setObjectNameIsSet(boolean value) {
        if (!value) {
            this.objectName = null;
        }
    }

    public int getPartValuesSize() {
        return this.partValues == null ? 0 : this.partValues.size();
    }

    public Iterator<String> getPartValuesIterator() {
        return this.partValues == null ? null : this.partValues.iterator();
    }

    public void addToPartValues(String elem) {
        if (this.partValues == null) {
            this.partValues = new ArrayList<String>();
        }
        this.partValues.add(elem);
    }

    public List<String> getPartValues() {
        return this.partValues;
    }

    public void setPartValues(List<String> partValues) {
        this.partValues = partValues;
    }

    public void unsetPartValues() {
        this.partValues = null;
    }

    public boolean isSetPartValues() {
        return this.partValues != null;
    }

    public void setPartValuesIsSet(boolean value) {
        if (!value) {
            this.partValues = null;
        }
    }

    public String getColumnName() {
        return this.columnName;
    }

    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    public void unsetColumnName() {
        this.columnName = null;
    }

    public boolean isSetColumnName() {
        return this.columnName != null;
    }

    public void setColumnNameIsSet(boolean value) {
        if (!value) {
            this.columnName = null;
        }
    }

    public void setFieldValue(_Fields field, Object value) {
        switch (field) {
            case OBJECT_TYPE: {
                if (value == null) {
                    this.unsetObjectType();
                    break;
                }
                this.setObjectType((HiveObjectType)((Object)value));
                break;
            }
            case DB_NAME: {
                if (value == null) {
                    this.unsetDbName();
                    break;
                }
                this.setDbName((String)value);
                break;
            }
            case OBJECT_NAME: {
                if (value == null) {
                    this.unsetObjectName();
                    break;
                }
                this.setObjectName((String)value);
                break;
            }
            case PART_VALUES: {
                if (value == null) {
                    this.unsetPartValues();
                    break;
                }
                this.setPartValues((List)value);
                break;
            }
            case COLUMN_NAME: {
                if (value == null) {
                    this.unsetColumnName();
                    break;
                }
                this.setColumnName((String)value);
            }
        }
    }

    public Object getFieldValue(_Fields field) {
        switch (field) {
            case OBJECT_TYPE: {
                return this.getObjectType();
            }
            case DB_NAME: {
                return this.getDbName();
            }
            case OBJECT_NAME: {
                return this.getObjectName();
            }
            case PART_VALUES: {
                return this.getPartValues();
            }
            case COLUMN_NAME: {
                return this.getColumnName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean isSet(_Fields field) {
        if (field == null) {
            throw new IllegalArgumentException();
        }
        switch (field) {
            case OBJECT_TYPE: {
                return this.isSetObjectType();
            }
            case DB_NAME: {
                return this.isSetDbName();
            }
            case OBJECT_NAME: {
                return this.isSetObjectName();
            }
            case PART_VALUES: {
                return this.isSetPartValues();
            }
            case COLUMN_NAME: {
                return this.isSetColumnName();
            }
        }
        throw new IllegalStateException();
    }

    public boolean equals(Object that) {
        if (that == null) {
            return false;
        }
        if (that instanceof HiveObjectRef) {
            return this.equals((HiveObjectRef)that);
        }
        return false;
    }

    public boolean equals(HiveObjectRef that) {
        if (that == null) {
            return false;
        }
        boolean this_present_objectType = this.isSetObjectType();
        boolean that_present_objectType = that.isSetObjectType();
        if (this_present_objectType || that_present_objectType) {
            if (!this_present_objectType || !that_present_objectType) {
                return false;
            }
            if (!this.objectType.equals((Object)that.objectType)) {
                return false;
            }
        }
        boolean this_present_dbName = this.isSetDbName();
        boolean that_present_dbName = that.isSetDbName();
        if (this_present_dbName || that_present_dbName) {
            if (!this_present_dbName || !that_present_dbName) {
                return false;
            }
            if (!this.dbName.equals(that.dbName)) {
                return false;
            }
        }
        boolean this_present_objectName = this.isSetObjectName();
        boolean that_present_objectName = that.isSetObjectName();
        if (this_present_objectName || that_present_objectName) {
            if (!this_present_objectName || !that_present_objectName) {
                return false;
            }
            if (!this.objectName.equals(that.objectName)) {
                return false;
            }
        }
        boolean this_present_partValues = this.isSetPartValues();
        boolean that_present_partValues = that.isSetPartValues();
        if (this_present_partValues || that_present_partValues) {
            if (!this_present_partValues || !that_present_partValues) {
                return false;
            }
            if (!((Object)this.partValues).equals(that.partValues)) {
                return false;
            }
        }
        boolean this_present_columnName = this.isSetColumnName();
        boolean that_present_columnName = that.isSetColumnName();
        if (this_present_columnName || that_present_columnName) {
            if (!this_present_columnName || !that_present_columnName) {
                return false;
            }
            if (!this.columnName.equals(that.columnName)) {
                return false;
            }
        }
        return true;
    }

    public int hashCode() {
        return 0;
    }

    public int compareTo(HiveObjectRef other) {
        if (!this.getClass().equals(other.getClass())) {
            return this.getClass().getName().compareTo(other.getClass().getName());
        }
        int lastComparison = 0;
        HiveObjectRef typedOther = other;
        lastComparison = Boolean.valueOf(this.isSetObjectType()).compareTo(typedOther.isSetObjectType());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetObjectType() && (lastComparison = TBaseHelper.compareTo((Comparable)((Object)this.objectType), (Comparable)((Object)typedOther.objectType))) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetDbName()).compareTo(typedOther.isSetDbName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetDbName() && (lastComparison = TBaseHelper.compareTo((String)this.dbName, (String)typedOther.dbName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetObjectName()).compareTo(typedOther.isSetObjectName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetObjectName() && (lastComparison = TBaseHelper.compareTo((String)this.objectName, (String)typedOther.objectName)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetPartValues()).compareTo(typedOther.isSetPartValues());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetPartValues() && (lastComparison = TBaseHelper.compareTo(this.partValues, typedOther.partValues)) != 0) {
            return lastComparison;
        }
        lastComparison = Boolean.valueOf(this.isSetColumnName()).compareTo(typedOther.isSetColumnName());
        if (lastComparison != 0) {
            return lastComparison;
        }
        if (this.isSetColumnName() && (lastComparison = TBaseHelper.compareTo((String)this.columnName, (String)typedOther.columnName)) != 0) {
            return lastComparison;
        }
        return 0;
    }

    public _Fields fieldForId(int fieldId) {
        return _Fields.findByThriftId(fieldId);
    }

    public void read(TProtocol iprot) throws TException {
        iprot.readStructBegin();
        while (true) {
            TField field = iprot.readFieldBegin();
            if (field.type == 0) break;
            switch (field.id) {
                case 1: {
                    if (field.type == 8) {
                        this.objectType = HiveObjectType.findByValue(iprot.readI32());
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 2: {
                    if (field.type == 11) {
                        this.dbName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 3: {
                    if (field.type == 11) {
                        this.objectName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 4: {
                    if (field.type == 15) {
                        TList _list4 = iprot.readListBegin();
                        this.partValues = new ArrayList<String>(_list4.size);
                        for (int _i5 = 0; _i5 < _list4.size; ++_i5) {
                            String _elem6 = iprot.readString();
                            this.partValues.add(_elem6);
                        }
                        iprot.readListEnd();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                case 5: {
                    if (field.type == 11) {
                        this.columnName = iprot.readString();
                        break;
                    }
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                    break;
                }
                default: {
                    TProtocolUtil.skip((TProtocol)iprot, (byte)field.type);
                }
            }
            iprot.readFieldEnd();
        }
        iprot.readStructEnd();
        this.validate();
    }

    public void write(TProtocol oprot) throws TException {
        this.validate();
        oprot.writeStructBegin(STRUCT_DESC);
        if (this.objectType != null) {
            oprot.writeFieldBegin(OBJECT_TYPE_FIELD_DESC);
            oprot.writeI32(this.objectType.getValue());
            oprot.writeFieldEnd();
        }
        if (this.dbName != null) {
            oprot.writeFieldBegin(DB_NAME_FIELD_DESC);
            oprot.writeString(this.dbName);
            oprot.writeFieldEnd();
        }
        if (this.objectName != null) {
            oprot.writeFieldBegin(OBJECT_NAME_FIELD_DESC);
            oprot.writeString(this.objectName);
            oprot.writeFieldEnd();
        }
        if (this.partValues != null) {
            oprot.writeFieldBegin(PART_VALUES_FIELD_DESC);
            oprot.writeListBegin(new TList(11, this.partValues.size()));
            for (String _iter7 : this.partValues) {
                oprot.writeString(_iter7);
            }
            oprot.writeListEnd();
            oprot.writeFieldEnd();
        }
        if (this.columnName != null) {
            oprot.writeFieldBegin(COLUMN_NAME_FIELD_DESC);
            oprot.writeString(this.columnName);
            oprot.writeFieldEnd();
        }
        oprot.writeFieldStop();
        oprot.writeStructEnd();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("HiveObjectRef(");
        boolean first = true;
        sb.append("objectType:");
        if (this.objectType == null) {
            sb.append("null");
        } else {
            sb.append((Object)this.objectType);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("dbName:");
        if (this.dbName == null) {
            sb.append("null");
        } else {
            sb.append(this.dbName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("objectName:");
        if (this.objectName == null) {
            sb.append("null");
        } else {
            sb.append(this.objectName);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("partValues:");
        if (this.partValues == null) {
            sb.append("null");
        } else {
            sb.append(this.partValues);
        }
        first = false;
        if (!first) {
            sb.append(", ");
        }
        sb.append("columnName:");
        if (this.columnName == null) {
            sb.append("null");
        } else {
            sb.append(this.columnName);
        }
        first = false;
        sb.append(")");
        return sb.toString();
    }

    public void validate() throws TException {
    }

    static {
        EnumMap<_Fields, FieldMetaData> tmpMap = new EnumMap<_Fields, FieldMetaData>(_Fields.class);
        tmpMap.put(_Fields.OBJECT_TYPE, new FieldMetaData("objectType", 3, (FieldValueMetaData)new EnumMetaData(16, HiveObjectType.class)));
        tmpMap.put(_Fields.DB_NAME, new FieldMetaData("dbName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.OBJECT_NAME, new FieldMetaData("objectName", 3, new FieldValueMetaData(11)));
        tmpMap.put(_Fields.PART_VALUES, new FieldMetaData("partValues", 3, (FieldValueMetaData)new ListMetaData(15, new FieldValueMetaData(11))));
        tmpMap.put(_Fields.COLUMN_NAME, new FieldMetaData("columnName", 3, new FieldValueMetaData(11)));
        metaDataMap = Collections.unmodifiableMap(tmpMap);
        FieldMetaData.addStructMetaDataMap(HiveObjectRef.class, metaDataMap);
    }

    public static enum _Fields implements TFieldIdEnum
    {
        OBJECT_TYPE(1, "objectType"),
        DB_NAME(2, "dbName"),
        OBJECT_NAME(3, "objectName"),
        PART_VALUES(4, "partValues"),
        COLUMN_NAME(5, "columnName");

        private static final Map<String, _Fields> byName;
        private final short _thriftId;
        private final String _fieldName;

        public static _Fields findByThriftId(int fieldId) {
            switch (fieldId) {
                case 1: {
                    return OBJECT_TYPE;
                }
                case 2: {
                    return DB_NAME;
                }
                case 3: {
                    return OBJECT_NAME;
                }
                case 4: {
                    return PART_VALUES;
                }
                case 5: {
                    return COLUMN_NAME;
                }
            }
            return null;
        }

        public static _Fields findByThriftIdOrThrow(int fieldId) {
            _Fields fields = _Fields.findByThriftId(fieldId);
            if (fields == null) {
                throw new IllegalArgumentException("Field " + fieldId + " doesn't exist!");
            }
            return fields;
        }

        public static _Fields findByName(String name) {
            return byName.get(name);
        }

        private _Fields(short thriftId, String fieldName) {
            this._thriftId = thriftId;
            this._fieldName = fieldName;
        }

        public short getThriftFieldId() {
            return this._thriftId;
        }

        public String getFieldName() {
            return this._fieldName;
        }

        static {
            byName = new HashMap<String, _Fields>();
            for (_Fields field : EnumSet.allOf(_Fields.class)) {
                byName.put(field.getFieldName(), field);
            }
        }
    }
}

