/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.columnar;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.columnar.BytesRefArrayWritable;
import org.apache.hadoop.hive.serde2.columnar.BytesRefWritable;
import org.apache.hadoop.hive.serde2.lazy.ByteArrayRef;
import org.apache.hadoop.hive.serde2.lazy.LazyFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyObject;
import org.apache.hadoop.hive.serde2.lazy.LazyUtils;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;

public class ColumnarStruct {
    private static final Log LOG = LogFactory.getLog(ColumnarStruct.class);
    int[] prjColIDs = null;
    Text nullSequence;
    int lengthNullSequence;
    FieldInfo[] fieldInfoList = null;
    ArrayList<Object> cachedList;

    public ColumnarStruct(ObjectInspector oi) {
        this(oi, null, null);
    }

    public ColumnarStruct(ObjectInspector oi, ArrayList<Integer> notSkippedColumnIDs, Text nullSequence) {
        int i;
        List<? extends StructField> fieldRefs = ((StructObjectInspector)oi).getAllStructFieldRefs();
        int num = fieldRefs.size();
        this.fieldInfoList = new FieldInfo[num];
        if (nullSequence != null) {
            this.nullSequence = nullSequence;
            this.lengthNullSequence = nullSequence.getLength();
        }
        if (notSkippedColumnIDs == null || notSkippedColumnIDs.size() == 0) {
            for (i = 0; i < num; ++i) {
                notSkippedColumnIDs.add(i);
            }
        }
        for (i = 0; i < num; ++i) {
            this.fieldInfoList[i] = new FieldInfo(LazyFactory.createLazyObject(fieldRefs.get(i).getFieldObjectInspector()), !notSkippedColumnIDs.contains(i));
        }
        int min = notSkippedColumnIDs.size() > num ? num : notSkippedColumnIDs.size();
        this.prjColIDs = new int[min];
        int index = 0;
        for (int i2 = 0; i2 < notSkippedColumnIDs.size(); ++i2) {
            int readCol = notSkippedColumnIDs.get(i2);
            if (readCol >= num) continue;
            this.prjColIDs[index] = readCol;
            ++index;
        }
    }

    public Object getField(int fieldID) {
        return this.fieldInfoList[fieldID].uncheckedGetField();
    }

    public void init(BytesRefArrayWritable cols) {
        for (int i = 0; i < this.prjColIDs.length; ++i) {
            int fieldIndex = this.prjColIDs[i];
            if (fieldIndex < cols.size()) {
                this.fieldInfoList[fieldIndex].init(cols.unCheckedGet(fieldIndex));
                continue;
            }
            this.fieldInfoList[fieldIndex].init(null);
        }
    }

    public ArrayList<Object> getFieldsAsList() {
        if (this.cachedList == null) {
            this.cachedList = new ArrayList();
        } else {
            this.cachedList.clear();
        }
        for (int i = 0; i < this.fieldInfoList.length; ++i) {
            this.cachedList.add(this.fieldInfoList[i].uncheckedGetField());
        }
        return this.cachedList;
    }

    class FieldInfo {
        LazyObject field;
        ByteArrayRef cachedByteArrayRef;
        BytesRefWritable rawBytesField;
        boolean inited;
        boolean fieldSkipped;

        public FieldInfo(LazyObject lazyObject, boolean fieldSkipped) {
            this.field = lazyObject;
            this.cachedByteArrayRef = new ByteArrayRef();
            if (fieldSkipped) {
                this.fieldSkipped = true;
                this.inited = true;
            } else {
                this.inited = false;
            }
        }

        public void init(BytesRefWritable col) {
            if (col != null) {
                this.rawBytesField = col;
                this.inited = false;
            } else {
                this.fieldSkipped = true;
            }
        }

        protected Object uncheckedGetField() {
            byte[] data;
            int fieldLen;
            if (this.fieldSkipped) {
                return null;
            }
            if (!this.inited) {
                try {
                    this.cachedByteArrayRef.setData(this.rawBytesField.getData());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
                this.field.init(this.cachedByteArrayRef, this.rawBytesField.getStart(), this.rawBytesField.getLength());
                this.inited = true;
            }
            if ((fieldLen = this.rawBytesField.length) == ColumnarStruct.this.lengthNullSequence && LazyUtils.compare(data = this.cachedByteArrayRef.getData(), this.rawBytesField.getStart(), fieldLen, ColumnarStruct.this.nullSequence.getBytes(), 0, ColumnarStruct.this.lengthNullSequence) == 0) {
                return null;
            }
            return this.field.getObject();
        }
    }
}

