/*
 * Decompiled with CFR 0.152.
 */
package py4j;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.CallbackClient;
import py4j.DefaultGatewayServerListener;
import py4j.Gateway;
import py4j.GatewayConnection;
import py4j.GatewayServerListener;
import py4j.NetworkUtil;
import py4j.Py4JNetworkException;
import py4j.commands.Command;

public class GatewayServer
extends DefaultGatewayServerListener
implements Runnable {
    public static final String DEFAULT_ADDRESS = "127.0.0.1";
    public static final int DEFAULT_PORT = 25333;
    public static final int DEFAULT_PYTHON_PORT = 25334;
    public static final int DEFAULT_CONNECT_TIMEOUT = 0;
    public static final int DEFAULT_READ_TIMEOUT = 0;
    public static final String GATEWAY_SERVER_ID = "GATEWAY_SERVER";
    private final InetAddress address;
    private final int port;
    private final int pythonPort;
    private final InetAddress pythonAddress;
    private final Gateway gateway;
    private final int connectTimeout;
    private final int readTimeout;
    private final Logger logger = Logger.getLogger(GatewayServer.class.getName());
    private final List<Socket> connections = new ArrayList<Socket>();
    private final CallbackClient cbClient;
    private final List<Class<? extends Command>> customCommands;
    private final List<GatewayServerListener> listeners;
    private ServerSocket sSocket;
    private boolean isShutdown = false;
    private final Lock lock = new ReentrantLock(true);

    public static void turnAllLoggingOn() {
        Logger.getLogger("py4j").setLevel(Level.ALL);
    }

    public static void turnLoggingOff() {
        Logger.getLogger("py4j").setLevel(Level.OFF);
    }

    public static void turnLoggingOn() {
        Logger.getLogger("py4j").setLevel(Level.INFO);
    }

    public GatewayServer(Object entryPoint) {
        this(entryPoint, 25333, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port) {
        this(entryPoint, port, 0, 0);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, InetAddress address, InetAddress pythonAddress, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this.port = port;
        this.pythonPort = pythonPort;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.customCommands = customCommands;
        this.listeners = new CopyOnWriteArrayList<GatewayServerListener>();
        this.address = address;
        this.pythonAddress = pythonAddress;
        this.cbClient = new CallbackClient(pythonPort, pythonAddress);
        this.gateway = new Gateway(entryPoint, this.cbClient);
        this.gateway.getBindings().put(GATEWAY_SERVER_ID, this);
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout) {
        this(entryPoint, port, 25334, connectTimeout, readTimeout, null);
    }

    public GatewayServer(Object entryPoint, int port, int pythonPort, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands) {
        this.port = port;
        this.pythonPort = pythonPort;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.customCommands = customCommands;
        this.listeners = new CopyOnWriteArrayList<GatewayServerListener>();
        try {
            this.address = InetAddress.getByName(DEFAULT_ADDRESS);
            this.pythonAddress = InetAddress.getByName(DEFAULT_ADDRESS);
        }
        catch (UnknownHostException e) {
            throw new Py4JNetworkException(e);
        }
        this.cbClient = new CallbackClient(pythonPort, this.pythonAddress);
        this.gateway = new Gateway(entryPoint, this.cbClient);
        this.gateway.getBindings().put(GATEWAY_SERVER_ID, this);
    }

    public GatewayServer(Object entryPoint, int port, int connectTimeout, int readTimeout, List<Class<? extends Command>> customCommands, CallbackClient cbClient) {
        this.port = port;
        this.connectTimeout = connectTimeout;
        this.readTimeout = readTimeout;
        this.cbClient = cbClient;
        this.gateway = new Gateway(entryPoint, cbClient);
        this.pythonPort = cbClient.getPort();
        this.pythonAddress = cbClient.getAddress();
        this.gateway.getBindings().put(GATEWAY_SERVER_ID, this);
        this.customCommands = customCommands;
        this.listeners = new CopyOnWriteArrayList<GatewayServerListener>();
        try {
            this.address = InetAddress.getByName(DEFAULT_ADDRESS);
        }
        catch (UnknownHostException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public void addListener(GatewayServerListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void connectionStopped(GatewayConnection gatewayConnection) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                this.connections.remove(gatewayConnection.getSocket());
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    protected GatewayConnection createConnection(Gateway gateway, Socket socket) throws IOException {
        return new GatewayConnection(gateway, socket, this.customCommands, this.listeners);
    }

    protected void fireConnectionError(Exception e) {
        this.logger.log(Level.SEVERE, "Connection Server Error", e);
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireConnectionStarted(GatewayConnection gatewayConnection) {
        this.logger.info("Connection Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.connectionStarted(gatewayConnection);
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerError(Exception e) {
        if (e.getMessage().contains("Socket closed")) {
            this.logger.log(Level.FINE, "Gateway Server Error", e);
        } else {
            this.logger.log(Level.SEVERE, "Gateway Server Error", e);
        }
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverError(e);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "A listener crashed.", ex);
            }
        }
    }

    protected void fireServerPostShutdown() {
        this.logger.fine("Gateway Server Post Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPostShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerPreShutdown() {
        this.logger.fine("Gateway Server Pre Shutdown");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverPreShutdown();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStarted() {
        this.logger.info("Gateway Server Started");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStarted();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    protected void fireServerStopped() {
        this.logger.info("Gateway Server Stopped");
        for (GatewayServerListener listener : this.listeners) {
            try {
                listener.serverStopped();
            }
            catch (Exception e) {
                this.logger.log(Level.SEVERE, "A listener crashed.", e);
            }
        }
    }

    public InetAddress getAddress() {
        return this.address;
    }

    public CallbackClient getCallbackClient() {
        return this.cbClient;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getListeningPort() {
        int port = -1;
        try {
            if (this.sSocket.isBound()) {
                port = this.sSocket.getLocalPort();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return port;
    }

    public int getPort() {
        return this.port;
    }

    public InetAddress getPythonAddress() {
        return this.pythonAddress;
    }

    public int getPythonPort() {
        return this.pythonPort;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    private void processSocket(Socket socket) {
        try {
            this.lock.lock();
            if (!this.isShutdown) {
                this.connections.add(socket);
                socket.setSoTimeout(this.readTimeout);
                GatewayConnection gatewayConnection = this.createConnection(this.gateway, socket);
                this.fireConnectionStarted(gatewayConnection);
            }
        }
        catch (Exception e) {
            this.fireConnectionError(e);
        }
        finally {
            this.lock.unlock();
        }
    }

    public void removeListener(GatewayServerListener listener) {
        this.listeners.remove(listener);
    }

    @Override
    public void run() {
        try {
            this.gateway.startup();
            this.fireServerStarted();
            this.addListener(this);
            while (!this.isShutdown) {
                Socket socket = this.sSocket.accept();
                this.processSocket(socket);
            }
        }
        catch (Exception e) {
            this.fireServerError(e);
        }
        this.fireServerStopped();
        this.removeListener(this);
    }

    public void shutdown() {
        this.fireServerPreShutdown();
        try {
            this.lock.lock();
            this.isShutdown = true;
            NetworkUtil.quietlyClose(this.sSocket);
            for (Socket socket : this.connections) {
                NetworkUtil.quietlyClose(socket);
            }
            this.connections.clear();
            this.gateway.shutdown();
            this.cbClient.shutdown();
            this.fireServerPostShutdown();
        }
        finally {
            this.lock.unlock();
        }
    }

    public void start() {
        this.start(true);
    }

    public void start(boolean fork) {
        this.startSocket();
        if (fork) {
            Thread t = new Thread(this);
            t.start();
        } else {
            this.run();
        }
    }

    protected void startSocket() throws Py4JNetworkException {
        try {
            this.sSocket = new ServerSocket(this.port, -1, this.address);
            this.sSocket.setSoTimeout(this.connectTimeout);
            this.sSocket.setReuseAddress(true);
        }
        catch (IOException e) {
            throw new Py4JNetworkException(e);
        }
    }

    public static void main(String[] args) {
        boolean dieOnBrokenPipe = false;
        String usage = "usage: [--die-on-broken-pipe] port";
        if (args.length == 0) {
            System.err.println(usage);
            System.exit(1);
        } else if (args.length == 2) {
            if (!args[0].equals("--die-on-broken-pipe")) {
                System.err.println(usage);
                System.exit(1);
            }
            dieOnBrokenPipe = true;
        }
        int port = Integer.parseInt(args[args.length - 1]);
        GatewayServer gatewayServer = new GatewayServer(null, port);
        gatewayServer.start();
        int listening_port = gatewayServer.getListeningPort();
        System.out.println("" + listening_port);
        if (dieOnBrokenPipe) {
            BufferedReader stdin = new BufferedReader(new InputStreamReader(System.in));
            try {
                stdin.readLine();
                System.exit(0);
            }
            catch (IOException e) {
                System.exit(1);
            }
        }
    }

    public List<Class<? extends Command>> getCustomCommands() {
        return Collections.unmodifiableList(this.customCommands);
    }

    public List<GatewayServerListener> getListeners() {
        return Collections.unmodifiableList(this.listeners);
    }

    static {
        GatewayServer.turnLoggingOff();
    }
}

