/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.filter;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.filter.InvalidRowFilterException;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.Cell;
import org.apache.hadoop.hbase.util.Bytes;

public class RegExpRowFilter
implements RowFilterInterface {
    private Pattern rowKeyPattern = null;
    private String rowKeyRegExp = null;
    private Map<byte[], byte[]> equalsMap = new TreeMap<byte[], byte[]>(Bytes.BYTES_COMPARATOR);
    private Set<byte[]> nullColumns = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);

    public RegExpRowFilter() {
    }

    public RegExpRowFilter(String rowKeyRegExp) {
        this.rowKeyRegExp = rowKeyRegExp;
    }

    @Deprecated
    public RegExpRowFilter(String rowKeyRegExp, Map<byte[], Cell> columnFilter) {
        this.rowKeyRegExp = rowKeyRegExp;
        this.setColumnFilters(columnFilter);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] rowKey) {
        this.rowProcessed(filtered, rowKey, 0, rowKey.length);
    }

    @Override
    public void rowProcessed(boolean filtered, byte[] key, int offset, int length) {
    }

    @Override
    public boolean processAlways() {
        return false;
    }

    @Deprecated
    public void setColumnFilter(byte[] colKey, byte[] value) {
        if (value == null) {
            this.nullColumns.add(colKey);
        } else {
            this.equalsMap.put(colKey, value);
        }
    }

    @Deprecated
    public void setColumnFilters(Map<byte[], Cell> columnFilter) {
        if (null == columnFilter) {
            this.nullColumns.clear();
            this.equalsMap.clear();
        } else {
            for (Map.Entry<byte[], Cell> entry : columnFilter.entrySet()) {
                this.setColumnFilter(entry.getKey(), entry.getValue().getValue());
            }
        }
    }

    @Override
    public void reset() {
    }

    @Override
    public boolean filterAllRemaining() {
        return false;
    }

    @Override
    public boolean filterRowKey(byte[] rowKey) {
        return this.filterRowKey(rowKey, 0, rowKey.length);
    }

    @Override
    public boolean filterRowKey(byte[] rowKey, int offset, int length) {
        return this.filtersByRowKey() && rowKey != null ? !this.getRowKeyPattern().matcher(Bytes.toString(rowKey, offset, length)).matches() : false;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, byte[] colKey, byte[] data) {
        byte[] filterValue;
        if (this.filterRowKey(rowKey)) {
            return true;
        }
        if (this.filtersByColumnValue() && null != (filterValue = this.equalsMap.get(colKey))) {
            return !Arrays.equals(filterValue, data);
        }
        return this.nullColumns.contains(colKey) && data != null;
    }

    @Override
    public boolean filterColumn(byte[] rowKey, int roffset, int rlength, byte[] colunmName, int coffset, int clength, byte[] columnValue, int voffset, int vlength) {
        byte[] filterValue;
        if (this.filterRowKey(rowKey, roffset, rlength)) {
            return true;
        }
        byte[] colkey = null;
        if (this.filtersByColumnValue() && null != (filterValue = this.equalsMap.get(colkey = this.getColKey(colunmName, coffset, clength)))) {
            return Bytes.compareTo(filterValue, 0, filterValue.length, columnValue, voffset, vlength) != 0;
        }
        if (colkey == null) {
            colkey = this.getColKey(colunmName, coffset, clength);
        }
        return this.nullColumns.contains(colkey) && columnValue != null;
    }

    private byte[] getColKey(byte[] c, int offset, int length) {
        byte[] colkey = null;
        if (offset == 0) {
            colkey = c;
        } else {
            colkey = new byte[length];
            System.arraycopy(c, offset, colkey, 0, length);
        }
        return colkey;
    }

    @Override
    public boolean filterRow(SortedMap<byte[], Cell> columns) {
        for (Map.Entry<byte[], Cell> col : columns.entrySet()) {
            if (!this.nullColumns.contains(col.getKey())) continue;
            return true;
        }
        Iterator<Map.Entry<byte[], Cell>> i$ = this.equalsMap.keySet().iterator();
        while (i$.hasNext()) {
            Map.Entry<byte[], Cell> col;
            col = (Map.Entry<byte[], Cell>)((byte[])i$.next());
            if (columns.containsKey(col)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean filterRow(List<KeyValue> kvs) {
        for (KeyValue kv : kvs) {
            byte[] column = kv.getColumn();
            if (this.nullColumns.contains(column) && !kv.isDeleteType()) {
                return true;
            }
            if (this.equalsMap.containsKey(column)) continue;
            return true;
        }
        return false;
    }

    private boolean filtersByColumnValue() {
        return this.equalsMap != null && this.equalsMap.size() > 0;
    }

    private boolean filtersByRowKey() {
        return null != this.rowKeyPattern || null != this.rowKeyRegExp;
    }

    private String getRowKeyRegExp() {
        if (null == this.rowKeyRegExp && this.rowKeyPattern != null) {
            this.rowKeyRegExp = this.rowKeyPattern.toString();
        }
        return this.rowKeyRegExp;
    }

    private Pattern getRowKeyPattern() {
        if (this.rowKeyPattern == null && this.rowKeyRegExp != null) {
            this.rowKeyPattern = Pattern.compile(this.rowKeyRegExp);
        }
        return this.rowKeyPattern;
    }

    public void readFields(DataInput in) throws IOException {
        int i;
        boolean hasRowKeyPattern = in.readBoolean();
        if (hasRowKeyPattern) {
            this.rowKeyRegExp = in.readUTF();
        }
        this.equalsMap.clear();
        int size = in.readInt();
        for (i = 0; i < size; ++i) {
            byte[] key = Bytes.readByteArray(in);
            int len = in.readInt();
            byte[] value = null;
            if (len >= 0) {
                value = new byte[len];
                in.readFully(value);
            }
            this.setColumnFilter(key, value);
        }
        this.nullColumns.clear();
        size = in.readInt();
        for (i = 0; i < size; ++i) {
            this.setColumnFilter(Bytes.readByteArray(in), null);
        }
    }

    @Override
    public void validate(byte[][] columns) {
        TreeSet<byte[]> invalids = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        for (byte[] colKey : this.getFilterColumns()) {
            boolean found = false;
            for (byte[] col : columns) {
                if (!Bytes.equals(col, colKey)) continue;
                found = true;
                break;
            }
            if (found) continue;
            invalids.add(colKey);
        }
        if (invalids.size() > 0) {
            throw new InvalidRowFilterException(String.format("RowFilter contains criteria on columns %s not in %s", invalids, Arrays.toString((Object[])columns)));
        }
    }

    @Deprecated
    private Set<byte[]> getFilterColumns() {
        TreeSet<byte[]> cols = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
        cols.addAll(this.equalsMap.keySet());
        cols.addAll(this.nullColumns);
        return cols;
    }

    public void write(DataOutput out) throws IOException {
        if (!this.filtersByRowKey()) {
            out.writeBoolean(false);
        } else {
            out.writeBoolean(true);
            out.writeUTF(this.getRowKeyRegExp());
        }
        out.writeInt(this.equalsMap.size());
        for (Map.Entry<byte[], byte[]> entry : this.equalsMap.entrySet()) {
            Bytes.writeByteArray(out, entry.getKey());
            byte[] value = entry.getValue();
            out.writeInt(value.length);
            out.write(value);
        }
        out.writeInt(this.nullColumns.size());
        for (byte[] col : this.nullColumns) {
            Bytes.writeByteArray(out, col);
        }
    }
}

