/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile;

import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.util.ClassSize;

public class CachedBlock
implements HeapSize,
Comparable<CachedBlock> {
    public static final long PER_BLOCK_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 3 * ClassSize.REFERENCE + 16 + ClassSize.STRING + ClassSize.BYTE_BUFFER);
    private final String blockName;
    private final ByteBuffer buf;
    private volatile long accessTime;
    private long size;
    private BlockPriority priority;

    public CachedBlock(String blockName, ByteBuffer buf, long accessTime) {
        this(blockName, buf, accessTime, false);
    }

    public CachedBlock(String blockName, ByteBuffer buf, long accessTime, boolean inMemory) {
        this.blockName = blockName;
        this.buf = buf;
        this.accessTime = accessTime;
        this.size = (long)(ClassSize.align(blockName.length()) + ClassSize.align(buf.capacity())) + PER_BLOCK_OVERHEAD;
        this.priority = inMemory ? BlockPriority.MEMORY : BlockPriority.SINGLE;
    }

    public void access(long accessTime) {
        this.accessTime = accessTime;
        if (this.priority == BlockPriority.SINGLE) {
            this.priority = BlockPriority.MULTI;
        }
    }

    @Override
    public long heapSize() {
        return this.size;
    }

    @Override
    public int compareTo(CachedBlock that) {
        if (this.accessTime == that.accessTime) {
            return 0;
        }
        return this.accessTime < that.accessTime ? 1 : -1;
    }

    public ByteBuffer getBuffer() {
        return this.buf;
    }

    public String getName() {
        return this.blockName;
    }

    public BlockPriority getPriority() {
        return this.priority;
    }

    static enum BlockPriority {
        SINGLE,
        MULTI,
        MEMORY;

    }
}

