/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.fs.PathFilter;
import org.apache.hadoop.hbase.Chore;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HServerInfo;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.UnknownScannerException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.master.RegionManager;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.ipc.RemoteException;

abstract class BaseScanner
extends Chore
implements HConstants {
    static final Log LOG = LogFactory.getLog((String)BaseScanner.class.getName());
    private final boolean rootRegion;
    protected final HMaster master;
    protected boolean initialScanComplete;
    final Object scannerLock = new Object();

    protected abstract boolean initialScan();

    protected abstract void maintenanceScan();

    BaseScanner(HMaster master, boolean rootRegion, int period, AtomicBoolean stop) {
        super(period, stop);
        this.rootRegion = rootRegion;
        this.master = master;
        this.initialScanComplete = false;
    }

    public boolean isInitialScanComplete() {
        return this.initialScanComplete;
    }

    @Override
    protected boolean initialChore() {
        return this.initialScan();
    }

    @Override
    protected void chore() {
        this.maintenanceScan();
    }

    protected void scanRegion(MetaRegion region) throws IOException {
        HRegionInterface regionServer = null;
        long scannerId = -1L;
        LOG.info((Object)(Thread.currentThread().getName() + " scanning meta region " + region.toString()));
        HashMap<HRegionInfo, Result> splitParents = new HashMap<HRegionInfo, Result>();
        ArrayList<byte[]> emptyRows = new ArrayList<byte[]>();
        int rows = 0;
        try {
            Result values;
            regionServer = this.master.connection.getHRegionConnection(region.getServer());
            Scan s = new Scan().addFamily(HConstants.CATALOG_FAMILY);
            s.setCaching(1);
            scannerId = regionServer.openScanner(region.getRegionName(), s);
            while ((values = regionServer.next(scannerId)) != null && values.size() != 0) {
                HRegionInfo info = this.master.getHRegionInfo(values.getRow(), values);
                if (info == null) {
                    emptyRows.add(values.getRow());
                    continue;
                }
                String serverAddress = this.getServerAddress(values);
                long startCode = this.getStartCode(values);
                this.checkAssigned(regionServer, region, info, serverAddress, startCode);
                if (this.isSplitParent(info)) {
                    splitParents.put(info, values);
                }
                ++rows;
            }
            if (this.rootRegion) {
                this.master.regionManager.setNumMetaRegions(rows);
            }
        }
        catch (IOException e) {
            if (e instanceof RemoteException && (e = RemoteExceptionHandler.decodeRemoteException((RemoteException)((Object)e))) instanceof UnknownScannerException) {
                scannerId = -1L;
            }
            throw e;
        }
        finally {
            try {
                if (scannerId != -1L && regionServer != null) {
                    regionServer.close(scannerId);
                }
            }
            catch (IOException e) {
                LOG.error((Object)"Closing scanner", (Throwable)RemoteExceptionHandler.checkIOException(e));
            }
        }
        if (emptyRows.size() > 0) {
            LOG.warn((Object)("Found " + emptyRows.size() + " rows with empty HRegionInfo " + "while scanning meta region " + Bytes.toString(region.getRegionName())));
            this.master.deleteEmptyMetaRows(regionServer, region.getRegionName(), emptyRows);
        }
        if (splitParents.size() > 0) {
            for (Map.Entry e : splitParents.entrySet()) {
                HRegionInfo hri = (HRegionInfo)((Object)e.getKey());
                this.cleanupSplits(region.getRegionName(), regionServer, hri, (Result)e.getValue());
            }
        }
        LOG.info((Object)(Thread.currentThread().getName() + " scan of " + rows + " row(s) of meta region " + region.toString() + " complete"));
    }

    private String getServerAddress(Result r) {
        byte[] val = r.getValue(CATALOG_FAMILY, SERVER_QUALIFIER);
        return val == null || val.length <= 0 ? "" : Bytes.toString(val);
    }

    private long getStartCode(Result r) {
        byte[] val = r.getValue(CATALOG_FAMILY, STARTCODE_QUALIFIER);
        return val == null || val.length <= 0 ? 0L : Bytes.toLong(val);
    }

    private boolean isSplitParent(HRegionInfo info) {
        if (!info.isSplit()) {
            return false;
        }
        if (!info.isOffline()) {
            LOG.warn((Object)("Region is split but not offline: " + info.getRegionNameAsString()));
        }
        return true;
    }

    private boolean cleanupSplits(byte[] metaRegionName, HRegionInterface srvr, HRegionInfo parent, Result rowContent) throws IOException {
        boolean result = false;
        boolean hasReferencesA = this.hasReferences(metaRegionName, srvr, parent.getRegionName(), rowContent, CATALOG_FAMILY, SPLITA_QUALIFIER);
        boolean hasReferencesB = this.hasReferences(metaRegionName, srvr, parent.getRegionName(), rowContent, CATALOG_FAMILY, SPLITB_QUALIFIER);
        if (!hasReferencesA && !hasReferencesB) {
            LOG.info((Object)("Deleting region " + parent.getRegionNameAsString() + " (encoded=" + parent.getEncodedName() + ") because daughter splits no longer hold references"));
            HRegion.deleteRegion(this.master.fs, this.master.rootdir, parent);
            HRegion.removeRegionFromMETA(srvr, metaRegionName, parent.getRegionName());
            result = true;
        }
        return result;
    }

    private boolean hasReferences(byte[] metaRegionName, HRegionInterface srvr, byte[] parent, Result rowContent, byte[] splitFamily, byte[] splitQualifier) throws IOException {
        boolean result = false;
        HRegionInfo split = Writables.getHRegionInfoOrNull(rowContent.getValue(splitFamily, splitQualifier));
        if (split == null) {
            return result;
        }
        Path tabledir = new Path(this.master.rootdir, split.getTableDesc().getNameAsString());
        for (HColumnDescriptor family : split.getTableDesc().getFamilies()) {
            Path p = Store.getStoreHomedir(tabledir, split.getEncodedName(), family.getName());
            FileStatus[] ps = this.master.fs.listStatus(p, new PathFilter(){

                public boolean accept(Path path) {
                    return StoreFile.isReference(path);
                }
            });
            if (ps == null || ps.length <= 0) continue;
            result = true;
            break;
        }
        if (result) {
            return result;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)(split.getRegionNameAsString() + "/" + split.getEncodedName() + " no longer has references to " + Bytes.toStringBinary(parent)));
        }
        Delete delete = new Delete(parent);
        delete.deleteColumns(splitFamily, splitQualifier);
        srvr.delete(metaRegionName, delete);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkAssigned(HRegionInterface regionServer, MetaRegion meta, HRegionInfo info, String serverAddress, long startCode) throws IOException {
        String serverName = null;
        String sa = serverAddress;
        long sc = startCode;
        Get g = new Get(info.getRegionName());
        g.addFamily(HConstants.CATALOG_FAMILY);
        Result r = regionServer.get(meta.getRegionName(), g);
        if (r != null && !r.isEmpty()) {
            sa = this.getServerAddress(r);
            if (sa != null && sa.length() > 0 && !sa.equalsIgnoreCase(serverAddress)) {
                LOG.debug((Object)("GET on " + info.getRegionNameAsString() + " got different " + "address than SCAN: sa=" + sa + ", serverAddress=" + serverAddress));
            }
            if ((sc = this.getStartCode(r)) != startCode) {
                LOG.debug((Object)("GET on " + info.getRegionNameAsString() + " got different " + "startcode than SCAN: sc=" + sc + ", serverAddress=" + startCode));
            }
        }
        if (sa != null && sa.length() > 0) {
            serverName = HServerInfo.getServerName(sa, sc);
        }
        HServerInfo storedInfo = null;
        RegionManager regionManager = this.master.regionManager;
        synchronized (regionManager) {
            if (info.isOffline() || this.master.regionManager.regionIsInTransition(info.getRegionNameAsString()) || serverName != null && this.master.serverManager.isDead(serverName)) {
                return;
            }
            if (serverName != null) {
                storedInfo = this.master.serverManager.getServerInfo(serverName);
            }
            if (storedInfo == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Current assignment of " + info.getRegionNameAsString() + " is not valid; " + " serverAddress=" + sa + ", startCode=" + sc + " unknown."));
                }
                this.master.regionManager.setUnassigned(info, true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interruptIfAlive() {
        Object object = this.scannerLock;
        synchronized (object) {
            if (this.isAlive()) {
                super.interrupt();
            }
        }
    }
}

