/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.ColumnOperation;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.regionserver.Store;

class DeleteColumn
extends ColumnOperation {
    private final byte[] columnName;

    DeleteColumn(HMaster master, byte[] tableName, byte[] columnName) throws IOException {
        super(master, tableName);
        this.columnName = columnName;
    }

    @Override
    protected void postProcessMeta(MetaRegion m, HRegionInterface server) throws IOException {
        for (HRegionInfo i : this.unservedRegions) {
            i.getTableDesc().removeFamily(this.columnName);
            this.updateRegionInfo(server, m.getRegionName(), i);
            Path tabledir = new Path(this.master.rootdir, i.getTableDesc().getNameAsString());
            this.master.fs.delete(Store.getStoreHomedir(tabledir, i.getEncodedName(), this.columnName), true);
        }
    }
}

