/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.master.ColumnOperation;
import org.apache.hadoop.hbase.master.HMaster;
import org.apache.hadoop.hbase.master.InvalidColumnNameException;
import org.apache.hadoop.hbase.master.MetaRegion;
import org.apache.hadoop.hbase.util.Bytes;

class ModifyColumn
extends ColumnOperation {
    private final HColumnDescriptor descriptor;
    private final byte[] columnName;

    ModifyColumn(HMaster master, byte[] tableName, byte[] columnName, HColumnDescriptor descriptor) throws IOException {
        super(master, tableName);
        this.descriptor = descriptor;
        this.columnName = columnName;
    }

    @Override
    protected void postProcessMeta(MetaRegion m, HRegionInterface server) throws IOException {
        for (HRegionInfo i : this.unservedRegions) {
            if (i.getTableDesc().hasFamily(this.columnName)) {
                i.getTableDesc().addFamily(this.descriptor);
                this.updateRegionInfo(server, m.getRegionName(), i);
                continue;
            }
            throw new InvalidColumnNameException("Column family '" + Bytes.toString(this.columnName) + "' doesn't exist, so cannot be modified.");
        }
    }
}

