/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.master.HMaster;

abstract class RegionServerOperation
implements Delayed,
HConstants {
    protected static final Log LOG = LogFactory.getLog((String)RegionServerOperation.class.getName());
    private long expire;
    protected final HMaster master;
    protected final int numRetries;

    protected RegionServerOperation(HMaster master) {
        this.master = master;
        this.numRetries = master.numRetries;
        this.expire = System.currentTimeMillis() + (long)(this.master.leaseTimeout / 2);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.expire - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        return Long.valueOf(this.getDelay(TimeUnit.MILLISECONDS) - o.getDelay(TimeUnit.MILLISECONDS)).intValue();
    }

    protected void requeue() {
        this.expire = System.currentTimeMillis() + (long)(this.master.leaseTimeout / 2);
        this.master.delayedToDoQueue.put(this);
    }

    protected boolean rootAvailable() {
        boolean available = true;
        if (this.master.getRootRegionLocation() == null) {
            available = false;
            this.requeue();
        }
        return available;
    }

    protected boolean metaTableAvailable() {
        boolean available = true;
        if (this.master.regionManager.numMetaRegions() != this.master.regionManager.numOnlineMetaRegions() || this.master.regionManager.metaRegionsInTransition()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("numberOfMetaRegions: " + this.master.regionManager.numMetaRegions() + ", onlineMetaRegions.size(): " + this.master.regionManager.numOnlineMetaRegions()));
                LOG.debug((Object)"Requeuing because not all meta regions are online");
            }
            available = false;
            this.requeue();
        }
        return available;
    }

    @Override
    public int compareTo(RegionServerOperation other) {
        return this.getPriority() - other.getPriority();
    }

    protected int getPriority() {
        return Integer.MAX_VALUE;
    }

    protected abstract boolean process() throws IOException;
}

