/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.metrics.file;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.hadoop.metrics.ContextFactory;
import org.apache.hadoop.metrics.file.FileContext;
import org.apache.hadoop.metrics.spi.OutputRecord;

public class TimeStampingFileContext
extends FileContext {
    private File file = null;
    private PrintWriter writer = null;
    private final SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");

    public void init(String contextName, ContextFactory factory) {
        super.init(contextName, factory);
        String fileName = this.getAttribute("fileName");
        if (fileName != null) {
            this.file = new File(fileName);
        }
    }

    public void startMonitoring() throws IOException {
        this.writer = this.file == null ? new PrintWriter(new BufferedOutputStream(System.out)) : new PrintWriter(new FileWriter(this.file, true));
        super.startMonitoring();
    }

    public void stopMonitoring() {
        super.stopMonitoring();
        if (this.writer != null) {
            this.writer.close();
            this.writer = null;
        }
    }

    private synchronized String iso8601() {
        return this.sdf.format(new Date());
    }

    public void emitRecord(String contextName, String recordName, OutputRecord outRec) {
        this.writer.print(this.iso8601());
        this.writer.print(" ");
        this.writer.print(contextName);
        this.writer.print(".");
        this.writer.print(recordName);
        String separator = ": ";
        for (String tagName : outRec.getTagNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(tagName);
            this.writer.print("=");
            this.writer.print(outRec.getTag(tagName));
        }
        for (String metricName : outRec.getMetricNames()) {
            this.writer.print(separator);
            separator = ", ";
            this.writer.print(metricName);
            this.writer.print("=");
            this.writer.print(outRec.getMetric(metricName));
        }
        this.writer.println();
    }

    public void flush() {
        this.writer.flush();
    }
}

