/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.RowFilterInterface;
import org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.BlockCache;
import org.apache.hadoop.hbase.ipc.HRegionInterface;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HLog;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueHeap;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.NoSuchColumnFamilyException;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFlusher;
import org.apache.hadoop.hbase.regionserver.WrongRegionException;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Writables;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.util.Progressable;
import org.apache.hadoop.util.StringUtils;

public class HRegion
implements HConstants,
HeapSize {
    static final Log LOG = LogFactory.getLog(HRegion.class);
    static final String SPLITDIR = "splits";
    static final String MERGEDIR = "merges";
    final AtomicBoolean closed = new AtomicBoolean(false);
    final AtomicBoolean closing = new AtomicBoolean(false);
    private final Map<Integer, byte[]> locksToRows = new ConcurrentHashMap<Integer, byte[]>();
    protected final Map<byte[], Store> stores = new ConcurrentSkipListMap<byte[], Store>((Comparator<byte[]>)Bytes.BYTES_RAWCOMPARATOR);
    final AtomicLong memstoreSize = new AtomicLong(0L);
    final Path basedir;
    final HLog log;
    final FileSystem fs;
    final HBaseConfiguration conf;
    final HRegionInfo regionInfo;
    final Path regiondir;
    private final Path regionCompactionDir;
    KeyValue.KVComparator comparator;
    private volatile boolean forceMajorCompaction = false;
    private volatile WriteState writestate = new WriteState();
    final long memstoreFlushSize;
    private volatile long lastFlushTime;
    final FlushRequester flushListener;
    private final long blockingMemStoreSize;
    final long threadWakeFrequency;
    private final ReentrantReadWriteLock splitsAndClosesLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock newScannerLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock updatesLock = new ReentrantReadWriteLock();
    private final Object splitLock = new Object();
    private long minSequenceId;
    private boolean splitRequest;
    public static final String REGIONINFO_FILE = ".regioninfo";
    public static final byte[] REGIONINFO_FILE_BYTES = Bytes.toBytes(".regioninfo");
    public static final long FIXED_OVERHEAD = ClassSize.align(41 + 19 * ClassSize.REFERENCE + ClassSize.OBJECT);
    public static final long DEEP_OVERHEAD = ClassSize.align(FIXED_OVERHEAD + (long)ClassSize.OBJECT + (long)(2 * ClassSize.ATOMIC_BOOLEAN) + (long)ClassSize.ATOMIC_LONG + (long)ClassSize.ATOMIC_INTEGER + (long)ClassSize.CONCURRENT_HASHMAP + (long)(16 * ClassSize.CONCURRENT_HASHMAP_ENTRY) + (long)(16 * ClassSize.CONCURRENT_HASHMAP_SEGMENT) + (long)ClassSize.CONCURRENT_SKIPLISTMAP + (long)ClassSize.CONCURRENT_SKIPLISTMAP_ENTRY + (long)ClassSize.align(ClassSize.OBJECT + 5) + (long)(3 * ClassSize.REENTRANT_LOCK));
    private static final List<KeyValue> MOCKED_LIST = new AbstractList<KeyValue>(){

        @Override
        public void add(int index, KeyValue element) {
        }

        @Override
        public boolean addAll(int index, Collection<? extends KeyValue> c) {
            return false;
        }

        @Override
        public KeyValue get(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int size() {
            return 0;
        }
    };

    public HRegion() {
        this.basedir = null;
        this.blockingMemStoreSize = 0L;
        this.conf = null;
        this.flushListener = null;
        this.fs = null;
        this.memstoreFlushSize = 0L;
        this.log = null;
        this.regionCompactionDir = null;
        this.regiondir = null;
        this.regionInfo = null;
        this.threadWakeFrequency = 0L;
    }

    public HRegion(Path basedir, HLog log, FileSystem fs, HBaseConfiguration conf, HRegionInfo regionInfo, FlushRequester flushListener) {
        this.basedir = basedir;
        this.comparator = regionInfo.getComparator();
        this.log = log;
        this.fs = fs;
        this.conf = conf;
        this.regionInfo = regionInfo;
        this.flushListener = flushListener;
        this.threadWakeFrequency = conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        String encodedNameStr = Integer.toString(this.regionInfo.getEncodedName());
        this.regiondir = new Path(basedir, encodedNameStr);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region " + this + ", encoded=" + this.regionInfo.getEncodedName()));
        }
        this.regionCompactionDir = new Path(HRegion.getCompactionDir(basedir), encodedNameStr);
        long flushSize = regionInfo.getTableDesc().getMemStoreFlushSize();
        if (flushSize == 0x4000000L) {
            flushSize = conf.getLong("hbase.hregion.memstore.flush.size", 0x4000000L);
        }
        this.memstoreFlushSize = flushSize;
        this.blockingMemStoreSize = this.memstoreFlushSize * conf.getLong("hbase.hregion.memstore.block.multiplier", 2L);
    }

    public void initialize(Path initialFiles, Progressable reporter) throws IOException {
        Path oldLogFile = new Path(this.regiondir, "oldlogfile.log");
        if (initialFiles != null && this.fs.exists(initialFiles)) {
            this.fs.rename(initialFiles, this.regiondir);
        }
        this.checkRegioninfoOnFilesystem();
        long maxSeqId = -1L;
        long minSeqIdToRecover = Integer.MAX_VALUE;
        for (HColumnDescriptor c : this.regionInfo.getTableDesc().getFamilies()) {
            long storeSeqIdBeforeRecovery;
            Store store = this.instantiateHStore(this.basedir, c, oldLogFile, reporter);
            this.stores.put(c.getName(), store);
            long storeSeqId = store.getMaxSequenceId();
            if (storeSeqId > maxSeqId) {
                maxSeqId = storeSeqId;
            }
            if ((storeSeqIdBeforeRecovery = store.getMaxSeqIdBeforeLogRecovery()) >= minSeqIdToRecover) continue;
            minSeqIdToRecover = storeSeqIdBeforeRecovery;
        }
        this.doReconstructionLog(oldLogFile, minSeqIdToRecover, maxSeqId, reporter);
        if (this.fs.exists(oldLogFile)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Deleting old log file: " + oldLogFile));
            }
            this.fs.delete(oldLogFile, false);
        }
        this.minSequenceId = maxSeqId + 1L;
        FSUtils.deleteDirectory(this.fs, new Path(this.regiondir, SPLITDIR));
        FSUtils.deleteDirectory(this.fs, new Path(this.regiondir, MERGEDIR));
        if (this.regionInfo.getTableDesc().isReadOnly()) {
            this.writestate.setReadOnly(true);
        }
        this.writestate.compacting = false;
        this.lastFlushTime = System.currentTimeMillis();
        LOG.info((Object)("region " + this + "/" + this.regionInfo.getEncodedName() + " available; sequence id is " + this.minSequenceId));
    }

    boolean hasReferences() {
        for (Map.Entry<byte[], Store> e : this.stores.entrySet()) {
            for (Map.Entry ee : e.getValue().getStorefiles().entrySet()) {
                if (!((StoreFile)ee.getValue()).isReference()) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkRegioninfoOnFilesystem() throws IOException {
        Path regioninfo = new Path(this.regiondir, REGIONINFO_FILE);
        if (this.fs.exists(regioninfo) && this.fs.getFileStatus(regioninfo).getLen() > 0L) {
            return;
        }
        FSDataOutputStream out = this.fs.create(regioninfo, true);
        try {
            this.regionInfo.write((DataOutput)out);
            out.write(10);
            out.write(10);
            out.write(Bytes.toBytes(this.regionInfo.toString()));
        }
        finally {
            out.close();
        }
    }

    long getMinSequenceId() {
        return this.minSequenceId;
    }

    public HRegionInfo getRegionInfo() {
        return this.regionInfo;
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    public boolean isClosing() {
        return this.closing.get();
    }

    public List<StoreFile> close() throws IOException {
        return this.close(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive exception aggregation
     */
    public List<StoreFile> close(boolean abort) throws IOException {
        if (this.isClosed()) {
            LOG.warn((Object)("region " + this + " already closed"));
            return null;
        }
        this.closing.set(true);
        Object object = this.splitLock;
        synchronized (object) {
            WriteState writeState = this.writestate;
            synchronized (writeState) {
                this.writestate.writesEnabled = false;
                LOG.debug((Object)("Closing " + this + ": compactions & flushes disabled "));
                while (this.writestate.compacting || this.writestate.flushing) {
                    LOG.debug((Object)("waiting for" + (this.writestate.compacting ? " compaction" : "") + (this.writestate.flushing ? (this.writestate.compacting ? "," : "") + " cache flush" : "") + " to complete for region " + this));
                    try {
                        this.writestate.wait();
                    }
                    catch (InterruptedException iex) {}
                }
            }
            this.newScannerLock.writeLock().lock();
            try {
                ArrayList<StoreFile> arrayList;
                this.splitsAndClosesLock.writeLock().lock();
                LOG.debug((Object)("Updates disabled for region, no outstanding scanners on " + this));
                try {
                    this.waitOnRowLocks();
                    LOG.debug((Object)("No more row locks outstanding on region " + this));
                    if (!abort) {
                        this.internalFlushcache();
                    }
                    ArrayList<StoreFile> result = new ArrayList<StoreFile>();
                    for (Store store : this.stores.values()) {
                        result.addAll(store.close());
                    }
                    this.closed.set(true);
                    LOG.info((Object)("Closed " + this));
                    arrayList = result;
                    this.splitsAndClosesLock.writeLock().unlock();
                }
                catch (Throwable throwable) {
                    this.splitsAndClosesLock.writeLock().unlock();
                    throw throwable;
                }
                return arrayList;
            }
            finally {
                this.newScannerLock.writeLock().unlock();
            }
        }
    }

    public byte[] getStartKey() {
        return this.regionInfo.getStartKey();
    }

    public byte[] getEndKey() {
        return this.regionInfo.getEndKey();
    }

    public long getRegionId() {
        return this.regionInfo.getRegionId();
    }

    public byte[] getRegionName() {
        return this.regionInfo.getRegionName();
    }

    public String getRegionNameAsString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public HTableDescriptor getTableDesc() {
        return this.regionInfo.getTableDesc();
    }

    public HLog getLog() {
        return this.log;
    }

    public HBaseConfiguration getConf() {
        return this.conf;
    }

    public Path getRegionDir() {
        return this.regiondir;
    }

    public FileSystem getFilesystem() {
        return this.fs;
    }

    public long getLastFlushTime() {
        return this.lastFlushTime;
    }

    public long getLargestHStoreSize() {
        long size = 0L;
        for (Store h : this.stores.values()) {
            long storeSize = h.getSize();
            if (storeSize <= size) continue;
            size = storeSize;
        }
        return size;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    HRegion[] splitRegion(byte[] splitRow) throws IOException {
        this.prepareToSplit();
        Object object = this.splitLock;
        synchronized (object) {
            HRegionInfo regionAInfo;
            Path dirA;
            long rid;
            if (this.closed.get()) {
                return null;
            }
            byte[] startKey = this.regionInfo.getStartKey();
            byte[] endKey = this.regionInfo.getEndKey();
            if (this.comparator.matchingRows(startKey, 0, startKey.length, splitRow, 0, splitRow.length)) {
                LOG.debug((Object)"Startkey and midkey are same, not splitting");
                return null;
            }
            if (this.comparator.matchingRows(splitRow, 0, splitRow.length, endKey, 0, endKey.length)) {
                LOG.debug((Object)"Endkey and midkey are same, not splitting");
                return null;
            }
            LOG.info((Object)("Starting split of region " + this));
            Path splits = new Path(this.regiondir, SPLITDIR);
            if (!this.fs.exists(splits)) {
                this.fs.mkdirs(splits);
            }
            if ((rid = System.currentTimeMillis()) < this.regionInfo.getRegionId()) {
                LOG.warn((Object)("Clock skew; parent regions id is " + this.regionInfo.getRegionId() + " but current time here is " + rid));
                rid = this.regionInfo.getRegionId() + 1L;
            }
            if (this.fs.exists(dirA = new Path(splits, Integer.toString((regionAInfo = new HRegionInfo(this.regionInfo.getTableDesc(), startKey, splitRow, false, rid)).getEncodedName())))) {
                throw new IOException("Cannot split; target file collision at " + dirA);
            }
            HRegionInfo regionBInfo = new HRegionInfo(this.regionInfo.getTableDesc(), splitRow, endKey, false, rid);
            Path dirB = new Path(splits, Integer.toString(regionBInfo.getEncodedName()));
            if (this.fs.exists(dirB)) {
                throw new IOException("Cannot split; target file collision at " + dirB);
            }
            List<StoreFile> hstoreFilesToSplit = this.close(false);
            if (hstoreFilesToSplit == null) {
                LOG.warn((Object)"Close came back null (Implement abort of close?)");
                throw new RuntimeException("close returned empty vector of HStoreFiles");
            }
            for (StoreFile h : hstoreFilesToSplit) {
                StoreFile.split(this.fs, Store.getStoreHomedir(splits, regionAInfo.getEncodedName(), h.getFamily()), h, splitRow, Reference.Range.bottom);
                StoreFile.split(this.fs, Store.getStoreHomedir(splits, regionBInfo.getEncodedName(), h.getFamily()), h, splitRow, Reference.Range.top);
            }
            HRegion regionA = HRegion.newHRegion(this.basedir, this.log, this.fs, this.conf, regionAInfo, null);
            regionA.initialize(dirA, null);
            regionA.close();
            HRegion regionB = HRegion.newHRegion(this.basedir, this.log, this.fs, this.conf, regionBInfo, null);
            regionB.initialize(dirB, null);
            regionB.close();
            boolean deleted = this.fs.delete(splits, true);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Cleaned up " + FSUtils.getPath(splits) + " " + deleted));
            }
            HRegion[] regions = new HRegion[]{regionA, regionB};
            return regions;
        }
    }

    protected void prepareToSplit() {
    }

    static Path getCompactionDir(Path dir) {
        return new Path(dir, "compaction.dir");
    }

    private void doRegionCompactionPrep() throws IOException {
        this.doRegionCompactionCleanup();
    }

    private void doRegionCompactionCleanup() throws IOException {
        FSUtils.deleteDirectory(this.fs, this.regionCompactionDir);
    }

    void setForceMajorCompaction(boolean b) {
        this.forceMajorCompaction = b;
    }

    boolean getForceMajorCompaction() {
        return this.forceMajorCompaction;
    }

    public byte[] compactStores() throws IOException {
        boolean majorCompaction = this.forceMajorCompaction;
        this.forceMajorCompaction = false;
        return this.compactStores(majorCompaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    byte[] compactStores(boolean majorCompaction) throws IOException {
        if (this.closing.get() || this.closed.get()) {
            LOG.debug((Object)("Skipping compaction on " + this + " because closing/closed"));
            return null;
        }
        this.splitsAndClosesLock.readLock().lock();
        try {
            byte[] splitRow = null;
            if (this.closed.get()) {
                byte[] byArray = splitRow;
                return byArray;
            }
            try {
                String string;
                StringBuilder stringBuilder;
                block25: {
                    block23: {
                        block24: {
                            block22: {
                                WriteState writeState = this.writestate;
                                // MONITORENTER : writeState
                                if (this.writestate.compacting || !this.writestate.writesEnabled) break block22;
                                this.writestate.compacting = true;
                                // MONITOREXIT : writeState
                                stringBuilder = new StringBuilder().append("Starting");
                                if (!majorCompaction) break block23;
                                break block24;
                            }
                            LOG.info((Object)("NOT compacting region " + this + ": compacting=" + this.writestate.compacting + ", writesEnabled=" + this.writestate.writesEnabled));
                            byte[] byArray = splitRow;
                            // MONITOREXIT : writeState
                            return byArray;
                        }
                        string = " major ";
                        break block25;
                    }
                    string = " ";
                }
                LOG.info((Object)stringBuilder.append(string).append("compaction on region ").append(this).toString());
                long startTime = System.currentTimeMillis();
                this.doRegionCompactionPrep();
                long maxSize = -1L;
                for (Store store : this.stores.values()) {
                    Store.StoreSize ss = store.compact(majorCompaction);
                    if (ss == null || ss.getSize() <= maxSize) continue;
                    maxSize = ss.getSize();
                    splitRow = ss.getSplitRow();
                }
                this.doRegionCompactionCleanup();
                String timeTaken = StringUtils.formatTimeDiff((long)System.currentTimeMillis(), (long)startTime);
                LOG.info((Object)("compaction completed on region " + this + " in " + timeTaken));
            }
            finally {
                WriteState writeState = this.writestate;
            }
            Object object = splitRow;
            return object;
        }
        finally {
            this.splitsAndClosesLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean flushcache() throws IOException {
        if (this.closed.get()) {
            return false;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.flushing || !this.writestate.writesEnabled) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("NOT flushing memstore for region " + this + ", flushing=" + this.writestate.flushing + ", writesEnabled=" + this.writestate.writesEnabled));
                }
                return false;
            }
            this.writestate.flushing = true;
        }
        try {
            this.splitsAndClosesLock.readLock().lock();
            try {
                boolean bl = this.internalFlushcache();
                this.splitsAndClosesLock.readLock().unlock();
                return bl;
            }
            catch (Throwable throwable) {
                this.splitsAndClosesLock.readLock().unlock();
                throw throwable;
            }
        }
        finally {
            WriteState writeState2 = this.writestate;
            synchronized (writeState2) {
                this.writestate.flushing = false;
                this.writestate.flushRequested = false;
                this.writestate.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean internalFlushcache() throws IOException {
        long startTime;
        this.lastFlushTime = startTime = System.currentTimeMillis();
        if (this.memstoreSize.get() <= 0L) {
            return false;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Started memstore flush for region " + this + ". Current region memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get())));
        }
        long sequenceId = -1L;
        long completeSequenceId = -1L;
        this.updatesLock.writeLock().lock();
        long currentMemStoreSize = this.memstoreSize.get();
        ArrayList<StoreFlusher> storeFlushers = new ArrayList<StoreFlusher>();
        try {
            sequenceId = this.log.startCacheFlush();
            completeSequenceId = this.getCompleteCacheFlushSequenceId(sequenceId);
            for (Store s : this.stores.values()) {
                storeFlushers.add(s.getStoreFlusher(completeSequenceId));
            }
            for (StoreFlusher flusher : storeFlushers) {
                flusher.prepare();
            }
        }
        finally {
            this.updatesLock.writeLock().unlock();
        }
        boolean compactionRequested = false;
        try {
            for (StoreFlusher flusher : storeFlushers) {
                flusher.flushCache();
            }
            this.internalPreFlashcacheCommit();
            this.newScannerLock.writeLock().lock();
            try {
                for (StoreFlusher flusher : storeFlushers) {
                    boolean needsCompaction = flusher.commit();
                    if (!needsCompaction) continue;
                    compactionRequested = true;
                }
            }
            finally {
                this.newScannerLock.writeLock().unlock();
            }
            storeFlushers.clear();
            this.memstoreSize.addAndGet(-currentMemStoreSize);
        }
        catch (Throwable t) {
            this.log.abortCacheFlush();
            DroppedSnapshotException dse = new DroppedSnapshotException("region: " + Bytes.toStringBinary(this.getRegionName()));
            dse.initCause(t);
            throw dse;
        }
        this.log.completeCacheFlush(this.getRegionName(), this.regionInfo.getTableDesc().getName(), completeSequenceId);
        HRegion t = this;
        synchronized (t) {
            this.notifyAll();
        }
        if (LOG.isDebugEnabled()) {
            long now = System.currentTimeMillis();
            LOG.debug((Object)("Finished memstore flush of ~" + StringUtils.humanReadableInt((long)currentMemStoreSize) + " for region " + this + " in " + (now - startTime) + "ms, sequence id=" + sequenceId + ", compaction requested=" + compactionRequested));
        }
        return compactionRequested;
    }

    protected void internalPreFlashcacheCommit() throws IOException {
    }

    protected long getCompleteCacheFlushSequenceId(long currentSequenceId) {
        return currentSequenceId;
    }

    Result getClosestRowBefore(byte[] row) throws IOException {
        return this.getClosestRowBefore(row, HConstants.CATALOG_FAMILY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result getClosestRowBefore(byte[] row, byte[] family) throws IOException {
        KeyValue key = null;
        this.checkRow(row);
        this.splitsAndClosesLock.readLock().lock();
        try {
            Store store = this.getStore(family);
            KeyValue kv = new KeyValue(row, Long.MAX_VALUE);
            key = store.getRowKeyAtOrBefore(kv);
            if (key == null) {
                Result result = null;
                return result;
            }
            Get get2 = new Get(key.getRow());
            ArrayList<KeyValue> results = new ArrayList<KeyValue>();
            store.get(get2, null, results);
            Result result = new Result(results);
            return result;
        }
        finally {
            this.splitsAndClosesLock.readLock().unlock();
        }
    }

    public InternalScanner getScanner(Scan scan) throws IOException {
        return this.getScanner(scan, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InternalScanner getScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        this.newScannerLock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new IOException("Region " + this + " closed");
            }
            if (scan.hasFamilies()) {
                for (byte[] family : scan.getFamilyMap().keySet()) {
                    this.checkFamily(family);
                }
            } else {
                for (byte[] family : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                    scan.addFamily(family);
                }
            }
            InternalScanner internalScanner = this.instantiateInternalScanner(scan, additionalScanners);
            return internalScanner;
        }
        finally {
            this.newScannerLock.readLock().unlock();
        }
    }

    protected InternalScanner instantiateInternalScanner(Scan scan, List<KeyValueScanner> additionalScanners) throws IOException {
        return new RegionScanner(scan, additionalScanners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Delete delete, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        Integer lid = null;
        this.newScannerLock.writeLock().lock();
        this.splitsAndClosesLock.readLock().lock();
        try {
            byte[] row = delete.getRow();
            lid = this.getLock(lockid, row);
            if (delete.getFamilyMap().isEmpty()) {
                for (byte[] byArray : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                    delete.deleteFamily(byArray, delete.getTimeStamp());
                }
            } else {
                for (byte[] byArray : delete.getFamilyMap().keySet()) {
                    if (byArray == null) {
                        throw new NoSuchColumnFamilyException("Empty family is invalid");
                    }
                    this.checkFamily(byArray);
                }
            }
            for (Map.Entry entry : delete.getFamilyMap().entrySet()) {
                byte[] family = (byte[])entry.getKey();
                this.delete(family, (List)entry.getValue(), writeToWAL);
            }
            if (lockid == null) {
                this.releaseRowLock(lid);
            }
            this.splitsAndClosesLock.readLock().unlock();
            this.newScannerLock.writeLock().unlock();
        }
        catch (Throwable throwable) {
            if (lockid == null) {
                this.releaseRowLock(lid);
            }
            this.splitsAndClosesLock.readLock().unlock();
            this.newScannerLock.writeLock().unlock();
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(byte[] family, List<KeyValue> kvs, boolean writeToWAL) throws IOException {
        long now = System.currentTimeMillis();
        byte[] byteNow = Bytes.toBytes(now);
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            if (writeToWAL) {
                this.log.append(this.regionInfo.getRegionName(), this.regionInfo.getTableDesc().getName(), kvs, this.regionInfo.isMetaRegion() || this.regionInfo.isRootRegion(), now);
            }
            long size = 0L;
            Store store = this.getStore(family);
            for (KeyValue kv : kvs) {
                if (kv.isLatestTimestamp() && kv.isDeleteType()) {
                    ArrayList<KeyValue> result = new ArrayList<KeyValue>(1);
                    Get g = new Get(kv.getRow());
                    TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
                    byte[] q = kv.getQualifier();
                    if (q == null) {
                        q = HConstants.EMPTY_BYTE_ARRAY;
                    }
                    qualifiers.add(q);
                    this.get(store, g, qualifiers, result);
                    if (result.isEmpty()) continue;
                    if (result.size() > 1) {
                        throw new RuntimeException("Unexpected size: " + result.size());
                    }
                    KeyValue getkv = (KeyValue)result.get(0);
                    Bytes.putBytes(kv.getBuffer(), kv.getTimestampOffset(), getkv.getBuffer(), getkv.getTimestampOffset(), 8);
                } else {
                    kv.updateLatestStamp(byteNow);
                }
                size = this.memstoreSize.addAndGet(store.delete(kv));
            }
            flush = this.isFlushSize(size);
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (flush) {
            this.requestFlush();
        }
    }

    public void put(Put put) throws IOException {
        this.put(put, null, put.getWriteToWAL());
    }

    public void put(Put put, boolean writeToWAL) throws IOException {
        this.put(put, null, writeToWAL);
    }

    public void put(Put put, Integer lockid) throws IOException {
        this.put(put, lockid, put.getWriteToWAL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Put put, Integer lockid, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.newScannerLock.writeLock().lock();
        this.splitsAndClosesLock.readLock().lock();
        try {
            byte[] row = put.getRow();
            Integer lid = this.getLock(lockid, row);
            byte[] now = Bytes.toBytes(System.currentTimeMillis());
            try {
                for (Map.Entry<byte[], List<KeyValue>> entry : put.getFamilyMap().entrySet()) {
                    byte[] family = entry.getKey();
                    this.checkFamily(family);
                    List<KeyValue> puts = entry.getValue();
                    if (!this.updateKeys(puts, now)) continue;
                    this.put(family, puts, writeToWAL);
                }
            }
            finally {
                if (lockid == null) {
                    this.releaseRowLock(lid);
                }
            }
        }
        finally {
            this.splitsAndClosesLock.readLock().unlock();
            this.newScannerLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkAndPut(byte[] row, byte[] family, byte[] qualifier, byte[] expectedValue, Put put, Integer lockId, boolean writeToWAL) throws IOException {
        this.checkReadOnly();
        this.checkResources();
        this.splitsAndClosesLock.readLock().lock();
        try {
            Integer lid;
            block16: {
                Get get2 = new Get(row, put.getRowLock());
                this.checkFamily(family);
                get2.addColumn(family, qualifier);
                byte[] now = Bytes.toBytes(System.currentTimeMillis());
                lid = this.getLock(lockId, get2.getRow());
                ArrayList<KeyValue> result = new ArrayList<KeyValue>();
                try {
                    for (Map.Entry<byte[], NavigableSet<byte[]>> entry : get2.getFamilyMap().entrySet()) {
                        this.get(this.stores.get(entry.getKey()), get2, entry.getValue(), result);
                    }
                    boolean matches = false;
                    if (result.size() == 0 && expectedValue.length == 0) {
                        matches = true;
                    } else if (result.size() == 1) {
                        byte[] actualValue = ((KeyValue)result.get(0)).getValue();
                        matches = Bytes.equals(expectedValue, actualValue);
                    }
                    if (!matches) break block16;
                    for (Map.Entry<byte[], List<KeyValue>> entry : put.getFamilyMap().entrySet()) {
                        byte[] fam = entry.getKey();
                        this.checkFamily(fam);
                        List<KeyValue> puts = entry.getValue();
                        if (!this.updateKeys(puts, now)) continue;
                        this.put(fam, puts, writeToWAL);
                    }
                    boolean bl = true;
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    return bl;
                }
                catch (Throwable throwable) {
                    if (lockId == null) {
                        this.releaseRowLock(lid);
                    }
                    throw throwable;
                }
            }
            boolean bl = false;
            if (lockId == null) {
                this.releaseRowLock(lid);
            }
            return bl;
        }
        finally {
            this.splitsAndClosesLock.readLock().unlock();
        }
    }

    private boolean updateKeys(List<KeyValue> keys, byte[] now) {
        if (keys == null || keys.isEmpty()) {
            return false;
        }
        for (KeyValue key : keys) {
            if (key.getTimestamp() != Long.MAX_VALUE) continue;
            key.updateLatestStamp(now);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkResources() {
        boolean blocked = false;
        while (this.memstoreSize.get() > this.blockingMemStoreSize) {
            this.requestFlush();
            if (!blocked) {
                LOG.info((Object)("Blocking updates for '" + Thread.currentThread().getName() + "' on region " + Bytes.toStringBinary(this.getRegionName()) + ": memstore size " + StringUtils.humanReadableInt((long)this.memstoreSize.get()) + " is >= than blocking " + StringUtils.humanReadableInt((long)this.blockingMemStoreSize) + " size"));
            }
            blocked = true;
            HRegion hRegion = this;
            synchronized (hRegion) {
                try {
                    this.wait(this.threadWakeFrequency);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
        if (blocked) {
            LOG.info((Object)("Unblocking updates for region " + this + " '" + Thread.currentThread().getName() + "'"));
        }
    }

    protected void checkReadOnly() throws IOException {
        if (this.writestate.isReadOnly()) {
            throw new IOException("region is read only");
        }
    }

    private void put(byte[] family, List<KeyValue> edits) throws IOException {
        this.put(family, edits, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void put(byte[] family, List<KeyValue> edits, boolean writeToWAL) throws IOException {
        if (edits == null || edits.isEmpty()) {
            return;
        }
        boolean flush = false;
        this.updatesLock.readLock().lock();
        try {
            if (writeToWAL) {
                long now = System.currentTimeMillis();
                this.log.append(this.regionInfo.getRegionName(), this.regionInfo.getTableDesc().getName(), edits, this.regionInfo.isMetaRegion() || this.regionInfo.isRootRegion(), now);
            }
            long size = 0L;
            Store store = this.getStore(family);
            for (KeyValue kv : edits) {
                size = this.memstoreSize.addAndGet(store.add(kv));
            }
            flush = this.isFlushSize(size);
        }
        finally {
            this.updatesLock.readLock().unlock();
        }
        if (flush) {
            this.requestFlush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void requestFlush() {
        if (this.flushListener == null) {
            return;
        }
        WriteState writeState = this.writestate;
        synchronized (writeState) {
            if (this.writestate.isFlushRequested()) {
                return;
            }
            this.writestate.flushRequested = true;
        }
        this.flushListener.request(this);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Flush requested on " + this));
        }
    }

    private boolean isFlushSize(long size) {
        return size > this.memstoreFlushSize;
    }

    protected void doReconstructionLog(Path oldLogFile, long minSeqId, long maxSeqId, Progressable reporter) throws UnsupportedEncodingException, IOException {
    }

    protected Store instantiateHStore(Path baseDir, HColumnDescriptor c, Path oldLogFile, Progressable reporter) throws IOException {
        return new Store(baseDir, this, c, this.fs, oldLogFile, this.conf, reporter);
    }

    public Store getStore(byte[] column) {
        return this.stores.get(column);
    }

    private void checkRow(byte[] row) throws IOException {
        if (!HRegion.rowIsInRange(this.regionInfo, row)) {
            throw new WrongRegionException("Requested row out of range for HRegion " + this + ", startKey='" + Bytes.toStringBinary(this.regionInfo.getStartKey()) + "', getEndKey()='" + Bytes.toStringBinary(this.regionInfo.getEndKey()) + "', row='" + Bytes.toStringBinary(row) + "'");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer obtainRowLock(byte[] row) throws IOException {
        this.checkRow(row);
        this.splitsAndClosesLock.readLock().lock();
        try {
            if (this.closed.get()) {
                throw new NotServingRegionException("Region " + this + " closed");
            }
            Integer key = Bytes.mapKey(row);
            Map<Integer, byte[]> map = this.locksToRows;
            synchronized (map) {
                while (this.locksToRows.containsKey(key)) {
                    try {
                        this.locksToRows.wait();
                    }
                    catch (InterruptedException ie) {}
                }
                this.locksToRows.put(key, row);
                this.locksToRows.notifyAll();
                Integer n = key;
                return n;
            }
        }
        finally {
            this.splitsAndClosesLock.readLock().unlock();
        }
    }

    byte[] getRowFromLock(Integer lockid) {
        return this.locksToRows.get(lockid);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void releaseRowLock(Integer lockid) {
        Map<Integer, byte[]> map = this.locksToRows;
        synchronized (map) {
            this.locksToRows.remove(lockid);
            this.locksToRows.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isRowLocked(Integer lockid) {
        Map<Integer, byte[]> map = this.locksToRows;
        synchronized (map) {
            return this.locksToRows.containsKey(lockid);
            {
            }
        }
    }

    private Integer getLock(Integer lockid, byte[] row) throws IOException {
        Integer lid = null;
        if (lockid == null) {
            lid = this.obtainRowLock(row);
        } else {
            if (!this.isRowLocked(lockid)) {
                throw new IOException("Invalid row lock");
            }
            lid = lockid;
        }
        return lid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnRowLocks() {
        Map<Integer, byte[]> map = this.locksToRows;
        synchronized (map) {
            while (this.locksToRows.size() > 0) {
                LOG.debug((Object)("waiting for " + this.locksToRows.size() + " row locks"));
                try {
                    this.locksToRows.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean equals(Object o) {
        return this.hashCode() == ((HRegion)o).hashCode();
    }

    public int hashCode() {
        return this.regionInfo.getRegionName().hashCode();
    }

    public String toString() {
        return this.regionInfo.getRegionNameAsString();
    }

    public Path getBaseDir() {
        return this.basedir;
    }

    public static HRegion newHRegion(Path basedir, HLog log, FileSystem fs, HBaseConfiguration conf, HRegionInfo regionInfo, FlushRequester flushListener) {
        try {
            Class regionClass = conf.getClass("hbase.hregion.impl", HRegion.class);
            Constructor c = regionClass.getConstructor(Path.class, HLog.class, FileSystem.class, HBaseConfiguration.class, HRegionInfo.class, FlushRequester.class);
            return (HRegion)c.newInstance(new Object[]{basedir, log, fs, conf, regionInfo, flushListener});
        }
        catch (Throwable e) {
            throw new IllegalStateException("Could not instantiate a region instance.", e);
        }
    }

    public static HRegion createHRegion(HRegionInfo info, Path rootDir, HBaseConfiguration conf) throws IOException {
        Path tableDir = HTableDescriptor.getTableDir(rootDir, info.getTableDesc().getName());
        Path regionDir = HRegion.getRegionDir(tableDir, info.getEncodedName());
        FileSystem fs = FileSystem.get((Configuration)conf);
        fs.mkdirs(regionDir);
        HRegion region = HRegion.newHRegion(tableDir, new HLog(fs, new Path(regionDir, ".logs"), conf, null), fs, conf, info, null);
        region.initialize(null, null);
        return region;
    }

    public static HRegion openHRegion(HRegionInfo info, Path rootDir, HLog log, HBaseConfiguration conf) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Opening region: " + (Object)((Object)info)));
        }
        if (info == null) {
            throw new NullPointerException("Passed region info is null");
        }
        HRegion r = HRegion.newHRegion(HTableDescriptor.getTableDir(rootDir, info.getTableDesc().getName()), log, FileSystem.get((Configuration)conf), conf, info, null);
        r.initialize(null, null);
        if (log != null) {
            log.setSequenceNumber(r.getMinSequenceId());
        }
        return r;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegionToMETA(HRegion meta, HRegion r) throws IOException {
        meta.checkResources();
        byte[] row = r.getRegionName();
        Integer lid = meta.obtainRowLock(row);
        try {
            ArrayList<KeyValue> edits = new ArrayList<KeyValue>();
            edits.add(new KeyValue(row, CATALOG_FAMILY, REGIONINFO_QUALIFIER, System.currentTimeMillis(), Writables.getBytes((Writable)r.getRegionInfo())));
            meta.put(HConstants.CATALOG_FAMILY, edits);
        }
        finally {
            meta.releaseRowLock(lid);
        }
    }

    public static void removeRegionFromMETA(HRegionInterface srvr, byte[] metaRegionName, byte[] regionName) throws IOException {
        Delete delete = new Delete(regionName);
        delete.deleteFamily(HConstants.CATALOG_FAMILY);
        srvr.delete(metaRegionName, delete);
    }

    public static void offlineRegionInMETA(HRegionInterface srvr, byte[] metaRegionName, HRegionInfo info) throws IOException {
        byte[] row = info.getRegionName();
        Put put = new Put(row);
        info.setOffline(true);
        put.add(CATALOG_FAMILY, REGIONINFO_QUALIFIER, Writables.getBytes((Writable)info));
        srvr.put(metaRegionName, put);
        HRegion.cleanRegionInMETA(srvr, metaRegionName, info);
    }

    public static void cleanRegionInMETA(HRegionInterface srvr, byte[] metaRegionName, HRegionInfo info) throws IOException {
        Delete del = new Delete(info.getRegionName());
        del.deleteColumns(CATALOG_FAMILY, SERVER_QUALIFIER);
        del.deleteColumns(CATALOG_FAMILY, STARTCODE_QUALIFIER);
        srvr.delete(metaRegionName, del);
    }

    public static void deleteRegion(FileSystem fs, Path rootdir, HRegionInfo info) throws IOException {
        HRegion.deleteRegion(fs, HRegion.getRegionDir(rootdir, info));
    }

    private static void deleteRegion(FileSystem fs, Path regiondir) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("DELETING region " + regiondir.toString()));
        }
        if (!fs.delete(regiondir, true)) {
            LOG.warn((Object)("Failed delete of " + regiondir));
        }
    }

    public static Path getRegionDir(Path tabledir, int name) {
        return new Path(tabledir, Integer.toString(name));
    }

    public static Path getRegionDir(Path rootdir, HRegionInfo info) {
        return new Path(HTableDescriptor.getTableDir(rootdir, info.getTableDesc().getName()), Integer.toString(info.getEncodedName()));
    }

    public static boolean rowIsInRange(HRegionInfo info, byte[] row) {
        return !(info.getStartKey().length != 0 && Bytes.compareTo(info.getStartKey(), row) > 0 || info.getEndKey().length != 0 && Bytes.compareTo(info.getEndKey(), row) <= 0);
    }

    public static void makeColumnFamilyDirs(FileSystem fs, Path tabledir, HRegionInfo hri, byte[] colFamily) throws IOException {
        Path dir = Store.getStoreHomedir(tabledir, hri.getEncodedName(), colFamily);
        if (!fs.mkdirs(dir)) {
            LOG.warn((Object)("Failed to create " + dir));
        }
    }

    public static HRegion mergeAdjacent(HRegion srcA, HRegion srcB) throws IOException {
        HRegion a = srcA;
        HRegion b = srcB;
        if (srcA.getStartKey() == null) {
            if (srcB.getStartKey() == null) {
                throw new IOException("Cannot merge two regions with null start key");
            }
        } else if (srcB.getStartKey() == null || Bytes.compareTo(srcA.getStartKey(), srcB.getStartKey()) > 0) {
            a = srcB;
            b = srcA;
        }
        if (Bytes.compareTo(a.getEndKey(), b.getStartKey()) != 0) {
            throw new IOException("Cannot merge non-adjacent regions");
        }
        return HRegion.merge(a, b);
    }

    public static HRegion merge(HRegion a, HRegion b) throws IOException {
        byte[] startKey;
        if (!a.getRegionInfo().getTableDesc().getNameAsString().equals(b.getRegionInfo().getTableDesc().getNameAsString())) {
            throw new IOException("Regions do not belong to the same table");
        }
        FileSystem fs = a.getFilesystem();
        a.flushcache();
        b.flushcache();
        a.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + a));
            HRegion.listPaths(fs, a.getRegionDir());
        }
        b.compactStores(true);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Files for region: " + b));
            HRegion.listPaths(fs, b.getRegionDir());
        }
        HBaseConfiguration conf = a.getConf();
        HTableDescriptor tabledesc = a.getTableDesc();
        HLog log = a.getLog();
        Path basedir = a.getBaseDir();
        byte[] byArray = a.comparator.matchingRows(a.getStartKey(), 0, a.getStartKey().length, EMPTY_BYTE_ARRAY, 0, EMPTY_BYTE_ARRAY.length) || b.comparator.matchingRows(b.getStartKey(), 0, b.getStartKey().length, EMPTY_BYTE_ARRAY, 0, EMPTY_BYTE_ARRAY.length) ? EMPTY_BYTE_ARRAY : (startKey = a.comparator.compareRows(a.getStartKey(), 0, a.getStartKey().length, b.getStartKey(), 0, b.getStartKey().length) <= 0 ? a.getStartKey() : b.getStartKey());
        byte[] endKey = a.comparator.matchingRows(a.getEndKey(), 0, a.getEndKey().length, EMPTY_BYTE_ARRAY, 0, EMPTY_BYTE_ARRAY.length) || a.comparator.matchingRows(b.getEndKey(), 0, b.getEndKey().length, EMPTY_BYTE_ARRAY, 0, EMPTY_BYTE_ARRAY.length) ? EMPTY_BYTE_ARRAY : (a.comparator.compareRows(a.getEndKey(), 0, a.getEndKey().length, b.getEndKey(), 0, b.getEndKey().length) <= 0 ? b.getEndKey() : a.getEndKey());
        HRegionInfo newRegionInfo = new HRegionInfo(tabledesc, startKey, endKey);
        LOG.info((Object)("Creating new region " + newRegionInfo.toString()));
        int encodedName = newRegionInfo.getEncodedName();
        Path newRegionDir = HRegion.getRegionDir(a.getBaseDir(), encodedName);
        if (fs.exists(newRegionDir)) {
            throw new IOException("Cannot merge; target file collision at " + newRegionDir);
        }
        fs.mkdirs(newRegionDir);
        LOG.info((Object)("starting merge of regions: " + a + " and " + b + " into new region " + newRegionInfo.toString() + " with start key <" + Bytes.toString(startKey) + "> and end key <" + Bytes.toString(endKey) + ">"));
        Map<byte[], List<StoreFile>> byFamily = new TreeMap<byte[], List<StoreFile>>(Bytes.BYTES_COMPARATOR);
        byFamily = HRegion.filesByFamily(byFamily, a.close());
        byFamily = HRegion.filesByFamily(byFamily, b.close());
        for (Map.Entry<byte[], List<StoreFile>> es : byFamily.entrySet()) {
            long seqB;
            long seqA;
            byte[] colFamily = es.getKey();
            HRegion.makeColumnFamilyDirs(fs, basedir, newRegionInfo, colFamily);
            List<StoreFile> srcFiles = es.getValue();
            if (srcFiles.size() == 2 && (seqA = srcFiles.get(0).getMaxSequenceId()) == (seqB = srcFiles.get(1).getMaxSequenceId())) {
                throw new IOException("Files have same sequenceid: " + seqA);
            }
            for (StoreFile hsf : srcFiles) {
                StoreFile.rename(fs, hsf.getPath(), StoreFile.getUniqueFile(fs, Store.getStoreHomedir(basedir, newRegionInfo.getEncodedName(), colFamily)));
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, newRegionDir);
        }
        HRegion dstRegion = HRegion.newHRegion(basedir, log, fs, conf, newRegionInfo, null);
        dstRegion.initialize(null, null);
        dstRegion.compactStores();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Files for new region");
            HRegion.listPaths(fs, dstRegion.getRegionDir());
        }
        HRegion.deleteRegion(fs, a.getRegionDir());
        HRegion.deleteRegion(fs, b.getRegionDir());
        LOG.info((Object)("merge completed. New region is " + dstRegion));
        return dstRegion;
    }

    private static Map<byte[], List<StoreFile>> filesByFamily(Map<byte[], List<StoreFile>> byFamily, List<StoreFile> storeFiles) {
        for (StoreFile src : storeFiles) {
            byte[] family = src.getFamily();
            List<StoreFile> v = byFamily.get(family);
            if (v == null) {
                v = new ArrayList<StoreFile>();
                byFamily.put(family, v);
            }
            v.add(src);
        }
        return byFamily;
    }

    boolean isMajorCompaction() throws IOException {
        for (Store store : this.stores.values()) {
            if (!store.isMajorCompaction()) continue;
            return true;
        }
        return false;
    }

    private static void listPaths(FileSystem fs, Path dir) throws IOException {
        if (LOG.isDebugEnabled()) {
            FileStatus[] stats = fs.listStatus(dir);
            if (stats == null || stats.length == 0) {
                return;
            }
            for (int i = 0; i < stats.length; ++i) {
                String path = stats[i].getPath().toString();
                if (stats[i].isDir()) {
                    LOG.debug((Object)("d " + path));
                    HRegion.listPaths(fs, stats[i].getPath());
                    continue;
                }
                LOG.debug((Object)("f " + path + " size=" + stats[i].getLen()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result get(Get get2, Integer lockid) throws IOException {
        if (get2.hasFamilies()) {
            for (byte[] family : get2.familySet()) {
                this.checkFamily(family);
            }
        } else {
            for (byte[] family : this.regionInfo.getTableDesc().getFamiliesKeys()) {
                get2.addFamily(family);
            }
        }
        Integer lid = this.getLock(lockid, get2.getRow());
        ArrayList<KeyValue> result = new ArrayList<KeyValue>();
        try {
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : get2.getFamilyMap().entrySet()) {
                this.get(this.stores.get(entry.getKey()), get2, entry.getValue(), result);
            }
        }
        finally {
            if (lockid == null) {
                this.releaseRowLock(lid);
            }
        }
        return new Result(result);
    }

    private void get(Store store, Get get2, NavigableSet<byte[]> qualifiers, List<KeyValue> result) throws IOException {
        store.get(get2, qualifiers, result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long incrementColumnValue(byte[] row, byte[] family, byte[] qualifier, long amount, boolean writeToWAL) throws IOException {
        this.checkRow(row);
        boolean flush = false;
        Integer lid = this.obtainRowLock(row);
        long result = amount;
        try {
            Store store = this.stores.get(family);
            Get get2 = new Get(row);
            get2.addColumn(family, qualifier);
            ArrayList<KeyValue> results = new ArrayList<KeyValue>();
            TreeSet<byte[]> qualifiers = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            qualifiers.add(qualifier);
            store.get(get2, qualifiers, results);
            if (!results.isEmpty()) {
                KeyValue kv = (KeyValue)results.get(0);
                byte[] buffer = kv.getBuffer();
                int valueOffset = kv.getValueOffset();
                result += Bytes.toLong(buffer, valueOffset, 8);
            }
            KeyValue newKv = new KeyValue(row, family, qualifier, System.currentTimeMillis(), Bytes.toBytes(result));
            if (writeToWAL) {
                long now = System.currentTimeMillis();
                ArrayList<KeyValue> edits = new ArrayList<KeyValue>(1);
                edits.add(newKv);
                this.log.append(this.regionInfo.getRegionName(), this.regionInfo.getTableDesc().getName(), edits, this.regionInfo.isMetaRegion() || this.regionInfo.isRootRegion(), now);
            }
            long size = store.updateColumnValue(row, family, qualifier, result);
            size = this.memstoreSize.addAndGet(size);
            flush = this.isFlushSize(size);
        }
        finally {
            this.releaseRowLock(lid);
        }
        if (flush) {
            this.requestFlush();
        }
        return result;
    }

    private void checkFamily(byte[] family) throws NoSuchColumnFamilyException {
        if (!this.regionInfo.getTableDesc().hasFamily(family)) {
            throw new NoSuchColumnFamilyException("Column family " + Bytes.toString(family) + " does not exist in region " + this + " in table " + this.regionInfo.getTableDesc());
        }
    }

    @Override
    public long heapSize() {
        long heapSize = DEEP_OVERHEAD;
        for (Store store : this.stores.values()) {
            heapSize += store.heapSize();
        }
        return heapSize;
    }

    private static void printUsageAndExit(String message) {
        if (message != null && message.length() > 0) {
            System.out.println(message);
        }
        System.out.println("Usage: HRegion CATLALOG_TABLE_DIR [major_compact]");
        System.out.println("Options:");
        System.out.println(" major_compact  Pass this option to major compact passed region.");
        System.out.println("Default outputs scan of passed region.");
        System.exit(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processTable(FileSystem fs, Path p, HLog log, HBaseConfiguration c, boolean majorCompact2) throws IOException {
        block12: {
            HRegion region = null;
            String rootStr = Bytes.toString(HConstants.ROOT_TABLE_NAME);
            String metaStr = Bytes.toString(HConstants.META_TABLE_NAME);
            if (p.getName().startsWith(rootStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.ROOT_REGIONINFO, null);
            } else if (p.getName().startsWith(metaStr)) {
                region = HRegion.newHRegion(p, log, fs, c, HRegionInfo.FIRST_META_REGIONINFO, null);
            } else {
                throw new IOException("Not a known catalog table: " + p.toString());
            }
            try {
                region.initialize(null, null);
                if (majorCompact2) {
                    region.compactStores(true);
                    break block12;
                }
                Scan scan = new Scan();
                InternalScanner scanner = region.getScanner(scan);
                try {
                    ArrayList<KeyValue> kvs = new ArrayList<KeyValue>();
                    boolean done = false;
                    do {
                        kvs.clear();
                        done = scanner.next(kvs);
                        if (kvs.size() <= 0) continue;
                        LOG.info(kvs);
                    } while (done);
                }
                finally {
                    scanner.close();
                }
            }
            finally {
                region.close();
            }
        }
    }

    public boolean shouldSplit(boolean b) {
        boolean old = this.splitRequest;
        this.splitRequest = b;
        return old;
    }

    public boolean hasTooManyStoreFiles() {
        for (Store store : this.stores.values()) {
            if (!store.hasTooManyStoreFiles()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        if (args.length < 1) {
            HRegion.printUsageAndExit(null);
        }
        boolean majorCompact2 = false;
        if (args.length > 1) {
            if (!args[1].toLowerCase().startsWith("major")) {
                HRegion.printUsageAndExit("ERROR: Unrecognized option <" + args[1] + ">");
            }
            majorCompact2 = true;
        }
        Path tableDir = new Path(args[0]);
        HBaseConfiguration c = new HBaseConfiguration();
        FileSystem fs = FileSystem.get((Configuration)c);
        Path logdir = new Path(c.get("hbase.tmp.dir"), "hlog" + tableDir.getName() + System.currentTimeMillis());
        HLog log = new HLog(fs, logdir, c, null);
        try {
            HRegion.processTable(fs, tableDir, log, c, majorCompact2);
        }
        finally {
            log.close();
            BlockCache bc = StoreFile.getBlockCache(c);
            if (bc != null) {
                bc.shutdown();
            }
        }
    }

    class RegionScanner
    implements InternalScanner {
        private final KeyValueHeap storeHeap;
        private final byte[] stopRow;
        private Filter filter;
        private RowFilterInterface oldFilter;
        private List<KeyValue> results = new ArrayList<KeyValue>();

        RegionScanner(Scan scan, List<KeyValueScanner> additionalScanners) {
            this.filter = scan.getFilter();
            this.oldFilter = scan.getOldFilter();
            this.stopRow = (byte[])(Bytes.equals(scan.getStopRow(), HConstants.EMPTY_END_ROW) ? null : scan.getStopRow());
            ArrayList<KeyValueScanner> scanners = new ArrayList<KeyValueScanner>();
            if (additionalScanners != null) {
                scanners.addAll(additionalScanners);
            }
            for (Map.Entry<byte[], NavigableSet<byte[]>> entry : scan.getFamilyMap().entrySet()) {
                Store store = HRegion.this.stores.get(entry.getKey());
                scanners.add(store.getScanner(scan, entry.getValue()));
            }
            this.storeHeap = new KeyValueHeap(scanners.toArray(new KeyValueScanner[0]), HRegion.this.comparator);
        }

        RegionScanner(Scan scan) {
            this(scan, null);
        }

        protected void resetFilters() {
            if (this.filter != null) {
                this.filter.reset();
            }
            if (this.oldFilter != null) {
                this.oldFilter.reset();
            }
        }

        @Override
        public boolean next(List<KeyValue> outResults) throws IOException {
            if (HRegion.this.closing.get() || HRegion.this.closed.get()) {
                this.close();
                throw new NotServingRegionException(HRegion.this.regionInfo.getRegionNameAsString() + " is closing=" + HRegion.this.closing.get() + " or closed=" + HRegion.this.closed.get());
            }
            this.results.clear();
            boolean returnResult = this.nextInternal();
            if (!returnResult && this.filterRow()) {
                this.results.clear();
            }
            outResults.addAll(this.results);
            this.resetFilters();
            if (this.isFilterDone()) {
                return false;
            }
            return returnResult;
        }

        boolean isFilterDone() {
            return this.filter != null && this.filter.filterAllRemaining() || this.oldFilter != null && this.oldFilter.filterAllRemaining();
        }

        private boolean nextInternal() throws IOException {
            boolean stopRow;
            while (true) {
                byte[] nextRow;
                byte[] currentRow;
                if (this.isStopRow(currentRow = this.peekRow())) {
                    return false;
                }
                if (this.filterRowKey(currentRow)) {
                    this.nextRow(currentRow);
                    continue;
                }
                do {
                    this.storeHeap.next(this.results);
                } while (Bytes.equals(currentRow, nextRow = this.peekRow()));
                stopRow = this.isStopRow(nextRow);
                if (stopRow || !this.results.isEmpty() && !this.filterRow()) break;
                this.nextRow(currentRow);
            }
            return !stopRow;
        }

        protected void nextRow(byte[] currentRow) throws IOException {
            while (Bytes.equals(currentRow, this.peekRow())) {
                this.storeHeap.next(MOCKED_LIST);
            }
            this.results.clear();
            this.resetFilters();
        }

        private boolean isStopRow(byte[] currentRow) {
            return currentRow == null || this.stopRow != null && HRegion.this.comparator.compareRows(this.stopRow, 0, this.stopRow.length, currentRow, 0, currentRow.length) <= 0;
        }

        private boolean filterRow() {
            return this.filter != null && this.filter.filterRow() || this.oldFilter != null && this.oldFilter.filterRow(this.results);
        }

        private byte[] peekRow() {
            KeyValue kv = this.storeHeap.peek();
            return kv == null ? null : kv.getRow();
        }

        private boolean filterRowKey(byte[] row) {
            return this.filter != null && this.filter.filterRowKey(row, 0, row.length) || this.oldFilter != null && this.oldFilter.filterRowKey(row, 0, row.length);
        }

        @Override
        public void close() {
            this.storeHeap.close();
        }

        public void close(KeyValueScanner scanner) {
            try {
                scanner.close();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        public KeyValueHeap getStoreHeap() {
            return this.storeHeap;
        }
    }

    static class WriteState {
        volatile boolean flushing = false;
        volatile boolean flushRequested = false;
        volatile boolean compacting = false;
        volatile boolean writesEnabled = true;
        volatile boolean readOnly = false;

        WriteState() {
        }

        synchronized void setReadOnly(boolean onOff) {
            this.writesEnabled = !onOff;
            this.readOnly = onOff;
        }

        boolean isReadOnly() {
            return this.readOnly;
        }

        boolean isFlushRequested() {
            return this.flushRequested;
        }
    }
}

