/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.DroppedSnapshotException;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.RemoteExceptionHandler;
import org.apache.hadoop.hbase.regionserver.FlushRequester;
import org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hadoop.hbase.regionserver.HRegionServer;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.util.StringUtils;

class MemStoreFlusher
extends Thread
implements FlushRequester {
    static final Log LOG = LogFactory.getLog(MemStoreFlusher.class);
    private final BlockingQueue<HRegion> flushQueue = new LinkedBlockingQueue<HRegion>();
    private final HashSet<HRegion> regionsInQueue = new HashSet();
    private final long threadWakeFrequency;
    private final HRegionServer server;
    private final ReentrantLock lock = new ReentrantLock();
    protected final long globalMemStoreLimit;
    protected final long globalMemStoreLimitLowMark;
    private static final float DEFAULT_UPPER = 0.4f;
    private static final float DEFAULT_LOWER = 0.25f;
    private static final String UPPER_KEY = "hbase.regionserver.global.memstore.upperLimit";
    private static final String LOWER_KEY = "hbase.regionserver.global.memstore.lowerLimit";
    private long blockingStoreFilesNumber;
    private long blockingWaitTime;

    public MemStoreFlusher(HBaseConfiguration conf, HRegionServer server) {
        this.server = server;
        this.threadWakeFrequency = conf.getLong("hbase.server.thread.wakefrequency", 10000L);
        long max = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax();
        this.globalMemStoreLimit = MemStoreFlusher.globalMemStoreLimit(max, 0.4f, UPPER_KEY, conf);
        long lower = MemStoreFlusher.globalMemStoreLimit(max, 0.25f, LOWER_KEY, conf);
        if (lower > this.globalMemStoreLimit) {
            lower = this.globalMemStoreLimit;
            LOG.info((Object)"Setting globalMemStoreLimitLowMark == globalMemStoreLimit because supplied hbase.regionserver.global.memstore.lowerLimit was > hbase.regionserver.global.memstore.upperLimit");
        }
        this.globalMemStoreLimitLowMark = lower;
        this.blockingStoreFilesNumber = conf.getInt("hbase.hstore.blockingStoreFiles", -1);
        if (this.blockingStoreFilesNumber == -1L) {
            this.blockingStoreFilesNumber = 1 + conf.getInt("hbase.hstore.compactionThreshold", 3);
        }
        this.blockingWaitTime = conf.getInt("hbase.hstore.blockingWaitTime", 90000);
        LOG.info((Object)("globalMemStoreLimit=" + StringUtils.humanReadableInt((long)this.globalMemStoreLimit) + ", globalMemStoreLimitLowMark=" + StringUtils.humanReadableInt((long)this.globalMemStoreLimitLowMark) + ", maxHeap=" + StringUtils.humanReadableInt((long)max)));
    }

    static long globalMemStoreLimit(long max, float defaultLimit, String key, HBaseConfiguration c) {
        float limit = c.getFloat(key, defaultLimit);
        return MemStoreFlusher.getMemStoreLimit(max, limit, defaultLimit);
    }

    static long getMemStoreLimit(long max, float limit, float defaultLimit) {
        if (limit >= 0.9f || limit < 0.1f) {
            LOG.warn((Object)("Setting global memstore limit to default of " + defaultLimit + " because supplied value outside allowed range of 0.1 -> 0.9"));
        }
        return (long)((float)max * limit);
    }

    @Override
    public void run() {
        while (!this.server.isStopRequested() && this.server.isInSafeMode()) {
            try {
                Thread.sleep(this.threadWakeFrequency);
            }
            catch (InterruptedException ex) {}
        }
        while (!this.server.isStopRequested()) {
            HRegion r = null;
            try {
                r = this.flushQueue.poll(this.threadWakeFrequency, TimeUnit.MILLISECONDS);
                if (r == null || this.flushRegion(r, false)) continue;
                break;
            }
            catch (InterruptedException ex) {
            }
            catch (ConcurrentModificationException ex) {
            }
            catch (Exception ex) {
                LOG.error((Object)("Cache flush failed" + (r != null ? " for region " + Bytes.toString(r.getRegionName()) : "")), (Throwable)ex);
                if (this.server.checkFileSystem()) continue;
                break;
            }
        }
        this.regionsInQueue.clear();
        this.flushQueue.clear();
        LOG.info((Object)(this.getName() + " exiting"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void request(HRegion r) {
        HashSet<HRegion> hashSet = this.regionsInQueue;
        synchronized (hashSet) {
            if (!this.regionsInQueue.contains(r)) {
                this.regionsInQueue.add(r);
                this.flushQueue.add(r);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void interruptIfNecessary() {
        this.lock.lock();
        try {
            this.interrupt();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean flushRegion(HRegion region, boolean removeFromQueue) {
        this.checkStoreFileCount(region);
        HashSet<HRegion> hashSet = this.regionsInQueue;
        synchronized (hashSet) {
            if (this.regionsInQueue.remove(region) && removeFromQueue) {
                this.flushQueue.remove(region);
            }
            this.lock.lock();
        }
        try {
            if (region.flushcache() && !removeFromQueue) {
                this.server.compactSplitThread.compactionRequested(region, this.getName());
            }
        }
        catch (DroppedSnapshotException ex) {
            LOG.fatal((Object)"Replay of hlog required. Forcing server shutdown", (Throwable)ex);
            this.server.abort();
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            LOG.error((Object)("Cache flush failed" + (region != null ? " for region " + Bytes.toString(region.getRegionName()) : "")), (Throwable)RemoteExceptionHandler.checkIOException(ex));
            if (!this.server.checkFileSystem()) {
                boolean bl = false;
                return bl;
            }
        }
        finally {
            this.lock.unlock();
        }
        return true;
    }

    private void checkStoreFileCount(HRegion region) {
        if (region.getRegionInfo().isMetaRegion()) {
            return;
        }
        int count = 0;
        boolean triggered = false;
        boolean finished = false;
        while ((long)count++ < this.blockingWaitTime / 500L) {
            finished = true;
            for (Store hstore : region.stores.values()) {
                if ((long)hstore.getStorefilesCount() <= this.blockingStoreFilesNumber) continue;
                if (!triggered) {
                    LOG.info((Object)("Too many store files for region " + region + ": " + hstore.getStorefilesCount() + ", requesting compaction and " + "waiting"));
                    this.server.compactSplitThread.compactionRequested(region, this.getName());
                    triggered = true;
                }
                finished = false;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException e) {}
            }
            if (!triggered || !finished) continue;
            LOG.info((Object)("Compaction has completed, we waited " + count * 500 + "ms, " + "finishing flush of region " + region));
            break;
        }
        if (triggered && !finished) {
            LOG.warn((Object)("Tried to hold up flushing for compactions of region " + region + " but have waited longer than " + this.blockingWaitTime + "ms, continuing"));
        }
    }

    public synchronized void reclaimMemStoreMemory() {
        if (this.server.getGlobalMemStoreSize() >= this.globalMemStoreLimit) {
            this.flushSomeRegions();
        }
    }

    private synchronized void flushSomeRegions() {
        long globalMemStoreSize = -1L;
        ArrayList<HRegion> regionsToCompact = new ArrayList<HRegion>();
        SortedMap<Long, HRegion> m = this.server.getCopyOfOnlineRegionsSortedBySize();
        while ((globalMemStoreSize = this.server.getGlobalMemStoreSize()) >= this.globalMemStoreLimitLowMark) {
            if (m.size() <= 0) {
                LOG.info((Object)("No online regions to flush though we've been asked flush some; globalMemStoreSize=" + StringUtils.humanReadableInt((long)globalMemStoreSize) + ", globalMemStoreLimitLowMark=" + StringUtils.humanReadableInt((long)this.globalMemStoreLimitLowMark)));
                break;
            }
            HRegion biggestMemStoreRegion = (HRegion)m.remove(m.firstKey());
            LOG.info((Object)("Forced flushing of " + biggestMemStoreRegion.toString() + " because global memstore limit of " + StringUtils.humanReadableInt((long)this.globalMemStoreLimit) + " exceeded; currently " + StringUtils.humanReadableInt((long)globalMemStoreSize) + " and flushing till " + StringUtils.humanReadableInt((long)this.globalMemStoreLimitLowMark)));
            if (!this.flushRegion(biggestMemStoreRegion, true)) {
                LOG.warn((Object)"Flush failed");
                break;
            }
            regionsToCompact.add(biggestMemStoreRegion);
        }
        for (HRegion region : regionsToCompact) {
            this.server.compactSplitThread.compactionRequested(region, this.getName());
        }
    }
}

