/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.rest;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.io.RowResult;
import org.apache.hadoop.hbase.rest.AbstractController;
import org.apache.hadoop.hbase.rest.AbstractModel;
import org.apache.hadoop.hbase.rest.RowModel;
import org.apache.hadoop.hbase.rest.Status;
import org.apache.hadoop.hbase.rest.descriptors.RowUpdateDescriptor;
import org.apache.hadoop.hbase.rest.exception.HBaseRestException;
import org.apache.hadoop.hbase.rest.parser.IHBaseRestParser;
import org.apache.hadoop.hbase.util.Bytes;

public class RowController
extends AbstractController {
    private Log LOG = LogFactory.getLog(RowController.class);

    protected RowModel getModel() {
        return (RowModel)this.model;
    }

    @Override
    protected AbstractModel generateModel(HBaseConfiguration conf, HBaseAdmin admin) {
        return new RowModel(conf, admin);
    }

    @Override
    public void get(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        RowModel innerModel = this.getModel();
        s.setNoQueryResults();
        byte[] tableName = pathSegments[0];
        byte[] rowName = pathSegments[2];
        RowResult row = null;
        if (queryMap.size() == 0 && pathSegments.length <= 3) {
            row = innerModel.get(tableName, rowName);
        } else if (pathSegments.length == 4 && Bytes.toString(pathSegments[3]).toLowerCase().equals("timestamps")) {
            innerModel.getTimestamps(tableName, rowName);
        } else {
            row = innerModel.get(tableName, rowName, this.getColumnsFromQueryMap(queryMap));
        }
        if (row == null) {
            throw new HBaseRestException("row not found");
        }
        s.setOK(row);
        s.respond();
    }

    @Override
    public void post(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        RowModel innerModel = this.getModel();
        RowUpdateDescriptor rud = parser.getRowUpdateDescriptor(input, pathSegments);
        if (input.length == 0) {
            s.setUnsupportedMediaType("no data send with post request");
            s.respond();
            return;
        }
        Put put = new Put(Bytes.toBytes(rud.getRowName()));
        for (byte[] key : rud.getColVals().keySet()) {
            byte[][] famAndQf = KeyValue.parseColumn(key);
            put.add(famAndQf[0], famAndQf[1], rud.getColVals().get(key));
        }
        try {
            innerModel.post(rud.getTableName().getBytes(), put);
            s.setOK();
        }
        catch (HBaseRestException e) {
            s.setUnsupportedMediaType(e.getMessage());
        }
        s.respond();
    }

    @Override
    public void put(Status s, byte[][] pathSegments, Map<String, String[]> queryMap, byte[] input, IHBaseRestParser parser) throws HBaseRestException {
        s.setMethodNotImplemented();
        s.respond();
    }

    @Override
    public void delete(Status s, byte[][] pathSegments, Map<String, String[]> queryMap) throws HBaseRestException {
        RowModel innerModel = this.getModel();
        byte[] tableName = pathSegments[0];
        byte[] rowName = pathSegments[2];
        if (queryMap.size() == 0) {
            innerModel.delete(tableName, rowName);
        } else {
            innerModel.delete(tableName, rowName, this.getColumnsFromQueryMap(queryMap));
        }
        s.setOK();
        s.respond();
    }
}

