/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.util;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.Comparator;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.io.RawComparator;
import org.apache.hadoop.io.WritableComparator;
import org.apache.hadoop.io.WritableUtils;

public class Bytes {
    public static final int SIZEOF_BOOLEAN = 1;
    public static final int SIZEOF_BYTE = 1;
    public static final int SIZEOF_CHAR = 2;
    public static final int SIZEOF_DOUBLE = 8;
    public static final int SIZEOF_FLOAT = 4;
    public static final int SIZEOF_INT = 4;
    public static final int SIZEOF_LONG = 8;
    public static final int SIZEOF_SHORT = 2;
    public static final int ESTIMATED_HEAP_TAX = 16;
    public static Comparator<byte[]> BYTES_COMPARATOR = new ByteArrayComparator();
    public static RawComparator<byte[]> BYTES_RAWCOMPARATOR = new ByteArrayComparator();

    public static byte[] readByteArray(DataInput in) throws IOException {
        int len = WritableUtils.readVInt((DataInput)in);
        return Bytes.readByteArray(in, len);
    }

    public static byte[] readByteArray(DataInput in, int len) throws IOException {
        if (len < 0) {
            throw new NegativeArraySizeException(Integer.toString(len));
        }
        byte[] result = new byte[len];
        in.readFully(result, 0, len);
        return result;
    }

    public static byte[] readByteArrayThrowsRuntime(DataInput in) {
        try {
            return Bytes.readByteArray(in);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b) throws IOException {
        if (b == null) {
            WritableUtils.writeVInt((DataOutput)out, (int)0);
        } else {
            Bytes.writeByteArray(out, b, 0, b.length);
        }
    }

    public static void writeByteArray(DataOutput out, byte[] b, int offset, int length) throws IOException {
        WritableUtils.writeVInt((DataOutput)out, (int)length);
        out.write(b, offset, length);
    }

    public static int writeByteArray(byte[] tgt, int tgtOffset, byte[] src, int srcOffset, int srcLength) {
        byte[] vint = Bytes.vintToBytes(srcLength);
        System.arraycopy(vint, 0, tgt, tgtOffset, vint.length);
        int offset = tgtOffset + vint.length;
        System.arraycopy(src, srcOffset, tgt, offset, srcLength);
        return offset + srcLength;
    }

    public static int putBytes(byte[] tgtBytes, int tgtOffset, byte[] srcBytes, int srcOffset, int srcLength) {
        System.arraycopy(srcBytes, srcOffset, tgtBytes, tgtOffset, srcLength);
        return tgtOffset + srcLength;
    }

    public static int putByte(byte[] bytes, int offset, byte b) {
        bytes[offset] = b;
        return offset + 1;
    }

    public static byte[] toBytes(ByteBuffer bb) {
        int length = bb.limit();
        byte[] result = new byte[length];
        System.arraycopy(bb.array(), bb.arrayOffset(), result, 0, length);
        return result;
    }

    public static String toString(byte[] b) {
        if (b == null) {
            return null;
        }
        return Bytes.toString(b, 0, b.length);
    }

    public static String toString(byte[] b1, String sep, byte[] b2) {
        return Bytes.toString(b1, 0, b1.length) + sep + Bytes.toString(b2, 0, b2.length);
    }

    public static String toString(byte[] b, int off, int len) {
        if (b == null) {
            return null;
        }
        if (len == 0) {
            return "";
        }
        String result = null;
        try {
            result = new String(b, off, len, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String toStringBinary(byte[] b) {
        return Bytes.toStringBinary(b, 0, b.length);
    }

    public static String toStringBinary(byte[] b, int off, int len) {
        StringBuilder result = new StringBuilder();
        try {
            String first = new String(b, off, len, "ISO-8859-1");
            for (int i = 0; i < first.length(); ++i) {
                int ch = first.charAt(i) & 0xFF;
                if (ch >= 48 && ch <= 57 || ch >= 65 && ch <= 90 || ch >= 97 && ch <= 122 || ch == 44 || ch == 95 || ch == 45 || ch == 58 || ch == 32 || ch == 60 || ch == 62 || ch == 61 || ch == 47 || ch == 46) {
                    result.append(first.charAt(i));
                    continue;
                }
                result.append(String.format("\\x%02X", ch));
            }
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result.toString();
    }

    private static boolean isHexDigit(char c) {
        return c >= 'A' && c <= 'F' || c >= '0' && c <= '9';
    }

    public static byte toBinaryFromHex(byte ch) {
        if (ch >= 65 && ch <= 70) {
            return (byte)(10 + (byte)(ch - 65));
        }
        return (byte)(ch - 48);
    }

    public static byte[] toBytesBinary(String in) {
        byte[] b = new byte[in.length()];
        int size = 0;
        for (int i = 0; i < in.length(); ++i) {
            char ch = in.charAt(i);
            if (ch == '\\') {
                char next = in.charAt(i + 1);
                if (next != 'x') {
                    b[size++] = (byte)ch;
                    continue;
                }
                char hd1 = in.charAt(i + 2);
                char hd2 = in.charAt(i + 3);
                if (!Bytes.isHexDigit(hd1) || !Bytes.isHexDigit(hd2)) continue;
                byte d = (byte)((Bytes.toBinaryFromHex((byte)hd1) << 4) + Bytes.toBinaryFromHex((byte)hd2));
                b[size++] = d;
                i += 3;
                continue;
            }
            b[size++] = (byte)ch;
        }
        byte[] b2 = new byte[size];
        System.arraycopy(b, 0, b2, 0, size);
        return b2;
    }

    public static byte[] toBytes(String s) {
        if (s == null) {
            throw new IllegalArgumentException("string cannot be null");
        }
        byte[] result = null;
        try {
            result = s.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static byte[] toBytes(boolean b) {
        byte[] bb = new byte[]{b ? (byte)-1 : 0};
        return bb;
    }

    public static boolean toBoolean(byte[] b) {
        if (b == null || b.length > 1) {
            throw new IllegalArgumentException("Array is wrong size");
        }
        return b[0] != 0;
    }

    public static byte[] toBytes(long val) {
        byte[] b = new byte[8];
        for (int i = 7; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static long toLong(byte[] bytes) {
        return Bytes.toLong(bytes, 0);
    }

    public static long toLong(byte[] bytes, int offset) {
        return Bytes.toLong(bytes, offset, 8);
    }

    public static long toLong(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 8 || offset + length > bytes.length) {
            return -1L;
        }
        long l = 0L;
        for (int i = offset; i < offset + length; ++i) {
            l <<= 8;
            l ^= (long)bytes[i] & 0xFFL;
        }
        return l;
    }

    public static int putLong(byte[] bytes, int offset, long val) {
        if (bytes == null || bytes.length - offset < 8) {
            return offset;
        }
        for (int i = offset + 7; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 8;
    }

    public static float toFloat(byte[] bytes) {
        return Bytes.toFloat(bytes, 0);
    }

    public static float toFloat(byte[] bytes, int offset) {
        int i = Bytes.toInt(bytes, offset);
        return Float.intBitsToFloat(i);
    }

    public static int putFloat(byte[] bytes, int offset, float f) {
        int i = Float.floatToRawIntBits(f);
        return Bytes.putInt(bytes, offset, i);
    }

    public static byte[] toBytes(float f) {
        int i = Float.floatToRawIntBits(f);
        return Bytes.toBytes(i);
    }

    public static double toDouble(byte[] bytes) {
        return Bytes.toDouble(bytes, 0);
    }

    public static double toDouble(byte[] bytes, int offset) {
        long l = Bytes.toLong(bytes, offset);
        return Double.longBitsToDouble(l);
    }

    public static int putDouble(byte[] bytes, int offset, double d) {
        long l = Double.doubleToLongBits(d);
        return Bytes.putLong(bytes, offset, l);
    }

    public static byte[] toBytes(double d) {
        long l = Double.doubleToRawLongBits(d);
        return Bytes.toBytes(l);
    }

    public static byte[] toBytes(int val) {
        byte[] b = new byte[4];
        for (int i = 3; i > 0; --i) {
            b[i] = (byte)val;
            val >>>= 8;
        }
        b[0] = (byte)val;
        return b;
    }

    public static int toInt(byte[] bytes) {
        return Bytes.toInt(bytes, 0);
    }

    public static int toInt(byte[] bytes, int offset) {
        return Bytes.toInt(bytes, offset, 4);
    }

    public static int toInt(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 4 || offset + length > bytes.length) {
            return -1;
        }
        int n = 0;
        for (int i = offset; i < offset + length; ++i) {
            n <<= 8;
            n ^= bytes[i] & 0xFF;
        }
        return n;
    }

    public static int putInt(byte[] bytes, int offset, int val) {
        if (bytes == null || bytes.length - offset < 4) {
            return offset;
        }
        for (int i = offset + 3; i > offset; --i) {
            bytes[i] = (byte)val;
            val >>>= 8;
        }
        bytes[offset] = (byte)val;
        return offset + 4;
    }

    public static byte[] toBytes(short val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (short)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static short toShort(byte[] bytes) {
        return Bytes.toShort(bytes, 0);
    }

    public static short toShort(byte[] bytes, int offset) {
        return Bytes.toShort(bytes, offset, 2);
    }

    public static short toShort(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 2 || offset + length > bytes.length) {
            return -1;
        }
        short n = 0;
        n = (short)(n ^ bytes[offset] & 0xFF);
        n = (short)(n << 8);
        n = (short)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static int putShort(byte[] bytes, int offset, short val) {
        if (bytes == null || bytes.length - offset < 2) {
            return offset;
        }
        bytes[offset + 1] = (byte)val;
        val = (short)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static byte[] toBytes(char val) {
        byte[] b = new byte[2];
        b[1] = (byte)val;
        val = (char)(val >> 8);
        b[0] = (byte)val;
        return b;
    }

    public static char toChar(byte[] bytes) {
        return Bytes.toChar(bytes, 0);
    }

    public static char toChar(byte[] bytes, int offset) {
        return Bytes.toChar(bytes, offset, 2);
    }

    public static char toChar(byte[] bytes, int offset, int length) {
        if (bytes == null || length != 2 || offset + length > bytes.length) {
            return '\uffff';
        }
        char n = '\u0000';
        n = (char)(n ^ bytes[offset] & 0xFF);
        n = (char)(n << 8);
        n = (char)(n ^ bytes[offset + 1] & 0xFF);
        return n;
    }

    public static int putChar(byte[] bytes, int offset, char val) {
        if (bytes == null || bytes.length - offset < 2) {
            return offset;
        }
        bytes[offset + 1] = (byte)val;
        val = (char)(val >> 8);
        bytes[offset] = (byte)val;
        return offset + 2;
    }

    public static byte[] toBytes(char[] val) {
        byte[] bytes = new byte[val.length * 2];
        Bytes.putChars(bytes, 0, val);
        return bytes;
    }

    public static char[] toChars(byte[] bytes) {
        return Bytes.toChars(bytes, 0, bytes.length);
    }

    public static char[] toChars(byte[] bytes, int offset) {
        return Bytes.toChars(bytes, offset, bytes.length - offset);
    }

    public static char[] toChars(byte[] bytes, int offset, int length) {
        int max = offset + length;
        if (bytes == null || max > bytes.length || length % 2 == 1) {
            return null;
        }
        char[] chars = new char[length / 2];
        int i = 0;
        for (int j = offset; i < chars.length && j < max; ++i, j += 2) {
            int c = 0;
            c = (char)(c ^ bytes[j] & 0xFF);
            c = (char)(c << 8);
            chars[i] = c = (int)((char)(c ^ bytes[j + 1] & 0xFF));
        }
        return chars;
    }

    public static int putChars(byte[] bytes, int offset, char[] val) {
        int max = val.length * 2 + offset;
        if (bytes == null || bytes.length < max) {
            return offset;
        }
        int i = 0;
        for (int j = offset; i < val.length && j < max; ++i, j += 2) {
            char c = val[i];
            bytes[j + 1] = (byte)c;
            bytes[j] = (byte)(c >>> 8);
        }
        return offset + 2;
    }

    public static byte[] toBytes(BigDecimal val) {
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        int offset = Bytes.putInt(result, 0, val.scale());
        Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
        return result;
    }

    public static BigDecimal toBigDecimal(byte[] bytes) {
        return Bytes.toBigDecimal(bytes, 0, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset) {
        return Bytes.toBigDecimal(bytes, offset, bytes.length);
    }

    public static BigDecimal toBigDecimal(byte[] bytes, int offset, int length) {
        if (bytes == null || length < 5 || offset + length > bytes.length) {
            return null;
        }
        int scale = Bytes.toInt(bytes, 0);
        byte[] tcBytes = new byte[length - 4];
        System.arraycopy(bytes, 4, tcBytes, 0, length - 4);
        return new BigDecimal(new BigInteger(tcBytes), scale);
    }

    public static int putBigDecimal(byte[] bytes, int offset, BigDecimal val) {
        if (bytes == null) {
            return offset;
        }
        byte[] valueBytes = val.unscaledValue().toByteArray();
        byte[] result = new byte[valueBytes.length + 4];
        offset = Bytes.putInt(result, offset, val.scale());
        return Bytes.putBytes(result, offset, valueBytes, 0, valueBytes.length);
    }

    public static byte[] vintToBytes(long vint) {
        long i = vint;
        int size = WritableUtils.getVIntSize((long)i);
        byte[] result = new byte[size];
        int offset = 0;
        if (i >= -112L && i <= 127L) {
            result[offset] = (byte)i;
            return result;
        }
        int len = -112;
        if (i < 0L) {
            i ^= 0xFFFFFFFFFFFFFFFFL;
            len = -120;
        }
        long tmp = i;
        while (tmp != 0L) {
            tmp >>= 8;
            --len;
        }
        result[offset++] = (byte)len;
        for (int idx = len = len < -120 ? -(len + 120) : -(len + 112); idx != 0; --idx) {
            int shiftbits = (idx - 1) * 8;
            long mask = 255L << shiftbits;
            result[offset++] = (byte)((i & mask) >> shiftbits);
        }
        return result;
    }

    public static long bytesToVint(byte[] buffer) {
        byte firstByte;
        int len;
        int offset = 0;
        if ((len = WritableUtils.decodeVIntSize((byte)(firstByte = buffer[offset++]))) == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset++];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static long readVLong(byte[] buffer, int offset) throws IOException {
        byte firstByte = buffer[offset];
        int len = WritableUtils.decodeVIntSize((byte)firstByte);
        if (len == 1) {
            return firstByte;
        }
        long i = 0L;
        for (int idx = 0; idx < len - 1; ++idx) {
            byte b = buffer[offset + 1 + idx];
            i <<= 8;
            i |= (long)(b & 0xFF);
        }
        return WritableUtils.isNegativeVInt((byte)firstByte) ? i ^ 0xFFFFFFFFFFFFFFFFL : i;
    }

    public static int compareTo(byte[] left, byte[] right) {
        return Bytes.compareTo(left, 0, left.length, right, 0, right.length);
    }

    public static int compareTo(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
        int end1 = s1 + l1;
        int end2 = s2 + l2;
        int i = s1;
        for (int j = s2; i < end1 && j < end2; ++i, ++j) {
            int a = b1[i] & 0xFF;
            int b = b2[j] & 0xFF;
            if (a == b) continue;
            return a - b;
        }
        return l1 - l2;
    }

    public static boolean equals(byte[] left, byte[] right) {
        return left == null && right == null ? true : (left == null || right == null || left.length != right.length ? false : Bytes.compareTo(left, right) == 0);
    }

    public static int hashCode(byte[] b) {
        return Bytes.hashCode(b, b.length);
    }

    public static int hashCode(byte[] b, int length) {
        return WritableComparator.hashBytes((byte[])b, (int)length);
    }

    public static Integer mapKey(byte[] b) {
        return Bytes.hashCode(b);
    }

    public static Integer mapKey(byte[] b, int length) {
        return Bytes.hashCode(b, length);
    }

    public static byte[] add(byte[] a, byte[] b) {
        return Bytes.add(a, b, HConstants.EMPTY_BYTE_ARRAY);
    }

    public static byte[] add(byte[] a, byte[] b, byte[] c) {
        byte[] result = new byte[a.length + b.length + c.length];
        System.arraycopy(a, 0, result, 0, a.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        System.arraycopy(c, 0, result, a.length + b.length, c.length);
        return result;
    }

    public static byte[] head(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, 0, result, 0, length);
        return result;
    }

    public static byte[] tail(byte[] a, int length) {
        if (a.length < length) {
            return null;
        }
        byte[] result = new byte[length];
        System.arraycopy(a, a.length - length, result, 0, length);
        return result;
    }

    public static byte[] padHead(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(padding, a);
    }

    public static byte[] padTail(byte[] a, int length) {
        byte[] padding = new byte[length];
        for (int i = 0; i < length; ++i) {
            padding[i] = 0;
        }
        return Bytes.add(a, padding);
    }

    public static byte[][] split(byte[] a, byte[] b, int num) {
        BigInteger splitsBI;
        byte[] aPadded = null;
        byte[] bPadded = null;
        if (a.length < b.length) {
            aPadded = Bytes.padTail(a, b.length - a.length);
            bPadded = b;
        } else if (b.length < a.length) {
            aPadded = a;
            bPadded = Bytes.padTail(b, a.length - b.length);
        } else {
            aPadded = a;
            bPadded = b;
        }
        if (Bytes.compareTo(aPadded, bPadded) > 1) {
            throw new IllegalArgumentException("b > a");
        }
        if (num <= 0) {
            throw new IllegalArgumentException("num cannot be < 0");
        }
        byte[] prependHeader = new byte[]{1, 0};
        BigInteger startBI = new BigInteger(Bytes.add(prependHeader, aPadded));
        BigInteger stopBI = new BigInteger(Bytes.add(prependHeader, bPadded));
        BigInteger diffBI = stopBI.subtract(startBI);
        if (diffBI.compareTo(splitsBI = BigInteger.valueOf(num + 1)) <= 0) {
            return null;
        }
        BigInteger intervalBI = null;
        try {
            intervalBI = diffBI.divide(splitsBI);
        }
        catch (Exception e) {
            return null;
        }
        byte[][] result = new byte[num + 2][];
        result[0] = a;
        for (int i = 1; i <= num; ++i) {
            BigInteger curBI = startBI.add(intervalBI.multiply(BigInteger.valueOf(i)));
            byte[] padded = curBI.toByteArray();
            padded = padded[1] == 0 ? Bytes.tail(padded, padded.length - 2) : Bytes.tail(padded, padded.length - 1);
            result[i] = padded;
        }
        result[num + 1] = b;
        return result;
    }

    public static byte[][] toByteArrays(String[] t) {
        byte[][] result = new byte[t.length][];
        for (int i = 0; i < t.length; ++i) {
            result[i] = Bytes.toBytes(t[i]);
        }
        return result;
    }

    public static byte[][] toByteArrays(String column) {
        return Bytes.toByteArrays(Bytes.toBytes(column));
    }

    public static byte[][] toByteArrays(byte[] column) {
        byte[][] result = new byte[][]{column};
        return result;
    }

    public static int binarySearch(byte[][] arr, byte[] key, int offset, int length, RawComparator<byte[]> comparator) {
        int low = 0;
        int high = arr.length - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int cmp = comparator.compare(key, offset, length, arr[mid], 0, arr[mid].length);
            if (cmp > 0) {
                low = mid + 1;
                continue;
            }
            if (cmp < 0) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public static byte[] incrementBytes(byte[] value, long amount) throws IOException {
        byte[] val = value;
        if (val.length < 8) {
            byte[] newvalue;
            if (val[0] < 0) {
                byte[] negativeValue = new byte[]{-1, -1, -1, -1, -1, -1, -1, -1};
                newvalue = negativeValue;
            } else {
                newvalue = new byte[8];
            }
            System.arraycopy(val, 0, newvalue, newvalue.length - val.length, val.length);
            val = newvalue;
        } else if (val.length > 8) {
            throw new IllegalArgumentException("Increment Bytes - value too big: " + val.length);
        }
        if (amount == 0L) {
            return val;
        }
        if (val[0] < 0) {
            return Bytes.binaryIncrementNeg(val, amount);
        }
        return Bytes.binaryIncrementPos(val, amount);
    }

    private static byte[] binaryIncrementPos(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = value[value.length - i - 1] & 0xFF;
            int total = val + cur;
            if (total > 255) {
                amo += (long)sign;
                total %= 256;
            } else if (total < 0) {
                amo -= (long)sign;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    private static byte[] binaryIncrementNeg(byte[] value, long amount) {
        long amo = amount;
        int sign = 1;
        if (amount < 0L) {
            amo = -amount;
            sign = -1;
        }
        for (int i = 0; i < value.length; ++i) {
            int cur = (int)amo % 256 * sign;
            amo >>= 8;
            int val = (~value[value.length - i - 1] & 0xFF) + 1;
            int total = cur - val;
            if (total >= 0) {
                amo += (long)sign;
            } else if (total < -256) {
                amo -= (long)sign;
                total %= 256;
            }
            value[value.length - i - 1] = (byte)total;
            if (amo != 0L) continue;
            return value;
        }
        return value;
    }

    public static class ByteArrayComparator
    implements RawComparator<byte[]> {
        public int compare(byte[] left, byte[] right) {
            return Bytes.compareTo(left, right);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            return Bytes.compareTo(b1, s1, l1, b2, s2, l2);
        }
    }
}

