/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.cli;

import java.util.Properties;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.cli.CliSessionState;

public class OptionsProcessor {
    protected static final Log l4j = LogFactory.getLog((String)OptionsProcessor.class.getName());
    private final Options options = new Options();
    private CommandLine commandLine;

    public OptionsProcessor() {
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"quoted-query-string");
        OptionBuilder.withDescription((String)"SQL from command line");
        this.options.addOption(OptionBuilder.create((char)'e'));
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"filename");
        OptionBuilder.withDescription((String)"SQL from files");
        this.options.addOption(OptionBuilder.create((char)'f'));
        OptionBuilder.withValueSeparator();
        OptionBuilder.hasArgs((int)2);
        OptionBuilder.withArgName((String)"property=value");
        OptionBuilder.withLongOpt((String)"hiveconf");
        OptionBuilder.withDescription((String)"Use value for given property");
        this.options.addOption(OptionBuilder.create());
        this.options.addOption(new Option("S", "silent", false, "Run CLI in silent mode"));
        this.options.addOption(new Option("h", "help", false, "Print help information"));
    }

    public boolean process_stage1(String[] argv) {
        try {
            this.commandLine = new GnuParser().parse(this.options, argv);
            Properties confProps = this.commandLine.getOptionProperties("hiveconf");
            for (String propKey : confProps.stringPropertyNames()) {
                System.setProperty(propKey, confProps.getProperty(propKey));
            }
        }
        catch (ParseException e) {
            System.err.println(e.getMessage());
            this.printUsage();
            return false;
        }
        return true;
    }

    public boolean process_stage2(CliSessionState ss) {
        ss.getConf();
        if (this.commandLine.hasOption('h')) {
            this.printUsage();
            return false;
        }
        ss.setIsSilent(this.commandLine.hasOption('S'));
        ss.execString = this.commandLine.getOptionValue('e');
        ss.fileName = this.commandLine.getOptionValue('f');
        if (ss.execString != null && ss.fileName != null) {
            System.err.println("The '-e' and '-f' options cannot be specified simultaneously");
            this.printUsage();
            return false;
        }
        if (this.commandLine.hasOption("hiveconf")) {
            Properties confProps = this.commandLine.getOptionProperties("hiveconf");
            for (String propKey : confProps.stringPropertyNames()) {
                ss.cmdProperties.setProperty(propKey, confProps.getProperty(propKey));
            }
        }
        return true;
    }

    private void printUsage() {
        new HelpFormatter().printHelp("hive", this.options);
    }
}

