/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import com.facebook.fb303.FacebookBase;
import com.facebook.fb303.fb_status;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.jdo.JDODataStoreException;
import javax.jdo.JDOFatalDataStoreException;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.common.JavaUtils;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.AlterHandler;
import org.apache.hadoop.hive.metastore.HiveAlterHandler;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.RawStore;
import org.apache.hadoop.hive.metastore.TServerSocketKeepAlive;
import org.apache.hadoop.hive.metastore.TableType;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.Index;
import org.apache.hadoop.hive.metastore.api.IndexAlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.hadoop.hive.metastore.hooks.JDOConnectionURLHook;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.util.ReflectionUtils;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.server.TThreadPoolServer;
import org.apache.thrift.transport.TServerSocket;
import org.apache.thrift.transport.TServerTransport;
import org.apache.thrift.transport.TTransportFactory;

public class HiveMetaStore
extends ThriftHiveMetastore {
    public static void main(String[] args) {
        int port = 9083;
        if (args.length > 0) {
            port = new Integer(args[0]);
        }
        try {
            HMSHandler handler = new HMSHandler("new db based metaserver");
            HiveConf conf = handler.getHiveConf();
            int minWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMINTHREADS);
            int maxWorkerThreads = conf.getIntVar(HiveConf.ConfVars.METASTORESERVERMAXTHREADS);
            boolean tcpKeepAlive = conf.getBoolVar(HiveConf.ConfVars.METASTORE_TCP_KEEP_ALIVE);
            TServerSocketKeepAlive serverTransport = tcpKeepAlive ? new TServerSocketKeepAlive(port) : new TServerSocket(port);
            ThriftHiveMetastore.Processor processor = new ThriftHiveMetastore.Processor(handler);
            TThreadPoolServer.Options options = new TThreadPoolServer.Options();
            options.minWorkerThreads = minWorkerThreads;
            options.maxWorkerThreads = maxWorkerThreads;
            TThreadPoolServer server = new TThreadPoolServer((TProcessor)processor, (TServerTransport)serverTransport, new TTransportFactory(), new TTransportFactory(), (TProtocolFactory)new TBinaryProtocol.Factory(), (TProtocolFactory)new TBinaryProtocol.Factory(), options);
            HMSHandler.LOG.info((Object)("Started the new metaserver on port [" + port + "]..."));
            HMSHandler.LOG.info((Object)("Options.minWorkerThreads = " + options.minWorkerThreads));
            HMSHandler.LOG.info((Object)("Options.maxWorkerThreads = " + options.maxWorkerThreads));
            HMSHandler.LOG.info((Object)("TCP keepalive = " + tcpKeepAlive));
            server.serve();
        }
        catch (Throwable x) {
            x.printStackTrace();
            HMSHandler.LOG.error((Object)"Metastore Thrift Server threw an exception. Exiting...");
            HMSHandler.LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)x));
            System.exit(1);
        }
    }

    public static class HMSHandler
    extends FacebookBase
    implements ThriftHiveMetastore.Iface {
        public static final Log LOG = LogFactory.getLog((String)HiveMetaStore.class.getName());
        private static boolean createDefaultDB = false;
        private String rawStoreClassName;
        private final HiveConf hiveConf;
        private Warehouse wh;
        private final ThreadLocal<RawStore> threadLocalMS = new ThreadLocal<RawStore>(){

            @Override
            protected synchronized RawStore initialValue() {
                return null;
            }
        };
        private final ThreadLocal<Configuration> threadLocalConf = new ThreadLocal<Configuration>(){

            @Override
            protected synchronized Configuration initialValue() {
                return null;
            }
        };
        private boolean checkForDefaultDb;
        private static int nextSerialNum = 0;
        private static ThreadLocal<Integer> threadLocalId = new ThreadLocal(){

            protected synchronized Object initialValue() {
                return new Integer(nextSerialNum++);
            }
        };
        private int retryInterval = 0;
        private int retryLimit = 0;
        private JDOConnectionURLHook urlHook = null;
        private String urlHookClassName = "";
        private ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        private AlterHandler alterHandler;

        public static Integer get() {
            return threadLocalId.get();
        }

        public HMSHandler(String name) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = new HiveConf(this.getClass());
            this.init();
        }

        public HMSHandler(String name, HiveConf conf) throws MetaException {
            super(name);
            if (this.classLoader == null) {
                this.classLoader = Configuration.class.getClassLoader();
            }
            this.hiveConf = conf;
            this.init();
        }

        public HiveConf getHiveConf() {
            return this.hiveConf;
        }

        private boolean init() throws MetaException {
            this.rawStoreClassName = this.hiveConf.get("hive.metastore.rawstore.impl");
            this.checkForDefaultDb = this.hiveConf.getBoolean("hive.metastore.checkForDefaultDb", true);
            String alterHandlerName = this.hiveConf.get("hive.metastore.alter.impl", HiveAlterHandler.class.getName());
            this.alterHandler = (AlterHandler)ReflectionUtils.newInstance(this.getClass(alterHandlerName, AlterHandler.class), (Configuration)this.hiveConf);
            this.wh = new Warehouse((Configuration)this.hiveConf);
            this.retryInterval = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREINTERVAL);
            this.retryLimit = HiveConf.getIntVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREATTEMPTS);
            this.updateConnectionURL((Configuration)this.hiveConf, null);
            this.createDefaultDB();
            return true;
        }

        private String addPrefix(String s) {
            return threadLocalId.get() + ": " + s;
        }

        private <T> T executeWithRetry(Command<T> cmd) throws Exception {
            T ret = null;
            boolean gotNewConnectUrl = false;
            boolean reloadConf = HiveConf.getBoolVar((Configuration)this.hiveConf, (HiveConf.ConfVars)HiveConf.ConfVars.METASTOREFORCERELOADCONF);
            if (reloadConf) {
                this.updateConnectionURL(this.getConf(), null);
            }
            int retryCount = 0;
            Throwable caughtException = null;
            while (true) {
                try {
                    RawStore ms = this.getMS(reloadConf || gotNewConnectUrl);
                    ret = cmd.run(ms);
                    break;
                }
                catch (JDOFatalDataStoreException e) {
                    caughtException = e;
                }
                catch (JDODataStoreException e) {
                    caughtException = e;
                }
                if (retryCount >= this.retryLimit) {
                    throw caughtException;
                }
                assert (this.retryInterval >= 0);
                LOG.error((Object)String.format("JDO datastore error. Retrying metastore command after %d ms (attempt %d of %d)", this.retryInterval, ++retryCount, this.retryLimit));
                Thread.sleep(this.retryInterval);
                String lastUrl = HMSHandler.getConnectionURL(this.getConf());
                gotNewConnectUrl = this.updateConnectionURL(this.getConf(), lastUrl);
            }
            return ret;
        }

        private Configuration getConf() {
            Configuration conf = this.threadLocalConf.get();
            if (conf == null) {
                conf = new Configuration((Configuration)this.hiveConf);
                this.threadLocalConf.set(conf);
            }
            return conf;
        }

        private RawStore getMS(boolean reloadConf) throws MetaException {
            RawStore ms = this.threadLocalMS.get();
            if (ms == null) {
                LOG.info((Object)this.addPrefix("Opening raw store with implemenation class:" + this.rawStoreClassName));
                ms = (RawStore)ReflectionUtils.newInstance(this.getClass(this.rawStoreClassName, RawStore.class), (Configuration)this.getConf());
                this.threadLocalMS.set(ms);
                ms = this.threadLocalMS.get();
            }
            if (reloadConf) {
                ms.setConf(this.getConf());
            }
            return ms;
        }

        private boolean updateConnectionURL(Configuration conf, String badUrl) throws MetaException {
            String connectUrl = null;
            String currentUrl = HMSHandler.getConnectionURL(conf);
            try {
                this.initConnectionUrlHook();
                if (this.urlHook != null) {
                    if (badUrl != null) {
                        this.urlHook.notifyBadConnectionUrl(badUrl);
                    }
                    connectUrl = this.urlHook.getJdoConnectionUrl((Configuration)this.hiveConf);
                }
            }
            catch (Exception e) {
                LOG.error((Object)("Exception while getting connection URL from the hook: " + e));
            }
            if (connectUrl != null && !connectUrl.equals(currentUrl)) {
                LOG.error((Object)this.addPrefix(String.format("Overriding %s with %s", HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl)));
                conf.set(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), connectUrl);
                return true;
            }
            return false;
        }

        private static String getConnectionURL(Configuration conf) {
            return conf.get(HiveConf.ConfVars.METASTORECONNECTURLKEY.toString(), "");
        }

        private synchronized void initConnectionUrlHook() throws ClassNotFoundException {
            boolean urlHookChanged;
            String className = this.hiveConf.get(HiveConf.ConfVars.METASTORECONNECTURLHOOK.toString(), "").trim();
            if (className.equals("")) {
                this.urlHookClassName = "";
                this.urlHook = null;
                return;
            }
            boolean bl = urlHookChanged = !this.urlHookClassName.equals(className);
            if (this.urlHook == null || urlHookChanged) {
                this.urlHookClassName = className.trim();
                Class<?> urlHookClass = Class.forName(this.urlHookClassName, true, JavaUtils.getClassLoader());
                this.urlHook = (JDOConnectionURLHook)ReflectionUtils.newInstance(urlHookClass, null);
            }
        }

        private void createDefaultDB_core(RawStore ms) throws MetaException, InvalidObjectException {
            try {
                ms.getDatabase("default");
            }
            catch (NoSuchObjectException e) {
                ms.createDatabase(new Database("default", "Default Hive database", this.wh.getDefaultDatabasePath("default").toString()));
            }
            createDefaultDB = true;
        }

        private void createDefaultDB() throws MetaException {
            if (createDefaultDB || !this.checkForDefaultDb) {
                return;
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.createDefaultDB_core(ms);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw new MetaException(e.getMessage());
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        private Class<?> getClass(String rawStoreClassName, Class<?> class1) throws MetaException {
            try {
                return Class.forName(rawStoreClassName, true, this.classLoader);
            }
            catch (ClassNotFoundException e) {
                throw new MetaException(rawStoreClassName + " class not found");
            }
        }

        private void logStartFunction(String m) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + m));
        }

        private void logStartTableFunction(String f, String db, String tbl) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + f + " : db=" + db + " tbl=" + tbl));
        }

        private void logStartPartitionFunction(String f, String db, String tbl, List<String> partVals) {
            LOG.info((Object)(threadLocalId.get().toString() + ": " + f + " : db=" + db + " tbl=" + tbl + "[" + StringUtils.join(partVals, (String)",") + "]"));
        }

        public fb_status getStatus() {
            return fb_status.ALIVE;
        }

        public void shutdown() {
            this.logStartFunction("Shutting down the object store...");
            RawStore ms = this.threadLocalMS.get();
            if (ms != null) {
                ms.shutdown();
            }
            System.exit(0);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_database_core(RawStore ms, Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            if (!MetaStoreUtils.validateName(db.getName())) {
                throw new InvalidObjectException(db.getName() + " is not a valid database name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (null == db.getLocationUri()) {
                    db.setLocationUri(this.wh.getDefaultDatabasePath(db.getName()).toString());
                }
                ms.createDatabase(db);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else {
                    this.wh.mkdirs(new Path(db.getLocationUri()));
                }
            }
        }

        @Override
        public void create_database(final Database db) throws AlreadyExistsException, InvalidObjectException, MetaException {
            this.incrementCounter("create_database");
            this.logStartFunction("create_database: " + db.getName() + " " + db.getLocationUri() + " " + db.getDescription());
            try {
                try {
                    if (null != this.get_database(db.getName())) {
                        throw new AlreadyExistsException("Database " + db.getName() + " already exists");
                    }
                }
                catch (NoSuchObjectException e) {
                    // empty catch block
                }
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_database_core(ms, db);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        @Override
        public Database get_database(final String name) throws NoSuchObjectException, MetaException {
            this.incrementCounter("get_database");
            this.logStartFunction("get_database: " + name);
            Database db = null;
            try {
                db = this.executeWithRetry(new Command<Database>(){

                    @Override
                    Database run(RawStore ms) throws Exception {
                        return ms.getDatabase(name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return db;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_database_core(RawStore ms, String name, boolean deleteData) throws NoSuchObjectException, InvalidOperationException, MetaException {
            boolean success = false;
            Database db = null;
            try {
                ms.openTransaction();
                db = ms.getDatabase(name);
                if (!this.get_all_tables(db.getName()).isEmpty()) {
                    throw new InvalidOperationException("Database " + db.getName() + " is not empty");
                }
                if (ms.dropDatabase(name)) {
                    success = ms.commitTransaction();
                }
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                } else if (deleteData) {
                    this.wh.deleteDir(new Path(db.getLocationUri()), true);
                }
            }
        }

        @Override
        public void drop_database(final String dbName, final boolean deleteData) throws NoSuchObjectException, InvalidOperationException, MetaException {
            this.incrementCounter("drop_database");
            this.logStartFunction("drop_database: " + dbName);
            if ("default".equalsIgnoreCase(dbName)) {
                throw new MetaException("Can not drop default database");
            }
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_database_core(ms, dbName, deleteData);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        @Override
        public List<String> get_databases(final String pattern) throws MetaException {
            this.incrementCounter("get_databases");
            this.logStartFunction("get_databases: " + pattern);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getDatabases(pattern);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<String> get_all_databases() throws MetaException {
            this.incrementCounter("get_all_databases");
            this.logStartFunction("get_all_databases");
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getAllDatabases();
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create_type_core(RawStore ms, Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(type.getName())) {
                throw new InvalidObjectException("Invalid type name");
            }
            boolean success = false;
            try {
                ms.openTransaction();
                if (this.is_type_exists(type.getName())) {
                    throw new AlreadyExistsException("Type " + type.getName() + " already exists");
                }
                ms.createType(type);
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean create_type(final Type type) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.incrementCounter("create_type");
            this.logStartFunction("create_type: " + type.getName());
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_type_core(ms, type);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public Type get_type(final String name) throws MetaException, NoSuchObjectException {
            Type ret;
            this.incrementCounter("get_type");
            this.logStartFunction("get_type: " + name);
            try {
                ret = this.executeWithRetry(new Command<Type>(){

                    @Override
                    Type run(RawStore ms) throws Exception {
                        Type type = ms.getType(name);
                        if (null == type) {
                            throw new NoSuchObjectException("Type \"" + name + "\" not found.");
                        }
                        return type;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        public boolean is_type_exists(String typeName) throws MetaException {
            this.incrementCounter("is_type_exists");
            this.logStartFunction("is_type_exists: " + typeName);
            try {
                return this.get_type(typeName) != null;
            }
            catch (NoSuchObjectException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void drop_type_core(RawStore ms, String typeName) throws NoSuchObjectException, MetaException {
            boolean success = false;
            try {
                ms.openTransaction();
                if (!this.is_type_exists(typeName)) {
                    throw new NoSuchObjectException(typeName + " doesn't exist");
                }
                if (!ms.dropType(typeName)) {
                    throw new MetaException("Unable to drop type " + typeName);
                }
                success = ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
        }

        @Override
        public boolean drop_type(final String name) throws MetaException {
            this.incrementCounter("drop_type");
            this.logStartFunction("drop_type: " + name);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return ms.dropType(name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public Map<String, Type> get_type_all(String name) throws MetaException {
            this.incrementCounter("get_type_all");
            this.logStartFunction("get_type_all: " + name);
            throw new MetaException("Not yet implemented");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void create_table_core(RawStore ms, Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            if (!MetaStoreUtils.validateName(tbl.getTableName()) || !MetaStoreUtils.validateColNames(tbl.getSd().getCols()) || tbl.getPartitionKeys() != null && !MetaStoreUtils.validateColNames(tbl.getPartitionKeys())) {
                throw new InvalidObjectException(tbl.getTableName() + " is not a valid object name");
            }
            Path tblPath = null;
            boolean success = false;
            boolean madeDir = false;
            try {
                ms.openTransaction();
                if (!TableType.VIRTUAL_VIEW.toString().equals(tbl.getTableType())) {
                    if (tbl.getSd().getLocation() == null || tbl.getSd().getLocation().isEmpty()) {
                        tblPath = this.wh.getDefaultTablePath(tbl.getDbName(), tbl.getTableName());
                    } else {
                        if (!this.isExternal(tbl) && !MetaStoreUtils.isNonNativeTable(tbl)) {
                            LOG.warn((Object)("Location: " + tbl.getSd().getLocation() + " specified for non-external table:" + tbl.getTableName()));
                        }
                        tblPath = this.wh.getDnsPath(new Path(tbl.getSd().getLocation()));
                    }
                    tbl.getSd().setLocation(tblPath.toString());
                }
                if (this.is_table_exists(tbl.getDbName(), tbl.getTableName())) {
                    throw new AlreadyExistsException("Table " + tbl.getTableName() + " already exists");
                }
                if (tblPath != null && !this.wh.isDir(tblPath)) {
                    if (!this.wh.mkdirs(tblPath)) {
                        throw new MetaException(tblPath + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                tbl.setCreateTime((int)time);
                tbl.putToParameters("transient_lastDdlTime", Long.toString(time));
                ms.createTable(tbl);
                success = ms.commitTransaction();
                if (success) return;
                ms.rollbackTransaction();
                if (!madeDir) return;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(tblPath, true);
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        @Override
        public void create_table(final Table tbl) throws AlreadyExistsException, MetaException, InvalidObjectException {
            this.incrementCounter("create_table");
            this.logStartFunction("create_table: db=" + tbl.getDbName() + " tbl=" + tbl.getTableName());
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.create_table_core(ms, tbl);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        public boolean is_table_exists(String dbname, String name) throws MetaException {
            try {
                this.incrementCounter("is_table_exists");
                this.logStartTableFunction("is_table_exists", dbname, name);
                return this.get_table(dbname, name) != null;
            }
            catch (NoSuchObjectException e) {
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void drop_table_core(RawStore ms, String dbname, String name, boolean deleteData) throws NoSuchObjectException, MetaException {
            boolean success = false;
            boolean isExternal = false;
            Path tblPath = null;
            Table tbl = null;
            isExternal = false;
            try {
                ms.openTransaction();
                tbl = this.get_table(dbname, name);
                if (tbl == null) {
                    throw new NoSuchObjectException(name + " doesn't exist");
                }
                if (tbl.getSd() == null) {
                    throw new MetaException("Table metadata is corrupted");
                }
                isExternal = this.isExternal(tbl);
                if (tbl.getSd().getLocation() != null) {
                    tblPath = new Path(tbl.getSd().getLocation());
                }
                if (!ms.dropTable(dbname, name)) {
                    throw new MetaException("Unable to drop table");
                }
                tbl = null;
                success = ms.commitTransaction();
                if (!success) {
                    ms.rollbackTransaction();
                    return;
                }
                if (!deleteData || tblPath == null || isExternal) return;
            }
            catch (Throwable throwable) {
                if (!success) {
                    ms.rollbackTransaction();
                    throw throwable;
                } else {
                    if (!deleteData || tblPath == null || isExternal) throw throwable;
                    this.wh.deleteDir(tblPath, true);
                }
                throw throwable;
            }
            this.wh.deleteDir(tblPath, true);
        }

        @Override
        public void drop_table(final String dbname, final String name, final boolean deleteData) throws NoSuchObjectException, MetaException {
            this.incrementCounter("drop_table");
            this.logStartTableFunction("drop_table", dbname, name);
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.drop_table_core(ms, dbname, name, deleteData);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        private boolean isExternal(Table table) {
            return MetaStoreUtils.isExternalTable(table);
        }

        @Override
        public Table get_table(final String dbname, final String name) throws MetaException, NoSuchObjectException {
            Table t = null;
            this.incrementCounter("get_table");
            this.logStartTableFunction("get_table", dbname, name);
            try {
                t = this.executeWithRetry(new Command<Table>(){

                    @Override
                    Table run(RawStore ms) throws Exception {
                        Table t = ms.getTable(dbname, name);
                        if (t == null) {
                            throw new NoSuchObjectException(dbname + "." + name + " table not found");
                        }
                        return t;
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return t;
        }

        public boolean set_table_parameters(String dbname, String name, Map<String, String> params) throws NoSuchObjectException, MetaException {
            this.incrementCounter("set_table_parameters");
            this.logStartTableFunction("set_table_parameters", dbname, name);
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition append_partition_common(RawStore ms, String dbName, String tableName, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            Partition part = new Partition();
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                ms.openTransaction();
                part = new Partition();
                part.setDbName(dbName);
                part.setTableName(tableName);
                part.setValues(part_vals);
                Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                part.setSd(tbl.getSd());
                partLocation = new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part_vals));
                part.getSd().setLocation(partLocation.toString());
                Partition old_part = null;
                try {
                    old_part = this.get_partition(part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                success = ms.addPartition(part);
                if (success) {
                    success = ms.commitTransaction();
                }
                if (success) return part;
                ms.rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        @Override
        public Partition append_partition(final String dbName, final String tableName, final List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.incrementCounter("append_partition");
            this.logStartPartitionFunction("append_partition", dbName, tableName, part_vals);
            if (LOG.isDebugEnabled()) {
                for (String part : part_vals) {
                    LOG.debug((Object)part);
                }
            }
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.append_partition_common(ms, dbName, tableName, part_vals);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private int add_partitions_core(RawStore ms, List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            String db = parts.get(0).getDbName();
            String tbl = parts.get(0).getTableName();
            this.logStartTableFunction("add_partitions", db, tbl);
            boolean success = false;
            try {
                ms.openTransaction();
                for (Partition part : parts) {
                    this.add_partition(part);
                }
                success = true;
                ms.commitTransaction();
            }
            finally {
                if (!success) {
                    ms.rollbackTransaction();
                }
            }
            return parts.size();
        }

        public int add_partitions(final List<Partition> parts) throws MetaException, InvalidObjectException, AlreadyExistsException {
            this.incrementCounter("add_partition");
            if (parts.size() == 0) {
                return 0;
            }
            Integer ret = null;
            try {
                ret = this.executeWithRetry(new Command<Integer>(){

                    @Override
                    Integer run(RawStore ms) throws Exception {
                        int ret = HMSHandler.this.add_partitions_core(ms, parts);
                        return ret;
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Partition add_partition_core(RawStore ms, Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            boolean success = false;
            boolean madeDir = false;
            Path partLocation = null;
            try {
                ms.openTransaction();
                Partition old_part = null;
                try {
                    old_part = this.get_partition(part.getDbName(), part.getTableName(), part.getValues());
                }
                catch (NoSuchObjectException e) {
                    old_part = null;
                }
                if (old_part != null) {
                    throw new AlreadyExistsException("Partition already exists:" + part);
                }
                Table tbl = ms.getTable(part.getDbName(), part.getTableName());
                if (tbl == null) {
                    throw new InvalidObjectException("Unable to add partition because table or database do not exist");
                }
                String partLocationStr = part.getSd().getLocation();
                partLocation = partLocationStr == null || partLocationStr.isEmpty() ? new Path(tbl.getSd().getLocation(), Warehouse.makePartName(tbl.getPartitionKeys(), part.getValues())) : this.wh.getDnsPath(new Path(partLocationStr));
                part.getSd().setLocation(partLocation.toString());
                if (!this.wh.isDir(partLocation)) {
                    if (!this.wh.mkdirs(partLocation)) {
                        throw new MetaException(partLocation + " is not a directory or unable to create one");
                    }
                    madeDir = true;
                }
                long time = System.currentTimeMillis() / 1000L;
                part.setCreateTime((int)time);
                part.putToParameters("transient_lastDdlTime", Long.toString(time));
                boolean bl = success = ms.addPartition(part) && ms.commitTransaction();
                if (success) return part;
                ms.rollbackTransaction();
                if (!madeDir) return part;
            }
            catch (Throwable throwable) {
                if (success) throw throwable;
                ms.rollbackTransaction();
                if (!madeDir) throw throwable;
                this.wh.deleteDir(partLocation, true);
                throw throwable;
            }
            this.wh.deleteDir(partLocation, true);
            return part;
        }

        @Override
        public Partition add_partition(final Partition part) throws InvalidObjectException, AlreadyExistsException, MetaException {
            this.incrementCounter("add_partition");
            this.logStartTableFunction("add_partition", part.getDbName(), part.getTableName());
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.add_partition_core(ms, part);
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean drop_partition_common(RawStore ms, String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws MetaException, NoSuchObjectException {
            block15: {
                Path partPath;
                block16: {
                    Path archiveParentDir;
                    block17: {
                        boolean success = false;
                        partPath = null;
                        Table tbl = null;
                        Partition part = null;
                        boolean isArchived = false;
                        archiveParentDir = null;
                        try {
                            ms.openTransaction();
                            part = this.get_partition(db_name, tbl_name, part_vals);
                            if (part == null) {
                                throw new NoSuchObjectException("Partition doesn't exist. " + part_vals);
                            }
                            isArchived = MetaStoreUtils.isArchived(part);
                            if (isArchived) {
                                archiveParentDir = MetaStoreUtils.getOriginalLocation(part);
                            }
                            if (part.getSd() == null || part.getSd().getLocation() == null) {
                                throw new MetaException("Partition metadata is corrupted");
                            }
                            if (!ms.dropPartition(db_name, tbl_name, part_vals)) {
                                throw new MetaException("Unable to drop partition");
                            }
                            success = ms.commitTransaction();
                            partPath = new Path(part.getSd().getLocation());
                            tbl = this.get_table(db_name, tbl_name);
                            if (!success) {
                                ms.rollbackTransaction();
                                break block15;
                            }
                            if (!deleteData || partPath == null && archiveParentDir == null || tbl == null || this.isExternal(tbl)) break block15;
                            if (!isArchived) break block16;
                            if ($assertionsDisabled || archiveParentDir != null) break block17;
                        }
                        catch (Throwable throwable) {
                            if (!success) {
                                ms.rollbackTransaction();
                            } else if (deleteData && (partPath != null || archiveParentDir != null) && tbl != null && !this.isExternal(tbl)) {
                                if (isArchived) {
                                    assert (archiveParentDir != null);
                                    this.wh.deleteDir(archiveParentDir, true);
                                } else {
                                    assert (partPath != null);
                                    this.wh.deleteDir(partPath, true);
                                }
                            }
                            throw throwable;
                        }
                        throw new AssertionError();
                    }
                    this.wh.deleteDir(archiveParentDir, true);
                    break block15;
                }
                assert (partPath != null);
                this.wh.deleteDir(partPath, true);
            }
            return true;
        }

        @Override
        public boolean drop_partition(final String db_name, final String tbl_name, final List<String> part_vals, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.incrementCounter("drop_partition");
            this.logStartPartitionFunction("drop_partition", db_name, tbl_name, part_vals);
            LOG.info((Object)("Partition values:" + part_vals));
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_common(ms, db_name, tbl_name, part_vals, deleteData);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public Partition get_partition(final String db_name, final String tbl_name, final List<String> part_vals) throws MetaException, NoSuchObjectException {
            this.incrementCounter("get_partition");
            this.logStartPartitionFunction("get_partition", db_name, tbl_name, part_vals);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return ms.getPartition(db_name, tbl_name, part_vals);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions(final String db_name, final String tbl_name, final short max_parts) throws NoSuchObjectException, MetaException {
            this.incrementCounter("get_partitions");
            this.logStartTableFunction("get_partitions", db_name, tbl_name);
            List<Partition> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<Partition>>(){

                    @Override
                    List<Partition> run(RawStore ms) throws Exception {
                        return ms.getPartitions(db_name, tbl_name, max_parts);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<String> get_partition_names(final String db_name, final String tbl_name, final short max_parts) throws MetaException {
            this.incrementCounter("get_partition_names");
            this.logStartTableFunction("get_partition_names", db_name, tbl_name);
            List<String> ret = null;
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.listPartitionNames(db_name, tbl_name, max_parts);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        private void alter_partition_core(RawStore ms, String db_name, String tbl_name, Partition new_part) throws InvalidOperationException, MetaException, TException {
            try {
                new_part.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
                ms.alterPartition(db_name, tbl_name, new_part);
            }
            catch (InvalidObjectException e) {
                throw new InvalidOperationException("alter is not possible");
            }
        }

        @Override
        public void alter_partition(final String db_name, final String tbl_name, final Partition new_part) throws InvalidOperationException, MetaException, TException {
            this.incrementCounter("alter_partition");
            this.logStartTableFunction("alter_partition", db_name, tbl_name);
            LOG.info((Object)("Partition values:" + new_part.getValues()));
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alter_partition_core(ms, db_name, tbl_name, new_part);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        public boolean create_index(Index index_def) throws IndexAlreadyExistsException, MetaException {
            this.incrementCounter("create_index");
            throw new MetaException("Not yet implemented");
        }

        public String getVersion() throws TException {
            this.incrementCounter("getVersion");
            this.logStartFunction("getVersion");
            return "3.0";
        }

        @Override
        public void alter_table(final String dbname, final String name, final Table newTable) throws InvalidOperationException, MetaException {
            this.incrementCounter("alter_table");
            this.logStartFunction("alter_table: db=" + dbname + " tbl=" + name + " newtbl=" + newTable.getTableName());
            newTable.putToParameters("transient_lastDdlTime", Long.toString(System.currentTimeMillis() / 1000L));
            try {
                this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        HMSHandler.this.alterHandler.alterTable(ms, HMSHandler.this.wh, dbname, name, newTable);
                        return Boolean.TRUE;
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (InvalidOperationException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
        }

        @Override
        public List<String> get_tables(final String dbname, final String pattern) throws MetaException {
            List<String> ret;
            this.incrementCounter("get_tables");
            this.logStartFunction("get_tables: db=" + dbname + " pat=" + pattern);
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getTables(dbname, pattern);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<String> get_all_tables(final String dbname) throws MetaException {
            List<String> ret;
            this.incrementCounter("get_all_tables");
            this.logStartFunction("get_all_tables: db=" + dbname);
            try {
                ret = this.executeWithRetry(new Command<List<String>>(){

                    @Override
                    List<String> run(RawStore ms) throws Exception {
                        return ms.getAllTables(dbname);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<FieldSchema> get_fields(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            Table tbl;
            this.incrementCounter("get_fields");
            this.logStartFunction("get_fields: db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            try {
                tbl = this.get_table(db, base_table_name);
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            boolean getColsFromSerDe = SerDeUtils.shouldGetColsFromSerDe((String)tbl.getSd().getSerdeInfo().getSerializationLib());
            if (!getColsFromSerDe) {
                return tbl.getSd().getCols();
            }
            try {
                Deserializer s = MetaStoreUtils.getDeserializer((Configuration)this.hiveConf, tbl);
                return MetaStoreUtils.getFieldsFromDeserializer(tableName, s);
            }
            catch (SerDeException e) {
                org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e);
                throw new MetaException(e.getMessage());
            }
        }

        @Override
        public List<FieldSchema> get_schema(String db, String tableName) throws MetaException, UnknownTableException, UnknownDBException {
            Table tbl;
            this.incrementCounter("get_schema");
            this.logStartFunction("get_schema: db=" + db + "tbl=" + tableName);
            String[] names = tableName.split("\\.");
            String base_table_name = names[0];
            try {
                tbl = this.get_table(db, base_table_name);
            }
            catch (NoSuchObjectException e) {
                throw new UnknownTableException(e.getMessage());
            }
            List<FieldSchema> fieldSchemas = this.get_fields(db, base_table_name);
            if (tbl == null || fieldSchemas == null) {
                throw new UnknownTableException(tableName + " doesn't exist");
            }
            if (tbl.getPartitionKeys() != null) {
                fieldSchemas.addAll(tbl.getPartitionKeys());
            }
            return fieldSchemas;
        }

        public String getCpuProfile(int profileDurationInSec) throws TException {
            return "";
        }

        @Override
        public String get_config_value(String name, String defaultValue) throws TException, ConfigValSecurityException {
            this.incrementCounter("get_config_value");
            this.logStartFunction("get_config_value: name=" + name + " defaultValue=" + defaultValue);
            if (name == null) {
                return defaultValue;
            }
            if (!Pattern.matches("(hive|hdfs|mapred).*", name)) {
                throw new ConfigValSecurityException("For security reasons, the config key " + name + " cannot be accessed");
            }
            String toReturn = defaultValue;
            try {
                toReturn = this.hiveConf.get(name, defaultValue);
            }
            catch (RuntimeException e) {
                LOG.error((Object)(threadLocalId.get().toString() + ": " + "RuntimeException thrown in get_config_value - msg: " + e.getMessage() + " cause: " + e.getCause()));
            }
            return toReturn;
        }

        private List<String> getPartValsFromName(RawStore ms, String dbName, String tblName, String partName) throws MetaException, InvalidObjectException {
            LinkedHashMap<String, String> hm = Warehouse.makeSpecFromName(partName);
            Table t = ms.getTable(dbName, tblName);
            if (t == null) {
                throw new InvalidObjectException(dbName + "." + tblName + " table not found");
            }
            ArrayList<String> partVals = new ArrayList<String>();
            for (FieldSchema field : t.getPartitionKeys()) {
                String key = field.getName();
                String val = hm.get(key);
                if (val == null) {
                    throw new InvalidObjectException("incomplete partition name - missing " + key);
                }
                partVals.add(val);
            }
            return partVals;
        }

        private Partition get_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name) throws MetaException, NoSuchObjectException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            Partition p = ms.getPartition(db_name, tbl_name, partVals);
            if (p == null) {
                throw new NoSuchObjectException(db_name + "." + tbl_name + " partition (" + part_name + ") not found");
            }
            return p;
        }

        @Override
        public Partition get_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws MetaException, NoSuchObjectException, TException {
            this.incrementCounter("get_partition_by_name");
            this.logStartFunction("get_partition_by_name: db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        return HMSHandler.this.get_partition_by_name_core(ms, db_name, tbl_name, part_name);
                    }
                });
            }
            catch (MetaException e) {
                throw e;
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public Partition append_partition_by_name(final String db_name, final String tbl_name, final String part_name) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
            this.incrementCounter("append_partition_by_name");
            this.logStartFunction("append_partition_by_name: db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Partition ret = null;
            try {
                ret = this.executeWithRetry(new Command<Partition>(){

                    @Override
                    Partition run(RawStore ms) throws Exception {
                        List partVals = HMSHandler.this.getPartValsFromName(ms, db_name, tbl_name, part_name);
                        return HMSHandler.this.append_partition_common(ms, db_name, tbl_name, partVals);
                    }
                });
            }
            catch (InvalidObjectException e) {
                throw e;
            }
            catch (AlreadyExistsException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        private boolean drop_partition_by_name_core(RawStore ms, String db_name, String tbl_name, String part_name, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            List<String> partVals = null;
            try {
                partVals = this.getPartValsFromName(ms, db_name, tbl_name, part_name);
            }
            catch (InvalidObjectException e) {
                throw new NoSuchObjectException(e.getMessage());
            }
            return this.drop_partition_common(ms, db_name, tbl_name, partVals, deleteData);
        }

        @Override
        public boolean drop_partition_by_name(final String db_name, final String tbl_name, final String part_name, final boolean deleteData) throws NoSuchObjectException, MetaException, TException {
            this.incrementCounter("drop_partition_by_name");
            this.logStartFunction("drop_partition_by_name: db=" + db_name + " tbl=" + tbl_name + " part=" + part_name);
            Boolean ret = null;
            try {
                ret = this.executeWithRetry(new Command<Boolean>(){

                    @Override
                    Boolean run(RawStore ms) throws Exception {
                        return HMSHandler.this.drop_partition_by_name_core(ms, db_name, tbl_name, part_name, deleteData);
                    }
                });
            }
            catch (NoSuchObjectException e) {
                throw e;
            }
            catch (MetaException e) {
                throw e;
            }
            catch (TException e) {
                throw e;
            }
            catch (Exception e) {
                assert (e instanceof RuntimeException);
                throw (RuntimeException)e;
            }
            return ret;
        }

        @Override
        public List<Partition> get_partitions_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
            this.incrementCounter("get_partitions_ps");
            this.logStartPartitionFunction("get_partitions_ps", db_name, tbl_name, part_vals);
            List<Partition> parts = null;
            ArrayList<Partition> matchingParts = new ArrayList<Partition>();
            try {
                parts = this.get_partitions(db_name, tbl_name, (short)-1);
            }
            catch (NoSuchObjectException e) {
                throw new MetaException(e.getMessage());
            }
            for (Partition p : parts) {
                if (!MetaStoreUtils.pvalMatches(part_vals, p.getValues())) continue;
                matchingParts.add(p);
            }
            return matchingParts;
        }

        @Override
        public List<String> get_partition_names_ps(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
            this.incrementCounter("get_partition_names_ps");
            this.logStartPartitionFunction("get_partitions_names_ps", db_name, tbl_name, part_vals);
            try {
                Table t = this.get_table(db_name, tbl_name);
            }
            catch (NoSuchObjectException e) {
                throw new MetaException(e.getMessage());
            }
            List<String> partNames = this.get_partition_names(db_name, tbl_name, max_parts);
            ArrayList<String> filteredPartNames = new ArrayList<String>();
            for (String name : partNames) {
                LinkedHashMap<String, String> spec = Warehouse.makeSpecFromName(name);
                ArrayList<String> vals = new ArrayList<String>();
                for (String val : spec.values()) {
                    vals.add(val);
                }
                if (!MetaStoreUtils.pvalMatches(part_vals, vals)) continue;
                filteredPartNames.add(name);
            }
            return filteredPartNames;
        }

        @Override
        public List<String> partition_name_to_vals(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new ArrayList<String>();
            }
            LinkedHashMap<String, String> map = Warehouse.makeSpecFromName(part_name);
            ArrayList<String> part_vals = new ArrayList<String>();
            part_vals.addAll(map.values());
            return part_vals;
        }

        @Override
        public Map<String, String> partition_name_to_spec(String part_name) throws MetaException, TException {
            if (part_name.length() == 0) {
                return new HashMap<String, String>();
            }
            return Warehouse.makeSpecFromName(part_name);
        }

        private static class Command<T> {
            private Command() {
            }

            T run(RawStore ms) throws Exception {
                return null;
            }
        }
    }
}

