/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.HiveMetaHookLoader;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.AlreadyExistsException;
import org.apache.hadoop.hive.metastore.api.ConfigValSecurityException;
import org.apache.hadoop.hive.metastore.api.Database;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidObjectException;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.metastore.api.ThriftHiveMetastore;
import org.apache.hadoop.hive.metastore.api.Type;
import org.apache.hadoop.hive.metastore.api.UnknownDBException;
import org.apache.hadoop.hive.metastore.api.UnknownTableException;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class HiveMetaStoreClient
implements IMetaStoreClient {
    ThriftHiveMetastore.Iface client = null;
    private TTransport transport = null;
    private boolean open = false;
    private URI[] metastoreUris;
    private final boolean standAloneClient = false;
    private final HiveMetaHookLoader hookLoader;
    private int retries = 5;
    private static final Log LOG = LogFactory.getLog((String)"hive.metastore");

    public HiveMetaStoreClient(HiveConf conf) throws MetaException {
        this(conf, null);
    }

    public HiveMetaStoreClient(HiveConf conf, HiveMetaHookLoader hookLoader) throws MetaException {
        boolean localMetaStore;
        this.hookLoader = hookLoader;
        if (conf == null) {
            conf = new HiveConf(HiveMetaStoreClient.class);
        }
        if (localMetaStore = conf.getBoolean("hive.metastore.local", false)) {
            this.client = new HiveMetaStore.HMSHandler("hive client", conf);
            this.open = true;
            return;
        }
        this.retries = HiveConf.getIntVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.METATORETHRIFTRETRIES);
        if (conf.getVar(HiveConf.ConfVars.METASTOREURIS) != null) {
            String[] metastoreUrisString = conf.getVar(HiveConf.ConfVars.METASTOREURIS).split(",");
            this.metastoreUris = new URI[metastoreUrisString.length];
            try {
                int i = 0;
                for (String s : metastoreUrisString) {
                    URI tmpUri = new URI(s);
                    if (tmpUri.getScheme() == null) {
                        throw new IllegalArgumentException("URI: " + s + " does not have a scheme");
                    }
                    this.metastoreUris[i++] = tmpUri;
                }
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else if (conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY) != null) {
            this.metastoreUris = new URI[1];
            try {
                this.metastoreUris[0] = new URI(conf.getVar(HiveConf.ConfVars.METASTOREDIRECTORY));
            }
            catch (URISyntaxException e) {
                MetaStoreUtils.logAndThrowMetaException(e);
            }
        } else {
            LOG.error((Object)"NOT getting uris from conf");
            throw new MetaException("MetaStoreURIs not found in conf file");
        }
        this.open();
    }

    @Override
    public void alter_table(String dbname, String tbl_name, Table new_tbl) throws InvalidOperationException, MetaException, TException {
        this.client.alter_table(dbname, tbl_name, new_tbl);
    }

    private void open() throws MetaException {
        for (URI store : this.metastoreUris) {
            LOG.info((Object)("Trying to connect to metastore with URI " + store));
            try {
                this.openStore(store);
            }
            catch (MetaException e) {
                LOG.warn((Object)e.getStackTrace());
                LOG.warn((Object)("Unable to connect metastore with URI " + store));
            }
            if (this.open) break;
        }
        if (!this.open) {
            throw new MetaException("Could not connect to meta store using any of the URIs provided");
        }
        LOG.info((Object)"Connected to metastore.");
    }

    private void openStore(URI store) throws MetaException {
        this.open = false;
        this.transport = new TSocket(store.getHost(), store.getPort());
        ((TSocket)this.transport).setTimeout(20000);
        TBinaryProtocol protocol = new TBinaryProtocol(this.transport);
        this.client = new ThriftHiveMetastore.Client((TProtocol)protocol);
        for (int i = 0; i < this.retries && !this.open; ++i) {
            try {
                this.transport.open();
                this.open = true;
                continue;
            }
            catch (TTransportException e) {
                LOG.warn((Object)"failed to connect to MetaStore, re-trying...");
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException ignore) {
                    // empty catch block
                }
            }
        }
        if (!this.open) {
            throw new MetaException("could not connect to meta store");
        }
    }

    @Override
    public void close() {
        this.open = false;
        if (this.transport != null && this.transport.isOpen()) {
            this.transport.close();
        }
    }

    @Override
    public Partition add_partition(Partition new_part) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.add_partition(new_part));
    }

    @Override
    public Partition appendPartition(String db_name, String table_name, List<String> part_vals) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition(db_name, table_name, part_vals));
    }

    @Override
    public Partition appendPartition(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition_by_name(dbName, tableName, partName));
    }

    @Override
    public void createDatabase(Database db) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        this.client.create_database(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(Table tbl) throws AlreadyExistsException, InvalidObjectException, MetaException, NoSuchObjectException, TException {
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preCreateTable(tbl);
        }
        boolean success = false;
        try {
            this.client.create_table(tbl);
            if (hook != null) {
                hook.commitCreateTable(tbl);
            }
            success = true;
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackCreateTable(tbl);
            }
        }
    }

    public boolean createType(Type type) throws AlreadyExistsException, InvalidObjectException, MetaException, TException {
        return this.client.create_type(type);
    }

    @Override
    public void dropDatabase(String name) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        this.dropDatabase(name, true, false);
    }

    @Override
    public void dropDatabase(String name, boolean deleteData, boolean ignoreUnknownDb) throws NoSuchObjectException, InvalidOperationException, MetaException, TException {
        try {
            this.getDatabase(name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUnknownDb) {
                throw e;
            }
            return;
        }
        this.client.drop_database(name, deleteData);
    }

    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.dropPartition(db_name, tbl_name, part_vals, true);
    }

    @Override
    public boolean dropPartition(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name(dbName, tableName, partName, deleteData);
    }

    @Override
    public boolean dropPartition(String db_name, String tbl_name, List<String> part_vals, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition(db_name, tbl_name, part_vals, deleteData);
    }

    @Override
    public void dropTable(String dbname, String name) throws NoSuchObjectException, MetaException, TException {
        this.dropTable(dbname, name, true, true);
    }

    @Override
    @Deprecated
    public void dropTable(String tableName, boolean deleteData) throws MetaException, UnknownTableException, TException, NoSuchObjectException {
        this.dropTable("default", tableName, deleteData, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dropTable(String dbname, String name, boolean deleteData, boolean ignoreUknownTab) throws MetaException, TException, NoSuchObjectException {
        Table tbl;
        try {
            tbl = this.getTable(dbname, name);
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUknownTab) {
                throw e;
            }
            return;
        }
        HiveMetaHook hook = this.getHook(tbl);
        if (hook != null) {
            hook.preDropTable(tbl);
        }
        boolean success = false;
        try {
            this.client.drop_table(dbname, name, deleteData);
            if (hook != null) {
                hook.commitDropTable(tbl, deleteData);
            }
        }
        catch (NoSuchObjectException e) {
            if (!ignoreUknownTab) {
                throw e;
            }
        }
        finally {
            if (!success && hook != null) {
                hook.rollbackDropTable(tbl);
            }
        }
    }

    public boolean dropType(String type) throws MetaException, NoSuchObjectException, TException {
        return this.client.drop_type(type);
    }

    public Map<String, Type> getTypeAll(String name) throws MetaException, TException {
        LinkedHashMap<String, Type> result = null;
        Map<String, Type> fromClient = this.client.get_type_all(name);
        if (fromClient != null) {
            result = new LinkedHashMap<String, Type>();
            for (String key : fromClient.keySet()) {
                result.put(key, this.deepCopy(fromClient.get(key)));
            }
        }
        return result;
    }

    @Override
    public List<String> getDatabases(String databasePattern) throws MetaException {
        try {
            return this.client.get_databases(databasePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllDatabases() throws MetaException {
        try {
            return this.client.get_all_databases();
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions(db_name, tbl_name, max_parts));
    }

    @Override
    public List<Partition> listPartitions(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopyPartitions(this.client.get_partitions_ps(db_name, tbl_name, part_vals, max_parts));
    }

    @Override
    public Database getDatabase(String name) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_database(name));
    }

    @Override
    public Partition getPartition(String db_name, String tbl_name, List<String> part_vals) throws NoSuchObjectException, MetaException, TException {
        return this.deepCopy(this.client.get_partition(db_name, tbl_name, part_vals));
    }

    @Override
    public Table getTable(String dbname, String name) throws MetaException, TException, NoSuchObjectException {
        return this.deepCopy(this.client.get_table(dbname, name));
    }

    @Override
    @Deprecated
    public Table getTable(String tableName) throws MetaException, TException, NoSuchObjectException {
        return this.getTable("default", tableName);
    }

    public Type getType(String name) throws MetaException, NoSuchObjectException, TException {
        return this.deepCopy(this.client.get_type(name));
    }

    @Override
    public List<String> getTables(String dbname, String tablePattern) throws MetaException {
        try {
            return this.client.get_tables(dbname, tablePattern);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public List<String> getAllTables(String dbname) throws MetaException {
        try {
            return this.client.get_all_tables(dbname);
        }
        catch (Exception e) {
            MetaStoreUtils.logAndThrowMetaException(e);
            return null;
        }
    }

    @Override
    public boolean tableExists(String databaseName, String tableName) throws MetaException, TException, UnknownDBException {
        try {
            this.client.get_table(databaseName, tableName);
        }
        catch (NoSuchObjectException e) {
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean tableExists(String tableName) throws MetaException, TException, UnknownDBException {
        return this.tableExists("default", tableName);
    }

    @Override
    public List<String> listPartitionNames(String dbName, String tblName, short max) throws MetaException, TException {
        return this.client.get_partition_names(dbName, tblName, max);
    }

    @Override
    public List<String> listPartitionNames(String db_name, String tbl_name, List<String> part_vals, short max_parts) throws MetaException, TException {
        return this.client.get_partition_names_ps(db_name, tbl_name, part_vals, max_parts);
    }

    @Override
    public void alter_partition(String dbName, String tblName, Partition newPart) throws InvalidOperationException, MetaException, TException {
        this.client.alter_partition(dbName, tblName, newPart);
    }

    @Override
    public List<FieldSchema> getFields(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.deepCopyFieldSchemas(this.client.get_fields(db, tableName));
    }

    @Override
    public List<FieldSchema> getSchema(String db, String tableName) throws MetaException, TException, UnknownTableException, UnknownDBException {
        return this.deepCopyFieldSchemas(this.client.get_schema(db, tableName));
    }

    @Override
    public String getConfigValue(String name, String defaultValue) throws TException, ConfigValSecurityException {
        return this.client.get_config_value(name, defaultValue);
    }

    @Override
    public Partition getPartition(String db, String tableName, String partName) throws MetaException, TException, UnknownTableException, NoSuchObjectException {
        return this.deepCopy(this.client.get_partition_by_name(db, tableName, partName));
    }

    public Partition appendPartitionByName(String dbName, String tableName, String partName) throws InvalidObjectException, AlreadyExistsException, MetaException, TException {
        return this.deepCopy(this.client.append_partition_by_name(dbName, tableName, partName));
    }

    public boolean dropPartitionByName(String dbName, String tableName, String partName, boolean deleteData) throws NoSuchObjectException, MetaException, TException {
        return this.client.drop_partition_by_name(dbName, tableName, partName, deleteData);
    }

    private HiveMetaHook getHook(Table tbl) throws MetaException {
        if (this.hookLoader == null) {
            return null;
        }
        return this.hookLoader.getHook(tbl);
    }

    @Override
    public List<String> partitionNameToVals(String name) throws MetaException, TException {
        return this.client.partition_name_to_vals(name);
    }

    @Override
    public Map<String, String> partitionNameToSpec(String name) throws MetaException, TException {
        return this.client.partition_name_to_spec(name);
    }

    private Partition deepCopy(Partition partition) {
        Partition copy = null;
        if (partition != null) {
            copy = new Partition(partition);
        }
        return copy;
    }

    private Database deepCopy(Database database) {
        Database copy = null;
        if (database != null) {
            copy = new Database(database);
        }
        return copy;
    }

    private Table deepCopy(Table table) {
        Table copy = null;
        if (table != null) {
            copy = new Table(table);
        }
        return copy;
    }

    private Type deepCopy(Type type) {
        Type copy = null;
        if (type != null) {
            copy = new Type(type);
        }
        return copy;
    }

    private FieldSchema deepCopy(FieldSchema schema) {
        FieldSchema copy = null;
        if (schema != null) {
            copy = new FieldSchema(schema);
        }
        return copy;
    }

    private List<Partition> deepCopyPartitions(List<Partition> partitions) {
        ArrayList<Partition> copy = null;
        if (partitions != null) {
            copy = new ArrayList<Partition>();
            for (Partition part : partitions) {
                copy.add(this.deepCopy(part));
            }
        }
        return copy;
    }

    private List<Table> deepCopyTables(List<Table> tables) {
        ArrayList<Table> copy = null;
        if (tables != null) {
            copy = new ArrayList<Table>();
            for (Table tab : tables) {
                copy.add(this.deepCopy(tab));
            }
        }
        return copy;
    }

    private List<FieldSchema> deepCopyFieldSchemas(List<FieldSchema> schemas) {
        ArrayList<FieldSchema> copy = null;
        if (schemas != null) {
            copy = new ArrayList<FieldSchema>();
            for (FieldSchema schema : schemas) {
                copy.add(this.deepCopy(schema));
            }
        }
        return copy;
    }
}

