/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.SerDeInfo;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.serde2.objectinspector.ListObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.MapObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;

public class MetaStoreUtils {
    protected static final Log LOG = LogFactory.getLog((String)"hive.log");
    public static final String DEFAULT_DATABASE_NAME = "default";
    public static final String DEFAULT_DATABASE_COMMENT = "Default Hive database";
    static HashMap<String, String> typeToThriftTypeMap = new HashMap();

    public static void printStackTrace(Exception e) {
        for (StackTraceElement s : e.getStackTrace()) {
            LOG.error((Object)s);
        }
    }

    public static Table createColumnsetSchema(String name, List<String> columns, List<String> partCols, Configuration conf) throws MetaException {
        if (columns == null) {
            throw new MetaException("columns not specified for table " + name);
        }
        Table tTable = new Table();
        tTable.setTableName(name);
        tTable.setSd(new StorageDescriptor());
        StorageDescriptor sd = tTable.getSd();
        sd.setSerdeInfo(new SerDeInfo());
        SerDeInfo serdeInfo = sd.getSerdeInfo();
        serdeInfo.setSerializationLib(LazySimpleSerDe.class.getName());
        serdeInfo.setParameters(new HashMap<String, String>());
        serdeInfo.getParameters().put("serialization.format", "1");
        ArrayList<FieldSchema> fields = new ArrayList<FieldSchema>();
        sd.setCols(fields);
        for (String col : columns) {
            FieldSchema field = new FieldSchema(col, "string", "'default'");
            fields.add(field);
        }
        tTable.setPartitionKeys(new ArrayList<FieldSchema>());
        for (String partCol : partCols) {
            FieldSchema part = new FieldSchema();
            part.setName(partCol);
            part.setType("string");
            tTable.getPartitionKeys().add(part);
        }
        sd.setNumBuckets(-1);
        return tTable;
    }

    public static void recursiveDelete(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fs;
            for (File subf : fs = f.listFiles()) {
                MetaStoreUtils.recursiveDelete(subf);
            }
        }
        if (!f.delete()) {
            throw new IOException("could not delete: " + f.getPath());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Properties schema) throws MetaException {
        String lib = schema.getProperty("serialization.lib");
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, schema);
            return deserializer;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Table table) throws MetaException {
        String lib = table.getSd().getSerdeInfo().getSerializationLib();
        if (lib == null) {
            return null;
        }
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, MetaStoreUtils.getSchema(table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static Deserializer getDeserializer(Configuration conf, Partition part, Table table) throws MetaException {
        String lib = part.getSd().getSerdeInfo().getSerializationLib();
        try {
            Deserializer deserializer = SerDeUtils.lookupDeserializer((String)lib);
            deserializer.initialize(conf, MetaStoreUtils.getSchema(part, table));
            return deserializer;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            LOG.error((Object)("error in initSerDe: " + e.getClass().getName() + " " + e.getMessage()));
            MetaStoreUtils.printStackTrace(e);
            throw new MetaException(e.getClass().getName() + " " + e.getMessage());
        }
    }

    public static void deleteWHDirectory(Path path, Configuration conf, boolean use_trash) throws MetaException {
        try {
            if (!path.getFileSystem(conf).exists(path)) {
                LOG.warn((Object)("drop data called on table/partition with no directory: " + path));
                return;
            }
            if (use_trash) {
                int count = 0;
                Path newPath = new Path("/Trash/Current" + path.getParent().toUri().getPath());
                if (!path.getFileSystem(conf).exists(newPath)) {
                    path.getFileSystem(conf).mkdirs(newPath);
                }
                do {
                    newPath = new Path("/Trash/Current" + path.toUri().getPath() + "." + count);
                    if (path.getFileSystem(conf).exists(newPath)) {
                        ++count;
                        continue;
                    }
                    if (path.getFileSystem(conf).rename(path, newPath)) break;
                } while (++count < 50);
                if (count >= 50) {
                    throw new MetaException("Rename failed due to maxing out retries");
                }
            } else {
                path.getFileSystem(conf).delete(path, true);
            }
        }
        catch (IOException e) {
            LOG.error((Object)("Got exception trying to delete data dir: " + e));
            throw new MetaException(e.getMessage());
        }
        catch (MetaException e) {
            LOG.error((Object)("Got exception trying to delete data dir: " + e));
            throw e;
        }
    }

    public static boolean validateName(String name) {
        Pattern tpat = Pattern.compile("[\\w_]+");
        Matcher m = tpat.matcher(name);
        return m.matches();
    }

    public static boolean validateColNames(List<FieldSchema> cols) {
        for (FieldSchema fieldSchema : cols) {
            if (MetaStoreUtils.validateName(fieldSchema.getName())) continue;
            return false;
        }
        return true;
    }

    public static String getListType(String t) {
        return "array<" + t + ">";
    }

    public static String getMapType(String k, String v) {
        return "map<" + k + "," + v + ">";
    }

    public static void setSerdeParam(SerDeInfo sdi, Properties schema, String param) {
        String val = schema.getProperty(param);
        if (StringUtils.isNotBlank((String)val)) {
            sdi.getParameters().put(param, val);
        }
    }

    public static String typeToThriftType(String type) {
        StringBuilder thriftType = new StringBuilder();
        int last = 0;
        boolean lastAlphaDigit = Character.isLetterOrDigit(type.charAt(last));
        for (int i = 1; i <= type.length(); ++i) {
            if (i != type.length() && Character.isLetterOrDigit(type.charAt(i)) == lastAlphaDigit) continue;
            String token = type.substring(last, i);
            last = i;
            String thriftToken = typeToThriftTypeMap.get(token);
            thriftType.append(thriftToken == null ? token : thriftToken);
            lastAlphaDigit = !lastAlphaDigit;
        }
        return thriftType.toString();
    }

    public static String getFullDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append(MetaStoreUtils.getDDLFromFieldSchema(structName, fieldSchemas));
        ddl.append('#');
        StringBuilder colnames = new StringBuilder();
        StringBuilder coltypes = new StringBuilder();
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                colnames.append(',');
                coltypes.append(':');
            }
            colnames.append(col.getName());
            coltypes.append(col.getType());
        }
        ddl.append((CharSequence)colnames);
        ddl.append('#');
        ddl.append((CharSequence)coltypes);
        return ddl.toString();
    }

    public static String getDDLFromFieldSchema(String structName, List<FieldSchema> fieldSchemas) {
        StringBuilder ddl = new StringBuilder();
        ddl.append("struct ");
        ddl.append(structName);
        ddl.append(" { ");
        boolean first = true;
        for (FieldSchema col : fieldSchemas) {
            if (first) {
                first = false;
            } else {
                ddl.append(", ");
            }
            ddl.append(MetaStoreUtils.typeToThriftType(col.getType()));
            ddl.append(' ');
            ddl.append(col.getName());
        }
        ddl.append("}");
        LOG.info((Object)("DDL: " + ddl));
        return ddl.toString();
    }

    public static Properties getSchema(Table table) {
        return MetaStoreUtils.getSchema(table.getSd(), table.getSd(), table.getParameters(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(Partition part, Table table) {
        return MetaStoreUtils.getSchema(part.getSd(), table.getSd(), table.getParameters(), table.getTableName(), table.getPartitionKeys());
    }

    public static Properties getSchema(StorageDescriptor sd, StorageDescriptor tblsd, Map<String, String> parameters, String tableName, List<FieldSchema> partitionKeys) {
        Properties schema = new Properties();
        String inputFormat = sd.getInputFormat();
        if (inputFormat == null || inputFormat.length() == 0) {
            inputFormat = SequenceFileInputFormat.class.getName();
        }
        schema.setProperty("file.inputformat", inputFormat);
        String outputFormat = sd.getOutputFormat();
        if (outputFormat == null || outputFormat.length() == 0) {
            outputFormat = SequenceFileOutputFormat.class.getName();
        }
        schema.setProperty("file.outputformat", outputFormat);
        schema.setProperty("name", tableName);
        if (sd.getLocation() != null) {
            schema.setProperty("location", sd.getLocation());
        }
        schema.setProperty("bucket_count", Integer.toString(sd.getNumBuckets()));
        if (sd.getBucketCols() != null && sd.getBucketCols().size() > 0) {
            schema.setProperty("bucket_field_name", sd.getBucketCols().get(0));
        }
        if (sd.getSerdeInfo() != null) {
            schema.putAll(sd.getSerdeInfo().getParameters());
            if (sd.getSerdeInfo().getSerializationLib() != null) {
                schema.setProperty("serialization.lib", sd.getSerdeInfo().getSerializationLib());
            }
        }
        StringBuilder colNameBuf = new StringBuilder();
        StringBuilder colTypeBuf = new StringBuilder();
        boolean first = true;
        for (FieldSchema col : tblsd.getCols()) {
            if (!first) {
                colNameBuf.append(",");
                colTypeBuf.append(":");
            }
            colNameBuf.append(col.getName());
            colTypeBuf.append(col.getType());
            first = false;
        }
        String colNames = colNameBuf.toString();
        String colTypes = colTypeBuf.toString();
        schema.setProperty("columns", colNames);
        schema.setProperty("columns.types", colTypes);
        if (sd.getCols() != null) {
            schema.setProperty("serialization.ddl", MetaStoreUtils.getDDLFromFieldSchema(tableName, sd.getCols()));
        }
        String partString = "";
        String partStringSep = "";
        for (FieldSchema fieldSchema : partitionKeys) {
            partString = partString.concat(partStringSep);
            partString = partString.concat(fieldSchema.getName());
            if (partStringSep.length() != 0) continue;
            partStringSep = "/";
        }
        if (partString.length() > 0) {
            schema.setProperty("partition_columns", partString);
        }
        if (parameters != null) {
            for (Map.Entry entry : parameters.entrySet()) {
                schema.setProperty((String)entry.getKey(), (String)entry.getValue());
            }
        }
        return schema;
    }

    public static String getColumnNamesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fieldSchemas.get(i).getName());
        }
        return sb.toString();
    }

    public static String getColumnTypesFromFieldSchema(List<FieldSchema> fieldSchemas) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < fieldSchemas.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(fieldSchemas.get(i).getType());
        }
        return sb.toString();
    }

    public static void makeDir(Path path, HiveConf hiveConf) throws MetaException {
        try {
            FileSystem fs = path.getFileSystem((Configuration)hiveConf);
            if (!fs.exists(path)) {
                fs.mkdirs(path);
            }
        }
        catch (IOException e) {
            throw new MetaException("Unable to : " + path);
        }
    }

    static void logAndThrowMetaException(Exception e) throws MetaException {
        LOG.error((Object)("Got exception: " + e.getClass().getName() + " " + e.getMessage()));
        LOG.error((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
        throw new MetaException("Got exception: " + e.getClass().getName() + " " + e.getMessage());
    }

    public static List<FieldSchema> getFieldsFromDeserializer(String tableName, Deserializer deserializer) throws SerDeException, MetaException {
        ObjectInspector oi = deserializer.getObjectInspector();
        String[] names = tableName.split("\\.");
        String last_name = names[names.length - 1];
        for (int i = 1; i < names.length; ++i) {
            MapObjectInspector moi;
            if (oi instanceof StructObjectInspector) {
                StructObjectInspector soi = (StructObjectInspector)oi;
                StructField sf = soi.getStructFieldRef(names[i]);
                if (sf == null) {
                    throw new MetaException("Invalid Field " + names[i]);
                }
                oi = sf.getFieldObjectInspector();
                continue;
            }
            if (oi instanceof ListObjectInspector && names[i].equalsIgnoreCase("$elem$")) {
                ListObjectInspector loi = (ListObjectInspector)oi;
                oi = loi.getListElementObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$key$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapKeyObjectInspector();
                continue;
            }
            if (oi instanceof MapObjectInspector && names[i].equalsIgnoreCase("$value$")) {
                moi = (MapObjectInspector)oi;
                oi = moi.getMapValueObjectInspector();
                continue;
            }
            throw new MetaException("Unknown type for " + names[i]);
        }
        ArrayList<FieldSchema> str_fields = new ArrayList<FieldSchema>();
        if (oi.getCategory() != ObjectInspector.Category.STRUCT) {
            str_fields.add(new FieldSchema(last_name, oi.getTypeName(), "from deserializer"));
        } else {
            List fields = ((StructObjectInspector)oi).getAllStructFieldRefs();
            for (int i = 0; i < fields.size(); ++i) {
                String fieldName = ((StructField)fields.get(i)).getFieldName();
                String fieldTypeName = ((StructField)fields.get(i)).getFieldObjectInspector().getTypeName();
                str_fields.add(new FieldSchema(fieldName, fieldTypeName, "from deserializer"));
            }
        }
        return str_fields;
    }

    public static FieldSchema getFieldSchemaFromTypeInfo(String fieldName, TypeInfo typeInfo) {
        return new FieldSchema(fieldName, typeInfo.getTypeName(), "generated by TypeInfoUtils.getFieldSchemaFromTypeInfo");
    }

    public static boolean isExternalTable(Table table) {
        if (table == null) {
            return false;
        }
        Map<String, String> params = table.getParameters();
        if (params == null) {
            return false;
        }
        return "TRUE".equalsIgnoreCase(params.get("EXTERNAL"));
    }

    public static boolean isArchived(Partition part) {
        Map<String, String> params = part.getParameters();
        return "true".equalsIgnoreCase(params.get("is_archived"));
    }

    public static Path getOriginalLocation(Partition part) {
        Map<String, String> params = part.getParameters();
        assert (MetaStoreUtils.isArchived(part));
        String originalLocation = params.get("original_location");
        assert (originalLocation != null);
        return new Path(originalLocation);
    }

    public static boolean isNonNativeTable(Table table) {
        if (table == null) {
            return false;
        }
        return table.getParameters().get("storage_handler") != null;
    }

    public static boolean pvalMatches(List<String> partial, List<String> full) {
        if (partial.size() > full.size()) {
            return false;
        }
        Iterator<String> p = partial.iterator();
        Iterator<String> f = full.iterator();
        while (p.hasNext()) {
            String pval = p.next();
            String fval = f.next();
            if (pval.length() == 0 || pval.equals(fval)) continue;
            return false;
        }
        return true;
    }

    static {
        typeToThriftTypeMap.put("boolean", "bool");
        typeToThriftTypeMap.put("tinyint", "byte");
        typeToThriftTypeMap.put("smallint", "i16");
        typeToThriftTypeMap.put("int", "i32");
        typeToThriftTypeMap.put("bigint", "i64");
        typeToThriftTypeMap.put("double", "double");
        typeToThriftTypeMap.put("float", "float");
        typeToThriftTypeMap.put("array", "list");
        typeToThriftTypeMap.put("map", "map");
        typeToThriftTypeMap.put("string", "string");
        typeToThriftTypeMap.put("date", "date");
        typeToThriftTypeMap.put("datetime", "datetime");
        typeToThriftTypeMap.put("timestamp", "timestamp");
    }
}

