/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.hbase;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.MasterNotRunningException;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.HTable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hive.hbase.HBaseSerDe;
import org.apache.hadoop.hive.hbase.HiveHBaseTableInputFormat;
import org.apache.hadoop.hive.hbase.HiveHBaseTableOutputFormat;
import org.apache.hadoop.hive.metastore.HiveMetaHook;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.HiveStorageHandler;
import org.apache.hadoop.hive.ql.plan.TableDesc;
import org.apache.hadoop.hive.serde2.SerDe;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.util.StringUtils;

public class HBaseStorageHandler
implements HiveStorageHandler,
HiveMetaHook {
    private HBaseConfiguration hbaseConf;
    private HBaseAdmin admin;

    private HBaseAdmin getHBaseAdmin() throws MetaException {
        try {
            if (this.admin == null) {
                this.admin = new HBaseAdmin(this.hbaseConf);
            }
            return this.admin;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
    }

    private String getHBaseTableName(Table tbl) {
        String tableName = (String)tbl.getParameters().get("hbase.table.name");
        if (tableName == null) {
            tableName = (String)tbl.getSd().getSerdeInfo().getParameters().get("hbase.table.name");
        }
        if (tableName == null) {
            tableName = tbl.getTableName();
        }
        return tableName;
    }

    public void preDropTable(Table table) throws MetaException {
    }

    public void rollbackDropTable(Table table) throws MetaException {
    }

    public void commitDropTable(Table tbl, boolean deleteData) throws MetaException {
        try {
            String tableName = this.getHBaseTableName(tbl);
            boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
            if (deleteData && !isExternal) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void preCreateTable(Table tbl) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)tbl);
        if (tbl.getSd().getLocation() != null) {
            throw new MetaException("LOCATION may not be specified for HBase.");
        }
        try {
            HTableDescriptor tblDesc;
            int iKeyLast;
            String tblName = this.getHBaseTableName(tbl);
            HashSet<String> columnFamilies = new HashSet<String>();
            Map serdeParam = tbl.getSd().getSerdeInfo().getParameters();
            String hbaseColumnStr = (String)serdeParam.get("hbase.columns.mapping");
            if (hbaseColumnStr == null) {
                throw new MetaException("No hbase.columns.mapping defined in Serde.");
            }
            List<String> hbaseColumns = HBaseSerDe.parseColumnMapping(hbaseColumnStr);
            int iKeyFirst = hbaseColumns.indexOf(":key");
            if (iKeyFirst != (iKeyLast = hbaseColumns.lastIndexOf(":key"))) {
                throw new MetaException("Multiple key columns defined in hbase.columns.mapping.");
            }
            for (String hbaseColumn : hbaseColumns) {
                if (HBaseSerDe.isSpecialColumn(hbaseColumn)) continue;
                int idx = hbaseColumn.indexOf(":");
                if (idx < 0) {
                    throw new MetaException(hbaseColumn + " is not a qualified hbase column.");
                }
                columnFamilies.add(hbaseColumn.substring(0, idx));
            }
            if (!this.getHBaseAdmin().tableExists(tblName)) {
                if (isExternal) throw new MetaException("HBase table " + tblName + " doesn't exist while the table is declared as an external table.");
                tblDesc = new HTableDescriptor(tblName);
                for (String cf : columnFamilies) {
                    tblDesc.addFamily(new HColumnDescriptor(cf + ":"));
                }
                this.getHBaseAdmin().createTable(tblDesc);
            } else {
                if (!isExternal) {
                    throw new MetaException("Table " + tblName + " already exists" + " within HBase; use CREATE EXTERNAL TABLE instead to" + " register it in Hive.");
                }
                tblDesc = this.getHBaseAdmin().getTableDescriptor(Bytes.toBytes((String)tblName));
                for (String cf : columnFamilies) {
                    if (tblDesc.hasFamily(Bytes.toBytes((String)cf))) continue;
                    throw new MetaException("Column Family " + cf + " is not defined in hbase table " + tblName);
                }
            }
            new HTable(this.hbaseConf, tblDesc.getName());
            return;
        }
        catch (MasterNotRunningException mnre) {
            throw new MetaException(StringUtils.stringifyException((Throwable)mnre));
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void rollbackCreateTable(Table table) throws MetaException {
        boolean isExternal = MetaStoreUtils.isExternalTable((Table)table);
        String tableName = this.getHBaseTableName(table);
        try {
            if (!isExternal && this.getHBaseAdmin().tableExists(tableName)) {
                if (this.getHBaseAdmin().isTableEnabled(tableName)) {
                    this.getHBaseAdmin().disableTable(tableName);
                }
                this.getHBaseAdmin().deleteTable(tableName);
            }
        }
        catch (IOException ie) {
            throw new MetaException(StringUtils.stringifyException((Throwable)ie));
        }
    }

    public void commitCreateTable(Table table) throws MetaException {
    }

    public Configuration getConf() {
        return this.hbaseConf;
    }

    public void setConf(Configuration conf) {
        this.hbaseConf = new HBaseConfiguration(conf);
    }

    public Class<? extends InputFormat> getInputFormatClass() {
        return HiveHBaseTableInputFormat.class;
    }

    public Class<? extends OutputFormat> getOutputFormatClass() {
        return HiveHBaseTableOutputFormat.class;
    }

    public Class<? extends SerDe> getSerDeClass() {
        return HBaseSerDe.class;
    }

    public HiveMetaHook getMetaHook() {
        return this;
    }

    public void configureTableJobProperties(TableDesc tableDesc, Map<String, String> jobProperties) {
        Properties tableProperties = tableDesc.getProperties();
        jobProperties.put("hbase.columns.mapping", tableProperties.getProperty("hbase.columns.mapping"));
        String tableName = tableProperties.getProperty("hbase.table.name");
        if (tableName == null) {
            tableName = tableProperties.getProperty("name");
        }
        jobProperties.put("hbase.table.name", tableName);
    }
}

