/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.BufferedWriter;
import java.io.DataOutput;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.MetaStoreUtils;
import org.apache.hadoop.hive.metastore.Warehouse;
import org.apache.hadoop.hive.metastore.api.FieldSchema;
import org.apache.hadoop.hive.metastore.api.InvalidOperationException;
import org.apache.hadoop.hive.metastore.api.MetaException;
import org.apache.hadoop.hive.metastore.api.Order;
import org.apache.hadoop.hive.metastore.api.StorageDescriptor;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.FunctionRegistry;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.hive.ql.hooks.ReadEntity;
import org.apache.hadoop.hive.ql.hooks.WriteEntity;
import org.apache.hadoop.hive.ql.metadata.CheckResult;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.metadata.HiveMetaStoreChecker;
import org.apache.hadoop.hive.ql.metadata.InvalidTableException;
import org.apache.hadoop.hive.ql.metadata.Partition;
import org.apache.hadoop.hive.ql.metadata.Table;
import org.apache.hadoop.hive.ql.plan.AddPartitionDesc;
import org.apache.hadoop.hive.ql.plan.DDLWork;
import org.apache.hadoop.hive.ql.plan.MsckDesc;
import org.apache.hadoop.hive.ql.plan.alterTableDesc;
import org.apache.hadoop.hive.ql.plan.createTableDesc;
import org.apache.hadoop.hive.ql.plan.createTableLikeDesc;
import org.apache.hadoop.hive.ql.plan.descFunctionDesc;
import org.apache.hadoop.hive.ql.plan.descTableDesc;
import org.apache.hadoop.hive.ql.plan.dropTableDesc;
import org.apache.hadoop.hive.ql.plan.showFunctionsDesc;
import org.apache.hadoop.hive.ql.plan.showPartitionsDesc;
import org.apache.hadoop.hive.ql.plan.showTableStatusDesc;
import org.apache.hadoop.hive.ql.plan.showTablesDesc;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.MetadataTypedColumnsetSerDe;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.columnar.ColumnarSerDe;
import org.apache.hadoop.hive.serde2.dynamic_type.DynamicSerDe;
import org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe;
import org.apache.hadoop.hive.shims.ShimLoader;

public class DDLTask
extends Task<DDLWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Log LOG = LogFactory.getLog((String)"hive.ql.exec.DDLTask");
    transient HiveConf conf;
    private static final int separator = 9;
    private static final int terminator = 10;

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan) {
        super.initialize(conf, queryPlan);
        this.conf = conf;
    }

    @Override
    public int execute() {
        try {
            Hive db = Hive.get(this.conf);
            createTableDesc crtTbl = ((DDLWork)this.work).getCreateTblDesc();
            if (crtTbl != null) {
                return this.createTable(db, crtTbl);
            }
            createTableLikeDesc crtTblLike = ((DDLWork)this.work).getCreateTblLikeDesc();
            if (crtTblLike != null) {
                return this.createTableLike(db, crtTblLike);
            }
            dropTableDesc dropTbl = ((DDLWork)this.work).getDropTblDesc();
            if (dropTbl != null) {
                return this.dropTable(db, dropTbl);
            }
            alterTableDesc alterTbl = ((DDLWork)this.work).getAlterTblDesc();
            if (alterTbl != null) {
                return this.alterTable(db, alterTbl);
            }
            AddPartitionDesc addPartitionDesc = ((DDLWork)this.work).getAddPartitionDesc();
            if (addPartitionDesc != null) {
                return this.addPartition(db, addPartitionDesc);
            }
            MsckDesc msckDesc = ((DDLWork)this.work).getMsckDesc();
            if (msckDesc != null) {
                return this.msck(db, msckDesc);
            }
            descTableDesc descTbl = ((DDLWork)this.work).getDescTblDesc();
            if (descTbl != null) {
                return this.describeTable(db, descTbl);
            }
            descFunctionDesc descFunc = ((DDLWork)this.work).getDescFunctionDesc();
            if (descFunc != null) {
                return this.describeFunction(descFunc);
            }
            showTablesDesc showTbls = ((DDLWork)this.work).getShowTblsDesc();
            if (showTbls != null) {
                return this.showTables(db, showTbls);
            }
            showTableStatusDesc showTblStatus = ((DDLWork)this.work).getShowTblStatusDesc();
            if (showTblStatus != null) {
                return this.showTableStatus(db, showTblStatus);
            }
            showFunctionsDesc showFuncs = ((DDLWork)this.work).getShowFuncsDesc();
            if (showFuncs != null) {
                return this.showFunctions(showFuncs);
            }
            showPartitionsDesc showParts = ((DDLWork)this.work).getShowPartsDesc();
            if (showParts != null) {
                return this.showPartitions(db, showParts);
            }
        }
        catch (InvalidTableException e) {
            this.console.printError("Table " + e.getTableName() + " does not exist");
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (HiveException e) {
            this.console.printError("FAILED: Error in metadata: " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            LOG.debug((Object)org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        assert (false);
        return 0;
    }

    private int addPartition(Hive db, AddPartitionDesc addPartitionDesc) throws HiveException {
        Table tbl = db.getTable(addPartitionDesc.getDbName(), addPartitionDesc.getTableName());
        Partition checkPart = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        if (checkPart != null && addPartitionDesc.getIfNotExists()) {
            return 0;
        }
        if (addPartitionDesc.getLocation() == null) {
            db.createPartition(tbl, addPartitionDesc.getPartSpec());
        } else {
            db.createPartition(tbl, addPartitionDesc.getPartSpec(), new Path(tbl.getPath(), addPartitionDesc.getLocation()));
        }
        Partition part = db.getPartition(tbl, addPartitionDesc.getPartSpec(), false);
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(part));
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private int msck(Hive db, MsckDesc msckDesc) {
        CheckResult result = new CheckResult();
        ArrayList<String> repairOutput = new ArrayList<String>();
        try {
            HiveMetaStoreChecker checker = new HiveMetaStoreChecker(db);
            checker.checkMetastore("default", msckDesc.getTableName(), msckDesc.getPartitionSpec(), result);
            if (!msckDesc.isRepairPartitions()) return 0;
            Table table = db.getTable("default", msckDesc.getTableName());
            Iterator<CheckResult.PartitionResult> i$ = result.getPartitionsNotInMs().iterator();
            while (i$.hasNext()) {
                CheckResult.PartitionResult part = i$.next();
                try {
                    db.createPartition(table, Warehouse.makeSpecFromName((String)part.getPartitionName()));
                    repairOutput.add("Repair: Added partition to metastore " + msckDesc.getTableName() + ':' + part.getPartitionName());
                }
                catch (Exception e) {
                    LOG.warn((Object)"Repair error, could not add partition to metastore: ", (Throwable)e);
                }
            }
            return 0;
        }
        catch (HiveException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        catch (IOException e) {
            LOG.warn((Object)"Failed to run metacheck: ", (Throwable)e);
            int n = 1;
            return n;
        }
        finally {
            BufferedWriter resultOut = null;
            try {
                FileSystem fs = msckDesc.getResFile().getFileSystem((Configuration)this.conf);
                resultOut = new BufferedWriter(new OutputStreamWriter((OutputStream)fs.create(msckDesc.getResFile())));
                boolean firstWritten = false;
                firstWritten |= this.writeMsckResult(result.getTablesNotInMs(), "Tables not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getTablesNotOnFs(), "Tables missing on filesystem:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotInMs(), "Partitions not in metastore:", resultOut, firstWritten);
                firstWritten |= this.writeMsckResult(result.getPartitionsNotOnFs(), "Partitions missing from filesystem:", resultOut, firstWritten);
                for (String rout : repairOutput) {
                    if (firstWritten) {
                        resultOut.write(10);
                    } else {
                        firstWritten = true;
                    }
                    resultOut.write(rout);
                }
            }
            catch (IOException e) {
                LOG.warn((Object)"Failed to save metacheck output: ", (Throwable)e);
                int firstWritten = 1;
                return firstWritten;
            }
            finally {
                if (resultOut != null) {
                    try {
                        resultOut.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Object)"Failed to close output file: ", (Throwable)e);
                        return 1;
                    }
                }
            }
        }
    }

    private boolean writeMsckResult(List<? extends Object> result, String msg, Writer out, boolean wrote) throws IOException {
        if (!result.isEmpty()) {
            if (wrote) {
                out.write(10);
            }
            out.write(msg);
            for (Object object : result) {
                out.write(9);
                out.write(object.toString());
            }
            return true;
        }
        return false;
    }

    private int showPartitions(Hive db, showPartitionsDesc showParts) throws HiveException {
        String tabName = showParts.getTabName();
        Table tbl = null;
        List<String> parts = null;
        tbl = db.getTable("default", tabName);
        if (!tbl.isPartitioned()) {
            this.console.printError("Table " + tabName + " is not a partitioned table");
            return 1;
        }
        parts = db.getPartitionNames("default", tbl.getName(), (short)Short.MAX_VALUE);
        try {
            FileSystem fs = showParts.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(showParts.getResFile());
            Iterator<String> iterParts = parts.iterator();
            while (iterParts.hasNext()) {
                outStream.writeBytes(iterParts.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (IOException e) {
            LOG.info((Object)("show partitions: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            throw new HiveException(e.toString());
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTables(Hive db, showTablesDesc showTbls) throws HiveException {
        List<String> tbls = null;
        if (showTbls.getPattern() != null) {
            LOG.info((Object)("pattern: " + showTbls.getPattern()));
            tbls = db.getTablesByPattern(showTbls.getPattern());
            LOG.info((Object)("results : " + tbls.size()));
        } else {
            tbls = db.getAllTables();
        }
        try {
            FileSystem fs = showTbls.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(showTbls.getResFile());
            TreeSet<String> sortedTbls = new TreeSet<String>(tbls);
            Iterator iterTbls = sortedTbls.iterator();
            while (iterTbls.hasNext()) {
                outStream.writeBytes((String)iterTbls.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showFunctions(showFunctionsDesc showFuncs) throws HiveException {
        Set<String> funcs = null;
        if (showFuncs.getPattern() != null) {
            LOG.info((Object)("pattern: " + showFuncs.getPattern()));
            funcs = FunctionRegistry.getFunctionNames(showFuncs.getPattern());
            LOG.info((Object)("results : " + funcs.size()));
        } else {
            funcs = FunctionRegistry.getFunctionNames();
        }
        try {
            FileSystem fs = showFuncs.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(showFuncs.getResFile());
            TreeSet<String> sortedFuncs = new TreeSet<String>(funcs);
            Iterator iterFuncs = sortedFuncs.iterator();
            while (iterFuncs.hasNext()) {
                outStream.writeBytes((String)iterFuncs.next());
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("show function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int describeFunction(descFunctionDesc descFunc) throws HiveException {
        String funcName = descFunc.getName();
        try {
            FileSystem fs = descFunc.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(descFunc.getResFile());
            description desc = null;
            Class<?> funcClass = null;
            FunctionInfo functionInfo = FunctionRegistry.getFunctionInfo(funcName);
            if (functionInfo != null) {
                funcClass = functionInfo.getFunctionClass();
            }
            if (funcClass != null) {
                desc = funcClass.getAnnotation(description.class);
            }
            if (desc != null) {
                outStream.writeBytes(desc.value().replace("_FUNC_", funcName));
                if (descFunc.isExtended()) {
                    Set<String> synonyms = FunctionRegistry.getFunctionSynonyms(funcName);
                    if (synonyms.size() > 0) {
                        outStream.writeBytes("\nSynonyms: " + StringUtils.join(synonyms, ", "));
                    }
                    if (desc.extended().length() > 0) {
                        outStream.writeBytes("\n" + desc.extended().replace("_FUNC_", funcName));
                    }
                }
            } else if (funcClass != null) {
                outStream.writeBytes("There is no documentation for function '" + funcName + "'");
            } else {
                outStream.writeBytes("Function '" + funcName + "' does not exist.");
            }
            outStream.write(10);
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.warn((Object)("describe function: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int showTableStatus(Hive db, showTableStatusDesc showTblStatus) throws HiveException {
        ArrayList<Table> tbls = new ArrayList<Table>();
        HashMap<String, String> part = showTblStatus.getPartSpec();
        Partition par = null;
        if (part != null) {
            Table tbl = db.getTable(showTblStatus.getDbName(), showTblStatus.getPattern());
            par = db.getPartition(tbl, part, false);
            tbls.add(tbl);
        } else {
            LOG.info((Object)("pattern: " + showTblStatus.getPattern()));
            List<String> tblStr = db.getTablesForDb(showTblStatus.getDbName(), showTblStatus.getPattern());
            TreeSet<String> sortedTbls = new TreeSet<String>(tblStr);
            for (String tblName : sortedTbls) {
                Table tbl = db.getTable(showTblStatus.getDbName(), tblName);
                tbls.add(tbl);
            }
            LOG.info((Object)("results : " + tblStr.size()));
        }
        try {
            FileSystem fs = showTblStatus.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(showTblStatus.getResFile());
            for (Table tbl : tbls) {
                String tableName = tbl.getName();
                String tblLoc = null;
                String inputFormattCls = null;
                String outputFormattCls = null;
                if (part != null) {
                    if (par != null) {
                        tblLoc = par.getDataLocation().toString();
                        inputFormattCls = par.getTPartition().getSd().getInputFormat();
                        outputFormattCls = par.getTPartition().getSd().getOutputFormat();
                    }
                } else {
                    tblLoc = tbl.getDataLocation().toString();
                    inputFormattCls = tbl.getInputFormatClass().getName();
                    outputFormattCls = tbl.getOutputFormatClass().getName();
                }
                String owner = tbl.getOwner();
                List<FieldSchema> cols = tbl.getCols();
                String ddlCols = MetaStoreUtils.getDDLFromFieldSchema((String)"columns", cols);
                boolean isPartitioned = tbl.isPartitioned();
                String partitionCols = "";
                if (isPartitioned) {
                    partitionCols = MetaStoreUtils.getDDLFromFieldSchema((String)"partition_columns", tbl.getPartCols());
                }
                outStream.writeBytes("tableName:" + tableName);
                outStream.write(10);
                outStream.writeBytes("owner:" + owner);
                outStream.write(10);
                outStream.writeBytes("location:" + tblLoc);
                outStream.write(10);
                outStream.writeBytes("inputformat:" + inputFormattCls);
                outStream.write(10);
                outStream.writeBytes("outputformat:" + outputFormattCls);
                outStream.write(10);
                outStream.writeBytes("columns:" + ddlCols);
                outStream.write(10);
                outStream.writeBytes("partitioned:" + isPartitioned);
                outStream.write(10);
                outStream.writeBytes("partitionColumns:" + partitionCols);
                outStream.write(10);
                Path tablLoc = tbl.getPath();
                ArrayList<Path> locations = new ArrayList<Path>();
                if (isPartitioned) {
                    if (par == null) {
                        for (Partition curPart : db.getPartitions(tbl)) {
                            locations.add(new Path(curPart.getTPartition().getSd().getLocation()));
                        }
                    } else {
                        locations.add(new Path(par.getTPartition().getSd().getLocation()));
                    }
                } else {
                    locations.add(tablLoc);
                }
                this.writeFileSystemStats((DataOutput)outStream, locations, tablLoc, false, 0);
                outStream.write(10);
            }
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("show table status: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private int describeTable(Hive db, descTableDesc descTbl) throws HiveException {
        String colPath;
        String tableName = colPath.substring(0, (colPath = descTbl.getTableName()).indexOf(46) == -1 ? colPath.length() : colPath.indexOf(46));
        Table tbl = db.getTable("default", tableName, false);
        Partition part = null;
        try {
            if (tbl == null) {
                FileSystem fs = descTbl.getResFile().getFileSystem((Configuration)this.conf);
                DataOutput outStream = (DataOutput)fs.open(descTbl.getResFile());
                String errMsg = "Table " + tableName + " does not exist";
                outStream.write(errMsg.getBytes("UTF-8"));
                ((FSDataOutputStream)outStream).close();
                return 0;
            }
            if (descTbl.getPartSpec() != null) {
                part = db.getPartition(tbl, descTbl.getPartSpec(), false);
                if (part == null) {
                    FileSystem fs = descTbl.getResFile().getFileSystem((Configuration)this.conf);
                    DataOutput outStream = (DataOutput)fs.open(descTbl.getResFile());
                    String errMsg = "Partition " + descTbl.getPartSpec() + " for table " + tableName + " does not exist";
                    outStream.write(errMsg.getBytes("UTF-8"));
                    ((FSDataOutputStream)outStream).close();
                    return 0;
                }
                tbl = part.getTable();
            }
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        try {
            LOG.info((Object)("DDLTask: got data for " + tbl.getName()));
            List cols = null;
            if (colPath.equals(tableName)) {
                cols = tbl.getCols();
                if (part != null) {
                    cols = part.getTPartition().getSd().getCols();
                }
            } else {
                cols = Hive.getFieldsFromDeserializer(colPath, tbl.getDeserializer());
            }
            FileSystem fs = descTbl.getResFile().getFileSystem((Configuration)this.conf);
            FSDataOutputStream outStream = fs.create(descTbl.getResFile());
            for (FieldSchema col : cols) {
                outStream.writeBytes(col.getName());
                outStream.write(9);
                outStream.writeBytes(col.getType());
                outStream.write(9);
                outStream.writeBytes(col.getComment() == null ? "" : col.getComment());
                outStream.write(10);
            }
            if (tableName.equals(colPath)) {
                List<FieldSchema> partCols = tbl.getPartCols();
                for (FieldSchema col : partCols) {
                    outStream.writeBytes(col.getName());
                    outStream.write(9);
                    outStream.writeBytes(col.getType());
                    outStream.write(9);
                    outStream.writeBytes(col.getComment() == null ? "" : col.getComment());
                    outStream.write(10);
                }
                if (descTbl.isExt()) {
                    outStream.write(10);
                    if (part != null) {
                        outStream.writeBytes("Detailed Partition Information");
                        outStream.write(9);
                        outStream.writeBytes(part.getTPartition().toString());
                        outStream.write(9);
                        outStream.write(10);
                    } else {
                        outStream.writeBytes("Detailed Table Information");
                        outStream.write(9);
                        outStream.writeBytes(tbl.getTTable().toString());
                        outStream.write(9);
                        outStream.write(10);
                    }
                }
            }
            LOG.info((Object)("DDLTask: written data for " + tbl.getName()));
            outStream.close();
        }
        catch (FileNotFoundException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (IOException e) {
            LOG.info((Object)("describe table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (Exception e) {
            throw new HiveException(e.toString());
        }
        return 0;
    }

    private void writeFileSystemStats(DataOutput outStream, List<Path> locations, Path tabLoc, boolean partSpecified, int indent) throws IOException {
        int k;
        long totalFileSize = 0L;
        long maxFileSize = 0L;
        long minFileSize = Long.MAX_VALUE;
        long lastAccessTime = 0L;
        long lastUpdateTime = 0L;
        int numOfFiles = 0;
        boolean unknown = false;
        FileSystem fs = tabLoc.getFileSystem((Configuration)this.conf);
        try {
            FileStatus tmpStatus = fs.getFileStatus(tabLoc);
            lastAccessTime = ShimLoader.getHadoopShims().getAccessTime(tmpStatus);
            lastUpdateTime = tmpStatus.getModificationTime();
            if (partSpecified) {
                tmpStatus = fs.getFileStatus(locations.get(0));
            }
        }
        catch (IOException e) {
            LOG.warn((Object)"Cannot access File System. File System status will be unknown: ", (Throwable)e);
            unknown = true;
        }
        if (!unknown) {
            for (Path loc : locations) {
                try {
                    FileStatus status = fs.getFileStatus(tabLoc);
                    FileStatus[] files = fs.listStatus(loc);
                    long accessTime = ShimLoader.getHadoopShims().getAccessTime(status);
                    long updateTime = status.getModificationTime();
                    if (!status.isDir()) continue;
                    if (accessTime > lastAccessTime) {
                        lastAccessTime = accessTime;
                    }
                    if (updateTime > lastUpdateTime) {
                        lastUpdateTime = updateTime;
                    }
                    for (FileStatus currentStatus : files) {
                        if (currentStatus.isDir()) continue;
                        ++numOfFiles;
                        long fileLen = currentStatus.getLen();
                        totalFileSize += fileLen;
                        if (fileLen > maxFileSize) {
                            maxFileSize = fileLen;
                        }
                        if (fileLen < minFileSize) {
                            minFileSize = fileLen;
                        }
                        accessTime = ShimLoader.getHadoopShims().getAccessTime(currentStatus);
                        updateTime = currentStatus.getModificationTime();
                        if (accessTime > lastAccessTime) {
                            lastAccessTime = accessTime;
                        }
                        if (updateTime <= lastUpdateTime) continue;
                        lastUpdateTime = updateTime;
                    }
                }
                catch (IOException e) {
                }
            }
        }
        String unknownString = "unknown";
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalNumberFiles:");
        outStream.writeBytes(unknown ? unknownString : "" + numOfFiles);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("totalFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + totalFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("maxFileSize:");
        outStream.writeBytes(unknown ? unknownString : "" + maxFileSize);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("minFileSize:");
        if (numOfFiles > 0) {
            outStream.writeBytes(unknown ? unknownString : "" + minFileSize);
        } else {
            outStream.writeBytes(unknown ? unknownString : "0");
        }
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastAccessTime:");
        outStream.writeBytes(unknown || lastAccessTime < 0L ? unknownString : "" + lastAccessTime);
        outStream.write(10);
        for (k = 0; k < indent; ++k) {
            outStream.writeBytes("  ");
        }
        outStream.writeBytes("lastUpdateTime:");
        outStream.writeBytes(unknown ? unknownString : "" + lastUpdateTime);
        outStream.write(10);
    }

    private int alterTable(Hive db, alterTableDesc alterTbl) throws HiveException {
        Table tbl = db.getTable("default", alterTbl.getOldName());
        Table oldTbl = tbl.copy();
        if (alterTbl.getOp() == alterTableDesc.alterTableTypes.RENAME) {
            tbl.getTTable().setTableName(alterTbl.getNewName());
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDCOLS) {
            List<FieldSchema> newCols = alterTbl.getNewCols();
            List<FieldSchema> oldCols = tbl.getCols();
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
                tbl.getTTable().getSd().setCols(newCols);
            } else {
                for (FieldSchema newCol : newCols) {
                    String newColName = newCol.getName();
                    Iterator<FieldSchema> iterOldCols = oldCols.iterator();
                    while (iterOldCols.hasNext()) {
                        String oldColName = iterOldCols.next().getName();
                        if (!oldColName.equalsIgnoreCase(newColName)) continue;
                        this.console.printError("Column '" + newColName + "' exists");
                        return 1;
                    }
                    oldCols.add(newCol);
                }
                tbl.getTTable().getSd().setCols(oldCols);
            }
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.RENAMECOLUMN) {
            List<FieldSchema> oldCols = tbl.getCols();
            ArrayList<FieldSchema> newCols = new ArrayList<FieldSchema>();
            Iterator<FieldSchema> iterOldCols = oldCols.iterator();
            String oldName = alterTbl.getOldColName();
            String newName = alterTbl.getNewColName();
            String type = alterTbl.getNewColType();
            String comment = alterTbl.getNewColComment();
            boolean first = alterTbl.getFirst();
            String afterCol = alterTbl.getAfterCol();
            FieldSchema column = null;
            boolean found = false;
            int position = -1;
            if (first) {
                position = 0;
            }
            int i = 1;
            while (iterOldCols.hasNext()) {
                FieldSchema col = iterOldCols.next();
                String oldColName = col.getName();
                if (oldColName.equalsIgnoreCase(newName) && !oldColName.equalsIgnoreCase(oldName)) {
                    this.console.printError("Column '" + newName + "' exists");
                    return 1;
                }
                if (oldColName.equalsIgnoreCase(oldName)) {
                    col.setName(newName);
                    if (type != null && !type.trim().equals("")) {
                        col.setType(type);
                    }
                    if (comment != null) {
                        col.setComment(comment);
                    }
                    found = true;
                    if (first || afterCol != null && !afterCol.trim().equals("")) {
                        column = col;
                        continue;
                    }
                }
                if (afterCol != null && !afterCol.trim().equals("") && oldColName.equalsIgnoreCase(afterCol)) {
                    position = i;
                }
                ++i;
                newCols.add(col);
            }
            if (!found) {
                this.console.printError("Column '" + oldName + "' does not exist");
                return 1;
            }
            if (afterCol != null && !afterCol.trim().equals("") && position < 0) {
                this.console.printError("Column '" + afterCol + "' does not exist");
                return 1;
            }
            if (position >= 0) {
                newCols.add(position, column);
            }
            tbl.getTTable().getSd().setCols(newCols);
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.REPLACECOLS) {
            if (tbl.getSerializationLib().equals("org.apache.hadoop.hive.serde.thrift.columnsetSerDe")) {
                this.console.printInfo("Replacing columns for columnsetSerDe and changing to LazySimpleSerDe");
                tbl.setSerializationLib(LazySimpleSerDe.class.getName());
            } else if (!(tbl.getSerializationLib().equals(MetadataTypedColumnsetSerDe.class.getName()) || tbl.getSerializationLib().equals(LazySimpleSerDe.class.getName()) || tbl.getSerializationLib().equals(ColumnarSerDe.class.getName()) || tbl.getSerializationLib().equals(DynamicSerDe.class.getName()))) {
                this.console.printError("Replace columns is not supported for this table. SerDe may be incompatible.");
                return 1;
            }
            tbl.getTTable().getSd().setCols(alterTbl.getNewCols());
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDPROPS) {
            tbl.getTTable().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDSERDEPROPS) {
            tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDSERDE) {
            tbl.setSerializationLib(alterTbl.getSerdeName());
            if (alterTbl.getProps() != null && alterTbl.getProps().size() > 0) {
                tbl.getTTable().getSd().getSerdeInfo().getParameters().putAll(alterTbl.getProps());
            }
            tbl.reinitSerDe();
            tbl.setFields(Hive.getFieldsFromDeserializer(tbl.getName(), tbl.getDeserializer()));
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDFILEFORMAT) {
            tbl.getTTable().getSd().setInputFormat(alterTbl.getInputFormat());
            tbl.getTTable().getSd().setOutputFormat(alterTbl.getOutputFormat());
            if (alterTbl.getSerdeName() != null) {
                tbl.setSerializationLib(alterTbl.getSerdeName());
            }
        } else if (alterTbl.getOp() == alterTableDesc.alterTableTypes.ADDCLUSTERSORTCOLUMN) {
            List<String> columns = Utilities.getColumnNamesFromFieldSchema(tbl.getCols());
            Utilities.validateColumnNames(columns, alterTbl.getBucketColumns());
            if (alterTbl.getSortColumns() != null) {
                Utilities.validateColumnNames(columns, Utilities.getColumnNamesFromSortCols(alterTbl.getSortColumns()));
            }
            tbl.getTTable().getSd().setBucketCols(alterTbl.getBucketColumns());
            tbl.getTTable().getSd().setNumBuckets(alterTbl.getNumberBuckets());
            tbl.getTTable().getSd().setSortCols(alterTbl.getSortColumns());
        } else {
            this.console.printError("Unsupported Alter commnad");
            return 1;
        }
        try {
            tbl.setProperty("last_modified_by", this.conf.getUser());
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        tbl.setProperty("last_modified_time", Long.toString(System.currentTimeMillis() / 1000L));
        try {
            tbl.checkValidity();
        }
        catch (HiveException e) {
            this.console.printError("Invalid table columns : " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        try {
            db.alterTable(alterTbl.getOldName(), tbl);
        }
        catch (InvalidOperationException e) {
            this.console.printError("Invalid alter operation: " + e.getMessage());
            LOG.info((Object)("alter table: " + org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e)));
            return 1;
        }
        catch (HiveException e) {
            return 1;
        }
        ((DDLWork)this.work).getInputs().add(new ReadEntity(oldTbl));
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int dropTable(Hive db, dropTableDesc dropTbl) throws HiveException {
        Table tbl = null;
        try {
            tbl = db.getTable("default", dropTbl.getTableName());
        }
        catch (InvalidTableException e) {
            // empty catch block
        }
        if (dropTbl.getPartSpecs() == null) {
            db.dropTable("default", dropTbl.getTableName());
            if (tbl != null) {
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
            }
        } else {
            List<String> partitionNames = db.getPartitionNames("default", dropTbl.getTableName(), (short)-1);
            HashSet<LinkedHashMap> partitions = new HashSet<LinkedHashMap>();
            for (int i = 0; i < partitionNames.size(); ++i) {
                try {
                    partitions.add(Warehouse.makeSpecFromName((String)partitionNames.get(i)));
                    continue;
                }
                catch (MetaException e) {
                    LOG.warn((Object)("Unrecognized partition name from metastore: " + partitionNames.get(i)));
                }
            }
            ArrayList<Partition> partsToDelete = new ArrayList<Partition>();
            for (Map<String, String> partSpec : dropTbl.getPartSpecs()) {
                Iterator it = partitions.iterator();
                while (it.hasNext()) {
                    Map part = (Map)it.next();
                    boolean match = true;
                    for (Map.Entry<String, String> item : partSpec.entrySet()) {
                        if (item.getValue().equals(part.get(item.getKey()))) continue;
                        match = false;
                        break;
                    }
                    if (!match) continue;
                    partsToDelete.add(db.getPartition(tbl, part, false));
                    it.remove();
                }
            }
            for (Partition partition : partsToDelete) {
                this.console.printInfo("Dropping the partition " + partition.getName());
                db.dropPartition("default", dropTbl.getTableName(), partition.getValues(), true);
                ((DDLWork)this.work).getOutputs().add(new WriteEntity(partition));
            }
        }
        return 0;
    }

    private void validateSerDe(String serdeName) throws HiveException {
        try {
            Deserializer d = SerDeUtils.lookupDeserializer(serdeName);
            if (d != null) {
                System.out.println("Found class for " + serdeName);
            }
        }
        catch (SerDeException e) {
            throw new HiveException("Cannot validate serde: " + serdeName, e);
        }
    }

    private int createTable(Hive db, createTableDesc crtTbl) throws HiveException {
        Table tbl = new Table(crtTbl.getTableName());
        StorageDescriptor tblStorDesc = tbl.getTTable().getSd();
        if (crtTbl.getBucketCols() != null) {
            tblStorDesc.setBucketCols(crtTbl.getBucketCols());
        }
        if (crtTbl.getSortCols() != null) {
            tbl.setSortCols(crtTbl.getSortCols());
        }
        if (crtTbl.getPartCols() != null) {
            tbl.setPartCols(crtTbl.getPartCols());
        }
        if (crtTbl.getNumBuckets() != -1) {
            tblStorDesc.setNumBuckets(crtTbl.getNumBuckets());
        }
        if (crtTbl.getSerName() != null) {
            tbl.setSerializationLib(crtTbl.getSerName());
            if (crtTbl.getMapProp() != null) {
                for (Map.Entry<String, String> m : crtTbl.getMapProp().entrySet()) {
                    tbl.setSerdeParam(m.getKey(), m.getValue());
                }
            }
        } else {
            if (crtTbl.getFieldDelim() != null) {
                tbl.setSerdeParam("field.delim", crtTbl.getFieldDelim());
                tbl.setSerdeParam("serialization.format", crtTbl.getFieldDelim());
            }
            if (crtTbl.getFieldEscape() != null) {
                tbl.setSerdeParam("escape.delim", crtTbl.getFieldEscape());
            }
            if (crtTbl.getCollItemDelim() != null) {
                tbl.setSerdeParam("colelction.delim", crtTbl.getCollItemDelim());
            }
            if (crtTbl.getMapKeyDelim() != null) {
                tbl.setSerdeParam("mapkey.delim", crtTbl.getMapKeyDelim());
            }
            if (crtTbl.getLineDelim() != null) {
                tbl.setSerdeParam("line.delim", crtTbl.getLineDelim());
            }
        }
        if (crtTbl.getSerName() == null) {
            LOG.info((Object)("Default to LazySimpleSerDe for table " + crtTbl.getTableName()));
            tbl.setSerializationLib(LazySimpleSerDe.class.getName());
        } else {
            this.validateSerDe(crtTbl.getSerName());
        }
        if (crtTbl.getComment() != null) {
            tbl.setProperty("comment", crtTbl.getComment());
        }
        if (crtTbl.getLocation() != null) {
            tblStorDesc.setLocation(crtTbl.getLocation());
        }
        tbl.setInputFormatClass(crtTbl.getInputFormat());
        tbl.setOutputFormatClass(crtTbl.getOutputFormat());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
        }
        if (tbl.getBucketCols() != null && tbl.getSortCols() != null) {
            List<String> bucketCols = tbl.getBucketCols();
            List<Order> sortCols = tbl.getSortCols();
            if (sortCols.size() > 0 && sortCols.size() >= bucketCols.size()) {
                boolean found = true;
                for (String bucketCol : bucketCols) {
                    boolean colFound = false;
                    for (int i = 0; i < bucketCols.size(); ++i) {
                        if (!bucketCol.equals(sortCols.get(i).getCol())) continue;
                        colFound = true;
                        break;
                    }
                    if (colFound) continue;
                    found = false;
                    break;
                }
                if (found) {
                    tbl.setProperty("SORTBUCKETCOLSPREFIX", "TRUE");
                }
            }
        }
        try {
            tbl.setOwner(this.conf.getUser());
        }
        catch (IOException e) {
            this.console.printError("Unable to get current user: " + e.getMessage(), org.apache.hadoop.util.StringUtils.stringifyException((Throwable)e));
            return 1;
        }
        tbl.getTTable().setCreateTime((int)(System.currentTimeMillis() / 1000L));
        if (crtTbl.getCols() != null) {
            tbl.setFields(crtTbl.getCols());
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    private int createTableLike(Hive db, createTableLikeDesc crtTbl) throws HiveException {
        Table tbl = db.getTable("default", crtTbl.getLikeTableName());
        StorageDescriptor tblStorDesc = tbl.getTTable().getSd();
        tbl.getTTable().setTableName(crtTbl.getTableName());
        if (crtTbl.isExternal()) {
            tbl.setProperty("EXTERNAL", "TRUE");
        } else {
            tbl.setProperty("EXTERNAL", "FALSE");
        }
        if (crtTbl.getLocation() != null) {
            tblStorDesc.setLocation(crtTbl.getLocation());
        } else {
            tblStorDesc.setLocation(null);
            tblStorDesc.unsetLocation();
        }
        db.createTable(tbl, crtTbl.getIfNotExists());
        ((DDLWork)this.work).getOutputs().add(new WriteEntity(tbl));
        return 0;
    }

    @Override
    public int getType() {
        return 2;
    }
}

