/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.runtime;

import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.internal.runtime.AdapterFactoryProxy;
import org.eclipse.core.internal.runtime.AdapterManager;
import org.eclipse.core.internal.runtime.IAdapterManagerProvider;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionDelta;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.IRegistryChangeListener;
import org.eclipse.core.runtime.RegistryFactory;

public final class AdapterManagerListener
implements IRegistryChangeListener,
IAdapterManagerProvider {
    public static final String ADAPTER_POINT_ID = "org.eclipse.core.runtime.adapters";
    private AdapterManager theAdapterManager = AdapterManager.getDefault();

    public AdapterManagerListener() {
        this.theAdapterManager.registerLazyFactoryProvider(this);
    }

    public boolean addFactories(AdapterManager adapterManager) {
        IExtensionPoint point = RegistryFactory.getRegistry().getExtensionPoint(ADAPTER_POINT_ID);
        if (point == null) {
            return false;
        }
        boolean factoriesAdded = false;
        IExtension[] extensions = point.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IConfigurationElement[] elements = extensions[i].getConfigurationElements();
            int j = 0;
            while (j < elements.length) {
                AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
                if (proxy != null) {
                    adapterManager.registerFactory(proxy, proxy.getAdaptableType());
                    factoriesAdded = true;
                }
                ++j;
            }
            ++i;
        }
        RegistryFactory.getRegistry().addRegistryChangeListener(this);
        return factoriesAdded;
    }

    private void registerExtension(IExtension extension) {
        IConfigurationElement[] elements = extension.getConfigurationElements();
        int j = 0;
        while (j < elements.length) {
            AdapterFactoryProxy proxy = AdapterFactoryProxy.createProxy(elements[j]);
            if (proxy != null) {
                this.theAdapterManager.registerFactory(proxy, proxy.getAdaptableType());
            }
            ++j;
        }
    }

    public synchronized void registryChanged(IRegistryChangeEvent event) {
        HashSet<String> toRemove = null;
        IExtensionDelta[] deltas = event.getExtensionDeltas();
        boolean found = false;
        int i = 0;
        while (i < deltas.length) {
            if (ADAPTER_POINT_ID.equals(deltas[i].getExtensionPoint().getUniqueIdentifier())) {
                found = true;
                if (deltas[i].getKind() == 1) {
                    this.registerExtension(deltas[i].getExtension());
                } else {
                    if (toRemove == null) {
                        toRemove = new HashSet<String>();
                    }
                    toRemove.add(deltas[i].getExtension().getUniqueIdentifier());
                }
            }
            ++i;
        }
        if (found) {
            this.theAdapterManager.flushLookup();
        }
        if (toRemove == null) {
            return;
        }
        Iterator it = this.theAdapterManager.getFactories().values().iterator();
        while (it.hasNext()) {
            Iterator it2 = ((List)it.next()).iterator();
            while (it2.hasNext()) {
                String ext;
                IAdapterFactory factory = (IAdapterFactory)it2.next();
                if (!(factory instanceof AdapterFactoryProxy) || !toRemove.contains(ext = ((AdapterFactoryProxy)factory).getOwnerId())) continue;
                it2.remove();
            }
        }
    }

    public synchronized void stop() {
        RegistryFactory.getRegistry().removeRegistryChangeListener(this);
    }
}

