/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.internal.jobs;

import org.eclipse.core.internal.jobs.InternalJob;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class JobQueue {
    private final InternalJob dummy = new InternalJob("Queue-Head"){

        public IStatus run(IProgressMonitor m) {
            return Status.OK_STATUS;
        }
    };
    private boolean allowConflictOvertaking;

    public JobQueue(boolean allowConflictOvertaking) {
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
        this.allowConflictOvertaking = allowConflictOvertaking;
    }

    public void clear() {
        this.dummy.setNext(this.dummy);
        this.dummy.setPrevious(this.dummy);
    }

    public InternalJob dequeue() {
        InternalJob toRemove = this.dummy.previous();
        if (toRemove == this.dummy) {
            return null;
        }
        return toRemove.remove();
    }

    public void enqueue(InternalJob newEntry) {
        Assert.isTrue(newEntry.next() == null);
        Assert.isTrue(newEntry.previous() == null);
        InternalJob tail = this.dummy.next();
        while (tail != this.dummy && tail.compareTo(newEntry) < 0 && (this.allowConflictOvertaking || !newEntry.isConflicting(tail))) {
            tail = tail.next();
        }
        InternalJob tailPrevious = tail.previous();
        newEntry.setNext(tail);
        newEntry.setPrevious(tailPrevious);
        tailPrevious.setNext(newEntry);
        tail.setPrevious(newEntry);
    }

    public void remove(InternalJob toRemove) {
        toRemove.remove();
    }

    public void resort(InternalJob entry) {
        this.remove(entry);
        this.enqueue(entry);
    }

    public boolean isEmpty() {
        return this.dummy.next() == this.dummy;
    }

    public InternalJob peek() {
        return this.dummy.previous() == this.dummy ? null : this.dummy.previous();
    }
}

