/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.framework;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.AccessController;
import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.PrivilegedAction;
import java.util.Dictionary;
import java.util.Hashtable;
import org.eclipse.osgi.framework.internal.core.AbstractBundle;
import org.eclipse.osgi.framework.internal.core.FilterImpl;
import org.osgi.framework.AdminPermissionCollection;
import org.osgi.framework.Bundle;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;

public final class AdminPermission
extends BasicPermission {
    static final long serialVersionUID = 207051004521261705L;
    public static final String CLASS = "class";
    public static final String EXECUTE = "execute";
    public static final String EXTENSIONLIFECYCLE = "extensionLifecycle";
    public static final String LIFECYCLE = "lifecycle";
    public static final String LISTENER = "listener";
    public static final String METADATA = "metadata";
    public static final String RESOLVE = "resolve";
    public static final String RESOURCE = "resource";
    public static final String STARTLEVEL = "startlevel";
    public static final String CONTEXT = "context";
    private static final int ACTION_CLASS = 1;
    private static final int ACTION_EXECUTE = 2;
    private static final int ACTION_LIFECYCLE = 4;
    private static final int ACTION_LISTENER = 8;
    private static final int ACTION_METADATA = 16;
    private static final int ACTION_RESOLVE = 64;
    private static final int ACTION_RESOURCE = 128;
    private static final int ACTION_STARTLEVEL = 256;
    private static final int ACTION_EXTENSIONLIFECYCLE = 512;
    private static final int ACTION_CONTEXT = 1024;
    private static final int ACTION_ALL = 2015;
    private static final int ACTION_NONE = 0;
    private boolean wildcard;
    private String filter;
    private String actions = null;
    private transient int action_mask = 0;
    private transient Bundle bundle;
    private transient Dictionary bundleProperties;
    private transient Filter filterImpl;

    public AdminPermission() {
        this("*", 2015);
    }

    public AdminPermission(String filter, String actions) {
        this(filter == null ? "*" : filter, AdminPermission.getMask(actions == null ? "*" : actions));
    }

    public AdminPermission(Bundle bundle, String actions) {
        super(AdminPermission.createName(bundle));
        this.bundle = bundle;
        this.wildcard = false;
        this.filter = null;
        this.action_mask = AdminPermission.getMask(actions);
    }

    private static String createName(Bundle bundle) {
        StringBuffer sb = new StringBuffer();
        sb.append("(id=");
        sb.append(bundle.getBundleId());
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof AdminPermission)) {
            return false;
        }
        AdminPermission a = (AdminPermission)obj;
        return this.action_mask == a.action_mask && this.wildcard == a.wildcard && (this.bundle == null ? a.bundle == null : a.bundle != null && this.bundle.getBundleId() == a.bundle.getBundleId()) && (this.filter == null ? a.filter == null : this.filter.equals(a.filter));
    }

    public int hashCode() {
        return this.getName().hashCode() ^ this.getActions().hashCode();
    }

    public String getActions() {
        if (this.actions == null) {
            StringBuffer sb = new StringBuffer();
            if ((this.action_mask & 1) == 1) {
                sb.append(CLASS);
                sb.append(',');
            }
            if ((this.action_mask & 2) == 2) {
                sb.append(EXECUTE);
                sb.append(',');
            }
            if ((this.action_mask & 0x200) == 512) {
                sb.append(EXTENSIONLIFECYCLE);
                sb.append(',');
            }
            if ((this.action_mask & 4) == 4) {
                sb.append(LIFECYCLE);
                sb.append(',');
            }
            if ((this.action_mask & 8) == 8) {
                sb.append(LISTENER);
                sb.append(',');
            }
            if ((this.action_mask & 0x10) == 16) {
                sb.append(METADATA);
                sb.append(',');
            }
            if ((this.action_mask & 0x40) == 64) {
                sb.append(RESOLVE);
                sb.append(',');
            }
            if ((this.action_mask & 0x80) == 128) {
                sb.append(RESOURCE);
                sb.append(',');
            }
            if ((this.action_mask & 0x100) == 256) {
                sb.append(STARTLEVEL);
                sb.append(',');
            }
            if ((this.action_mask & 0x400) == 1024) {
                sb.append(CONTEXT);
                sb.append(',');
            }
            if (sb.length() > 0) {
                sb.setLength(sb.length() - 1);
            }
            this.actions = sb.toString();
        }
        return this.actions;
    }

    public boolean implies(Permission p) {
        if (!(p instanceof AdminPermission)) {
            return false;
        }
        AdminPermission target = (AdminPermission)p;
        if ((this.action_mask & target.action_mask) != target.action_mask) {
            return false;
        }
        if (target.filter != null) {
            throw new RuntimeException("Cannot imply a filter");
        }
        if (target.wildcard) {
            return this.wildcard;
        }
        if (this.filter != null) {
            Filter filterImpl = this.getFilterImpl();
            return filterImpl != null && filterImpl.match(target.getProperties());
        }
        if (this.wildcard) {
            return true;
        }
        return this.bundle.equals(target.bundle);
    }

    public PermissionCollection newPermissionCollection() {
        return new AdminPermissionCollection();
    }

    AdminPermission(String filter, int action_mask) {
        super(filter);
        if (filter.equals("*")) {
            this.wildcard = true;
            this.filter = null;
        } else {
            this.wildcard = false;
            this.filter = filter;
        }
        this.bundle = null;
        this.action_mask = action_mask;
    }

    /*
     * Unable to fully structure code
     */
    private static int getMask(String actions) {
        seencomma = false;
        mask = 0;
        if (actions == null) {
            return mask;
        }
        a = actions.toCharArray();
        i = a.length - 1;
        if (i >= 0) ** GOTO lbl69
        return mask;
        {
            --i;
            do {
                if (i != -1 && ((c = a[i]) == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t')) continue block4;
                if (!(i < 4 || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'l' && a[i - 3] != 'L' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 's' && a[i - 1] != 'S' || a[i] != 's' && a[i] != 'S')) {
                    matchlen = 5;
                    mask |= 1;
                } else if (!(i < 6 || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 'x' && a[i - 5] != 'X' || a[i - 4] != 'e' && a[i - 4] != 'E' || a[i - 3] != 'c' && a[i - 3] != 'C' || a[i - 2] != 'u' && a[i - 2] != 'U' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 7;
                    mask |= 2;
                } else if (!(i < 17 || a[i - 17] != 'e' && a[i - 17] != 'E' || a[i - 16] != 'x' && a[i - 16] != 'X' || a[i - 15] != 't' && a[i - 15] != 'T' || a[i - 14] != 'e' && a[i - 14] != 'E' || a[i - 13] != 'n' && a[i - 13] != 'N' || a[i - 12] != 's' && a[i - 12] != 'S' || a[i - 11] != 'i' && a[i - 11] != 'I' || a[i - 10] != 'o' && a[i - 10] != 'O' || a[i - 9] != 'n' && a[i - 9] != 'N' || a[i - 8] != 'l' && a[i - 8] != 'L' || a[i - 7] != 'i' && a[i - 7] != 'I' || a[i - 6] != 'f' && a[i - 6] != 'F' || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'y' && a[i - 3] != 'Y' || a[i - 2] != 'c' && a[i - 2] != 'C' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 18;
                    mask |= 512;
                } else if (!(i < 8 || a[i - 8] != 'l' && a[i - 8] != 'L' || a[i - 7] != 'i' && a[i - 7] != 'I' || a[i - 6] != 'f' && a[i - 6] != 'F' || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 'c' && a[i - 4] != 'C' || a[i - 3] != 'y' && a[i - 3] != 'Y' || a[i - 2] != 'c' && a[i - 2] != 'C' || a[i - 1] != 'l' && a[i - 1] != 'L' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 9;
                    mask |= 4;
                } else if (!(i < 7 || a[i - 7] != 'l' && a[i - 7] != 'L' || a[i - 6] != 'i' && a[i - 6] != 'I' || a[i - 5] != 's' && a[i - 5] != 'S' || a[i - 4] != 't' && a[i - 4] != 'T' || a[i - 3] != 'e' && a[i - 3] != 'E' || a[i - 2] != 'n' && a[i - 2] != 'N' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 'r' && a[i] != 'R')) {
                    matchlen = 8;
                    mask |= 8;
                } else if (!(i < 7 || a[i - 7] != 'm' && a[i - 7] != 'M' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 't' && a[i - 5] != 'T' || a[i - 4] != 'a' && a[i - 4] != 'A' || a[i - 3] != 'd' && a[i - 3] != 'D' || a[i - 2] != 'a' && a[i - 2] != 'A' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'a' && a[i] != 'A')) {
                    matchlen = 8;
                    mask |= 16;
                } else if (!(i < 6 || a[i - 6] != 'r' && a[i - 6] != 'R' || a[i - 5] != 'e' && a[i - 5] != 'E' || a[i - 4] != 's' && a[i - 4] != 'S' || a[i - 3] != 'o' && a[i - 3] != 'O' || a[i - 2] != 'l' && a[i - 2] != 'L' || a[i - 1] != 'v' && a[i - 1] != 'V' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 7;
                    mask |= 64;
                } else if (!(i < 7 || a[i - 7] != 'r' && a[i - 7] != 'R' || a[i - 6] != 'e' && a[i - 6] != 'E' || a[i - 5] != 's' && a[i - 5] != 'S' || a[i - 4] != 'o' && a[i - 4] != 'O' || a[i - 3] != 'u' && a[i - 3] != 'U' || a[i - 2] != 'r' && a[i - 2] != 'R' || a[i - 1] != 'c' && a[i - 1] != 'C' || a[i] != 'e' && a[i] != 'E')) {
                    matchlen = 8;
                    mask |= 128;
                } else if (!(i < 9 || a[i - 9] != 's' && a[i - 9] != 'S' || a[i - 8] != 't' && a[i - 8] != 'T' || a[i - 7] != 'a' && a[i - 7] != 'A' || a[i - 6] != 'r' && a[i - 6] != 'R' || a[i - 5] != 't' && a[i - 5] != 'T' || a[i - 4] != 'l' && a[i - 4] != 'L' || a[i - 3] != 'e' && a[i - 3] != 'E' || a[i - 2] != 'v' && a[i - 2] != 'V' || a[i - 1] != 'e' && a[i - 1] != 'E' || a[i] != 'l' && a[i] != 'L')) {
                    matchlen = 10;
                    mask |= 256;
                } else if (!(i < 6 || a[i - 6] != 'c' && a[i - 6] != 'C' || a[i - 5] != 'o' && a[i - 5] != 'O' || a[i - 4] != 'n' && a[i - 4] != 'N' || a[i - 3] != 't' && a[i - 3] != 'T' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'x' && a[i - 1] != 'X' || a[i] != 't' && a[i] != 'T')) {
                    matchlen = 7;
                    mask |= 1024;
                } else if (i >= 0 && a[i] == '*') {
                    matchlen = 1;
                    mask |= 2015;
                } else {
                    throw new IllegalArgumentException("invalid permission: " + actions);
                }
                seencomma = false;
                while (i >= matchlen && !seencomma) {
                    switch (a[i - matchlen]) {
                        case ',': {
                            seencomma = true;
                        }
                        case '\t': 
                        case '\n': 
                        case '\f': 
                        case '\r': 
                        case ' ': {
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("invalid permission: " + actions);
                        }
                    }
                    --i;
                }
                i -= matchlen;
lbl69:
                // 2 sources

            } while (i != -1);
        }
        if (seencomma) {
            throw new IllegalArgumentException("invalid permission: " + actions);
        }
        return mask;
    }

    private Dictionary getProperties() {
        if (this.bundleProperties == null) {
            this.bundleProperties = new Hashtable();
            AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    AdminPermission.this.bundleProperties.put("id", new Long(AdminPermission.this.bundle.getBundleId()));
                    AdminPermission.this.bundleProperties.put("location", AdminPermission.this.bundle.getLocation());
                    if (AdminPermission.this.bundle.getSymbolicName() != null) {
                        AdminPermission.this.bundleProperties.put("name", AdminPermission.this.bundle.getSymbolicName());
                    }
                    AdminPermission.this.bundleProperties.put("signer", new SignerWrapper(AdminPermission.this.bundle));
                    return null;
                }
            });
        }
        return this.bundleProperties;
    }

    private Filter getFilterImpl() {
        if (this.filterImpl == null) {
            try {
                int pos = this.filter.indexOf("signer");
                if (pos != -1) {
                    StringBuffer filterBuf = new StringBuffer(this.filter);
                    int numAsteriskFound = 0;
                    while (pos != -1) {
                        int walkbackPos = pos - 1;
                        while (walkbackPos >= 0 && Character.isWhitespace(this.filter.charAt(walkbackPos))) {
                            --walkbackPos;
                        }
                        if (walkbackPos < 0) break;
                        if (this.filter.charAt(walkbackPos) != '(' || walkbackPos > 0 && this.filter.charAt(walkbackPos - 1) == '\\') {
                            pos = this.filter.indexOf("signer", pos + 6);
                            continue;
                        }
                        pos += 6;
                        while (Character.isWhitespace(this.filter.charAt(pos))) {
                            ++pos;
                        }
                        if (this.filter.charAt(pos) != '=') {
                            pos = this.filter.indexOf("signer", pos);
                            continue;
                        }
                        ++pos;
                        while (this.filter.charAt(pos) != ')' || this.filter.charAt(pos - 1) == '\\') {
                            if (this.filter.charAt(pos) == '*') {
                                filterBuf.insert(pos + numAsteriskFound, '\\');
                                ++numAsteriskFound;
                            }
                            ++pos;
                        }
                        pos = this.filter.indexOf("signer", pos);
                    }
                    this.filter = filterBuf.toString();
                }
                this.filterImpl = new FilterImpl(this.filter);
            }
            catch (InvalidSyntaxException invalidSyntaxException) {}
        }
        return this.filterImpl;
    }

    int getMask() {
        return this.action_mask;
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        if (this.actions == null) {
            this.getActions();
        }
        if (this.filter == null && !this.wildcard) {
            throw new UnsupportedOperationException("cannot serialize");
        }
        s.defaultWriteObject();
    }

    private synchronized void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.action_mask = AdminPermission.getMask(this.actions);
    }

    private static class SignerWrapper {
        private Bundle bundle;
        private String pattern;

        public SignerWrapper(String pattern) {
            this.pattern = pattern;
        }

        SignerWrapper(Bundle bundle) {
            this.bundle = bundle;
        }

        public boolean equals(Object o) {
            if (!(o instanceof SignerWrapper)) {
                return false;
            }
            SignerWrapper other = (SignerWrapper)o;
            AbstractBundle matchBundle = (AbstractBundle)(this.bundle != null ? this.bundle : other.bundle);
            String matchPattern = this.bundle != null ? other.pattern : this.pattern;
            return matchBundle.getBundleData().matchDNChain(matchPattern);
        }
    }
}

