/*
 * Decompiled with CFR 0.152.
 */
package py4j.commands;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import py4j.Gateway;
import py4j.Protocol;
import py4j.Py4JException;
import py4j.ReturnObject;
import py4j.commands.Command;

public abstract class AbstractCommand
implements Command {
    protected Gateway gateway;
    protected String commandName;
    private final Logger logger = Logger.getLogger(AbstractCommand.class.getName());

    @Override
    public abstract void execute(String var1, BufferedReader var2, BufferedWriter var3) throws Py4JException, IOException;

    protected List<Object> getArguments(BufferedReader reader) throws IOException {
        ArrayList<Object> arguments = new ArrayList<Object>();
        List<String> stringArguments = this.getStringArguments(reader);
        for (String stringArgument : stringArguments) {
            arguments.add(Protocol.getObject(stringArgument, this.gateway));
        }
        return arguments;
    }

    @Override
    public String getCommandName() {
        return this.commandName;
    }

    protected List<String> getStringArguments(BufferedReader reader) throws IOException {
        ArrayList<String> arguments = new ArrayList<String>();
        String line = reader.readLine();
        while (!Protocol.isEmpty(line) && !Protocol.isEnd(line)) {
            this.logger.finest("Raw String Argument: " + line);
            arguments.add(line);
            line = reader.readLine();
        }
        return arguments;
    }

    @Override
    public void init(Gateway gateway) {
        this.gateway = gateway;
    }

    protected ReturnObject invokeMethod(String methodName, String targetObjectId, List<Object> arguments) {
        ReturnObject returnObject = null;
        try {
            returnObject = this.gateway.invoke(methodName, targetObjectId, arguments);
        }
        catch (Exception e) {
            this.logger.log(Level.FINE, "Received exception while executing this command: " + methodName, e);
            returnObject = ReturnObject.getErrorReturnObject(e);
        }
        return returnObject;
    }
}

