/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.piggybank.storage;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.serializer.SerializationFactory;
import org.apache.hadoop.mapreduce.InputFormat;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.RecordReader;
import org.apache.hadoop.mapreduce.lib.input.FileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileInputFormat;
import org.apache.hadoop.mapreduce.lib.input.SequenceFileRecordReader;
import org.apache.pig.FileInputLoadFunc;
import org.apache.pig.backend.BackendException;
import org.apache.pig.backend.hadoop.DateTimeWritable;
import org.apache.pig.backend.hadoop.executionengine.mapReduceLayer.PigSplit;
import org.apache.pig.data.DataByteArray;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class SequenceFileLoader
extends FileInputLoadFunc {
    private SequenceFileRecordReader<Writable, Writable> reader;
    private Writable key;
    private Writable value;
    private ArrayList<Object> mProtoTuple = null;
    protected static final Log LOG = LogFactory.getLog(SequenceFileLoader.class);
    protected TupleFactory mTupleFactory = TupleFactory.getInstance();
    protected SerializationFactory serializationFactory;
    protected byte keyType = 0;
    protected byte valType = 0;

    public SequenceFileLoader() {
        this.mProtoTuple = new ArrayList(2);
    }

    protected void setKeyType(Class<?> keyClass) throws BackendException {
        this.keyType = (byte)(this.keyType | this.inferPigDataType(keyClass));
        if (this.keyType == -1) {
            LOG.warn((Object)("Unable to translate key " + this.key.getClass() + " to a Pig datatype"));
            throw new BackendException("Unable to translate " + this.key.getClass() + " to a Pig datatype");
        }
    }

    protected void setValueType(Class<?> valueClass) throws BackendException {
        this.valType = (byte)(this.valType | this.inferPigDataType(valueClass));
        if (this.keyType == -1) {
            LOG.warn((Object)("Unable to translate key " + this.key.getClass() + " to a Pig datatype"));
            throw new BackendException("Unable to translate " + this.key.getClass() + " to a Pig datatype");
        }
    }

    protected byte inferPigDataType(Type t) {
        if (t == DataByteArray.class) {
            return 50;
        }
        if (t == Text.class) {
            return 55;
        }
        if (t == IntWritable.class) {
            return 10;
        }
        if (t == LongWritable.class) {
            return 15;
        }
        if (t == FloatWritable.class) {
            return 20;
        }
        if (t == DoubleWritable.class) {
            return 25;
        }
        if (t == BooleanWritable.class) {
            return 5;
        }
        if (t == ByteWritable.class) {
            return 6;
        }
        if (t == DateTimeWritable.class) {
            return 30;
        }
        return -1;
    }

    protected Object translateWritableToPigDataType(Writable w, byte dataType) {
        switch (dataType) {
            case 55: {
                return ((Text)w).toString();
            }
            case 50: {
                return ((DataByteArray)w).get();
            }
            case 5: {
                return ((BooleanWritable)w).get();
            }
            case 10: {
                return ((IntWritable)w).get();
            }
            case 15: {
                return ((LongWritable)w).get();
            }
            case 20: {
                return Float.valueOf(((FloatWritable)w).get());
            }
            case 25: {
                return ((DoubleWritable)w).get();
            }
            case 6: {
                return ((ByteWritable)w).get();
            }
            case 30: {
                return ((DateTimeWritable)w).get();
            }
        }
        return null;
    }

    public Tuple getNext() throws IOException {
        boolean next = false;
        try {
            next = this.reader.nextKeyValue();
        }
        catch (InterruptedException e) {
            throw new IOException(e);
        }
        if (!next) {
            return null;
        }
        this.key = (Writable)this.reader.getCurrentKey();
        this.value = (Writable)this.reader.getCurrentValue();
        if (this.keyType == 0 && this.key != null) {
            this.setKeyType(this.key.getClass());
        }
        if (this.valType == 0 && this.value != null) {
            this.setValueType(this.value.getClass());
        }
        this.mProtoTuple.add(this.translateWritableToPigDataType(this.key, this.keyType));
        this.mProtoTuple.add(this.translateWritableToPigDataType(this.value, this.valType));
        Tuple t = this.mTupleFactory.newTuple(this.mProtoTuple);
        this.mProtoTuple.clear();
        return t;
    }

    public InputFormat getInputFormat() throws IOException {
        return new SequenceFileInputFormat();
    }

    public void prepareToRead(RecordReader reader, PigSplit split) throws IOException {
        this.reader = (SequenceFileRecordReader)reader;
    }

    public void setLocation(String location, Job job) throws IOException {
        FileInputFormat.setInputPaths((Job)job, (String)location);
    }
}

