/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.metadata;

public class HiveUtils {
    public static final char QUOTE = '\"';
    public static final char COLON = ':';
    public static final String LBRACKET = "[";
    public static final String RBRACKET = "]";
    public static final String LBRACE = "{";
    public static final String RBRACE = "}";

    public static String escapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block8: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    escape.append('\\');
                    escape.append(c);
                    continue block8;
                }
                case '\b': {
                    escape.append('\\');
                    escape.append('b');
                    continue block8;
                }
                case '\f': {
                    escape.append('\\');
                    escape.append('f');
                    continue block8;
                }
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block8;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block8;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block8;
                }
                default: {
                    if (c < ' ') {
                        String hex = Integer.toHexString(c);
                        escape.append('\\');
                        escape.append('u');
                        for (int j = 4; j > hex.length(); --j) {
                            escape.append('0');
                        }
                        escape.append(hex);
                        continue block8;
                    }
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }

    public static String lightEscapeString(String str) {
        int length = str.length();
        StringBuilder escape = new StringBuilder(length + 16);
        block5: for (int i = 0; i < length; ++i) {
            char c = str.charAt(i);
            switch (c) {
                case '\n': {
                    escape.append('\\');
                    escape.append('n');
                    continue block5;
                }
                case '\r': {
                    escape.append('\\');
                    escape.append('r');
                    continue block5;
                }
                case '\t': {
                    escape.append('\\');
                    escape.append('t');
                    continue block5;
                }
                default: {
                    escape.append(c);
                }
            }
        }
        return escape.toString();
    }
}

