/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.plan;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.mapredLocalWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.ql.plan.tableDesc;

@explain(displayName="Map Reduce")
public class mapredWork
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String command;
    private LinkedHashMap<String, ArrayList<String>> pathToAliases;
    private LinkedHashMap<String, partitionDesc> pathToPartitionInfo;
    private LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork;
    private LinkedHashMap<String, partitionDesc> aliasToPartnInfo;
    private tableDesc keyDesc;
    private List<tableDesc> tagToValueDesc;
    private Operator<?> reducer;
    private Integer numReduceTasks;
    private boolean needsTagging;
    private mapredLocalWork mapLocalWork;

    public mapredWork() {
        this.aliasToPartnInfo = new LinkedHashMap();
    }

    public mapredWork(String command, LinkedHashMap<String, ArrayList<String>> pathToAliases, LinkedHashMap<String, partitionDesc> pathToPartitionInfo, LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork, tableDesc keyDesc, List<tableDesc> tagToValueDesc, Operator<?> reducer, Integer numReduceTasks, mapredLocalWork mapLocalWork) {
        this.command = command;
        this.pathToAliases = pathToAliases;
        this.pathToPartitionInfo = pathToPartitionInfo;
        this.aliasToWork = aliasToWork;
        this.keyDesc = keyDesc;
        this.tagToValueDesc = tagToValueDesc;
        this.reducer = reducer;
        this.numReduceTasks = numReduceTasks;
        this.mapLocalWork = mapLocalWork;
        this.aliasToPartnInfo = new LinkedHashMap();
    }

    public String getCommand() {
        return this.command;
    }

    public void setCommand(String command) {
        this.command = command;
    }

    @explain(displayName="Path -> Alias", normalExplain=false)
    public LinkedHashMap<String, ArrayList<String>> getPathToAliases() {
        return this.pathToAliases;
    }

    public void setPathToAliases(LinkedHashMap<String, ArrayList<String>> pathToAliases) {
        this.pathToAliases = pathToAliases;
    }

    @explain(displayName="Path -> Partition", normalExplain=false)
    public LinkedHashMap<String, partitionDesc> getPathToPartitionInfo() {
        return this.pathToPartitionInfo;
    }

    public void setPathToPartitionInfo(LinkedHashMap<String, partitionDesc> pathToPartitionInfo) {
        this.pathToPartitionInfo = pathToPartitionInfo;
    }

    public LinkedHashMap<String, partitionDesc> getAliasToPartnInfo() {
        return this.aliasToPartnInfo;
    }

    public void setAliasToPartnInfo(LinkedHashMap<String, partitionDesc> aliasToPartnInfo) {
        this.aliasToPartnInfo = aliasToPartnInfo;
    }

    @explain(displayName="Alias -> Map Operator Tree")
    public LinkedHashMap<String, Operator<? extends Serializable>> getAliasToWork() {
        return this.aliasToWork;
    }

    public void setAliasToWork(LinkedHashMap<String, Operator<? extends Serializable>> aliasToWork) {
        this.aliasToWork = aliasToWork;
    }

    @explain(displayName="Local Work")
    public mapredLocalWork getMapLocalWork() {
        return this.mapLocalWork;
    }

    public void setMapLocalWork(mapredLocalWork mapLocalWork) {
        this.mapLocalWork = mapLocalWork;
    }

    public tableDesc getKeyDesc() {
        return this.keyDesc;
    }

    public void setKeyDesc(tableDesc keyDesc) {
        this.keyDesc = keyDesc;
    }

    public List<tableDesc> getTagToValueDesc() {
        return this.tagToValueDesc;
    }

    public void setTagToValueDesc(List<tableDesc> tagToValueDesc) {
        this.tagToValueDesc = tagToValueDesc;
    }

    @explain(displayName="Reduce Operator Tree")
    public Operator<?> getReducer() {
        return this.reducer;
    }

    public void setReducer(Operator<?> reducer) {
        this.reducer = reducer;
    }

    public Integer getNumReduceTasks() {
        return this.numReduceTasks;
    }

    public void setNumReduceTasks(Integer numReduceTasks) {
        this.numReduceTasks = numReduceTasks;
    }

    public void addMapWork(String path, String alias, Operator<?> work, partitionDesc pd) {
        ArrayList<String> curAliases = this.pathToAliases.get(path);
        if (curAliases == null) {
            assert (this.pathToPartitionInfo.get(path) == null);
            curAliases = new ArrayList();
            this.pathToAliases.put(path, curAliases);
            this.pathToPartitionInfo.put(path, pd);
        } else assert (this.pathToPartitionInfo.get(path) != null);
        for (String oneAlias : curAliases) {
            if (!oneAlias.equals(alias)) continue;
            throw new RuntimeException("Multiple aliases named: " + alias + " for path: " + path);
        }
        curAliases.add(alias);
        if (this.aliasToWork.get(alias) != null) {
            throw new RuntimeException("Existing work for alias: " + alias);
        }
        this.aliasToWork.put(alias, work);
    }

    public String isInvalid() {
        if (this.getNumReduceTasks() >= 1 && this.getReducer() == null) {
            return "Reducers > 0 but no reduce operator";
        }
        if (this.getNumReduceTasks() == 0 && this.getReducer() != null) {
            return "Reducers == 0 but reduce operator specified";
        }
        return null;
    }

    public String toXML() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        Utilities.serializeMapRedWork(this, baos);
        return baos.toString();
    }

    private void setAliases() {
        for (String oneAlias : this.aliasToWork.keySet()) {
            this.aliasToWork.get(oneAlias).setAlias(oneAlias);
        }
    }

    public void deriveExplainAttributes() {
        if (this.pathToPartitionInfo == null) {
            return;
        }
        for (Map.Entry<String, partitionDesc> entry : this.pathToPartitionInfo.entrySet()) {
            entry.getValue().deriveBaseFileName(entry.getKey());
        }
    }

    public void initialize() {
        this.setAliases();
    }

    @explain(displayName="Needs Tagging", normalExplain=false)
    public boolean getNeedsTagging() {
        return this.needsTagging;
    }

    public void setNeedsTagging(boolean needsTagging) {
        this.needsTagging = needsTagging;
    }
}

