/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf;

import java.util.Arrays;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.exec.description;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.Text;

@description(name="space", value="_FUNC_(n) - returns n spaces", extended="Example:\n   > SELECT _FUNC_(2) FROM src LIMIT 1;\n  '  '")
public class UDFSpace
extends UDF {
    private Text result = new Text();

    public Text evaluate(IntWritable n) {
        if (n == null) {
            return null;
        }
        int len = n.get();
        if (len < 0) {
            len = 0;
        }
        if (this.result.getBytes().length >= len) {
            this.result.set(this.result.getBytes(), 0, len);
        } else {
            byte[] spaces = new byte[len];
            Arrays.fill(spaces, (byte)32);
            this.result.set(spaces);
        }
        return this.result;
    }
}

