/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.util.jdbm.recman;

import java.io.File;
import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManager;
import org.apache.hadoop.hive.ql.util.jdbm.RecordManagerProvider;
import org.apache.hadoop.hive.ql.util.jdbm.helper.MRU;
import org.apache.hadoop.hive.ql.util.jdbm.recman.BaseRecordManager;
import org.apache.hadoop.hive.ql.util.jdbm.recman.CacheRecordManager;

public final class Provider
implements RecordManagerProvider {
    @Override
    public RecordManager createRecordManager(String name, Properties options) throws IOException {
        RecordManager recman = new BaseRecordManager(name);
        recman = this.getCachedRecordManager(recman, options);
        return recman;
    }

    private RecordManager getCachedRecordManager(RecordManager recman, Properties options) {
        String value = options.getProperty("jdbm.disableTransactions", "false");
        if (value.equalsIgnoreCase("TRUE")) {
            ((BaseRecordManager)recman).disableTransactions();
        }
        value = options.getProperty("jdbm.cache.size", "1000");
        int cacheSize = Integer.parseInt(value);
        value = options.getProperty("jdbm.cache.type", "normal");
        if (value.equalsIgnoreCase("normal")) {
            MRU cache = new MRU(cacheSize);
            recman = new CacheRecordManager(recman, cache);
        } else {
            if (value.equalsIgnoreCase("soft")) {
                throw new IllegalArgumentException("Soft reference cache not implemented");
            }
            if (value.equalsIgnoreCase("weak")) {
                throw new IllegalArgumentException("Weak reference cache not implemented");
            }
            if (!value.equalsIgnoreCase("nocache")) {
                throw new IllegalArgumentException("Invalid cache type: " + value);
            }
        }
        return recman;
    }

    @Override
    public RecordManager createRecordManager(File file, Properties options) throws IOException {
        RecordManager recman = new BaseRecordManager(file);
        recman = this.getCachedRecordManager(recman, options);
        return recman;
    }
}

