/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.shims;

import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.hive.shims.HadoopShims;
import org.apache.hadoop.hive.shims.JettyShims;
import org.apache.hadoop.util.VersionInfo;

public abstract class ShimLoader {
    private static HadoopShims hadoopShims;
    private static JettyShims jettyShims;
    private static HashMap<String, String> HADOOP_SHIM_CLASSES;
    private static HashMap<String, String> JETTY_SHIM_CLASSES;

    public static synchronized HadoopShims getHadoopShims() {
        if (hadoopShims == null) {
            hadoopShims = ShimLoader.loadShims(HADOOP_SHIM_CLASSES, HadoopShims.class);
        }
        return hadoopShims;
    }

    public static synchronized JettyShims getJettyShims() {
        if (jettyShims == null) {
            jettyShims = ShimLoader.loadShims(JETTY_SHIM_CLASSES, JettyShims.class);
        }
        return jettyShims;
    }

    private static <T> T loadShims(Map<String, String> classMap, Class<T> xface) {
        String vers = ShimLoader.getMajorVersion();
        String className = classMap.get(vers);
        try {
            Class<?> clazz = Class.forName(className);
            return xface.cast(clazz.newInstance());
        }
        catch (Exception e) {
            throw new RuntimeException("Could not load shims in class " + className, e);
        }
    }

    private static String getMajorVersion() {
        String vers = VersionInfo.getVersion();
        String[] parts = vers.split("\\.");
        if (parts.length < 2) {
            throw new RuntimeException("Illegal Hadoop Version: " + vers + " (expected A.B.* format)");
        }
        String majorVersion = parts[0] + "." + parts[1];
        try {
            Class.forName("org.apache.hadoop.security.UnixUserGroupInformation");
        }
        catch (ClassNotFoundException cnf) {
            majorVersion = majorVersion + "S";
        }
        return majorVersion;
    }

    static {
        HADOOP_SHIM_CLASSES = new HashMap();
        HADOOP_SHIM_CLASSES.put("0.17", "org.apache.hadoop.hive.shims.Hadoop17Shims");
        HADOOP_SHIM_CLASSES.put("0.18", "org.apache.hadoop.hive.shims.Hadoop18Shims");
        HADOOP_SHIM_CLASSES.put("0.19", "org.apache.hadoop.hive.shims.Hadoop19Shims");
        HADOOP_SHIM_CLASSES.put("0.20", "org.apache.hadoop.hive.shims.Hadoop20Shims");
        HADOOP_SHIM_CLASSES.put("0.20S", "org.apache.hadoop.hive.shims.Hadoop20SShims");
        JETTY_SHIM_CLASSES = new HashMap();
        JETTY_SHIM_CLASSES.put("0.17", "org.apache.hadoop.hive.shims.Jetty17Shims");
        JETTY_SHIM_CLASSES.put("0.18", "org.apache.hadoop.hive.shims.Jetty18Shims");
        JETTY_SHIM_CLASSES.put("0.19", "org.apache.hadoop.hive.shims.Jetty19Shims");
        JETTY_SHIM_CLASSES.put("0.20", "org.apache.hadoop.hive.shims.Jetty20Shims");
        JETTY_SHIM_CLASSES.put("0.20S", "org.apache.hadoop.hive.shims.Jetty20SShims");
    }
}

