/*
 * Decompiled with CFR 0.152.
 */
package org.datanucleus.store.rdbms.sql.expression;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.datanucleus.ClassLoaderResolver;
import org.datanucleus.ObjectManager;
import org.datanucleus.StateManager;
import org.datanucleus.metadata.AbstractClassMetaData;
import org.datanucleus.metadata.AbstractMemberMetaData;
import org.datanucleus.store.fieldmanager.FieldManager;
import org.datanucleus.store.fieldmanager.SingleValueFieldManager;
import org.datanucleus.store.mapped.DatastoreClass;
import org.datanucleus.store.mapped.MappedStoreManager;
import org.datanucleus.store.mapped.mapping.EmbeddedMapping;
import org.datanucleus.store.mapped.mapping.JavaTypeMapping;
import org.datanucleus.store.mapped.mapping.PersistenceCapableMapping;
import org.datanucleus.store.rdbms.RDBMSManager;
import org.datanucleus.store.rdbms.adapter.DatabaseAdapter;
import org.datanucleus.store.rdbms.sql.SQLStatement;
import org.datanucleus.store.rdbms.sql.expression.BooleanExpression;
import org.datanucleus.store.rdbms.sql.expression.CharacterLiteral;
import org.datanucleus.store.rdbms.sql.expression.ColumnExpression;
import org.datanucleus.store.rdbms.sql.expression.NumericExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpression;
import org.datanucleus.store.rdbms.sql.expression.SQLExpressionFactory;
import org.datanucleus.store.rdbms.sql.expression.SQLLiteral;
import org.datanucleus.store.rdbms.sql.expression.StringExpression;
import org.datanucleus.store.rdbms.sql.expression.StringLiteral;
import org.datanucleus.util.ClassUtils;
import org.datanucleus.util.StringUtils;

public class ExpressionUtils {
    public static NumericExpression getNumericExpression(SQLExpression expr) {
        RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        SQLExpressionFactory factory = storeMgr.getSQLExpressionFactory();
        DatabaseAdapter dba = expr.getSQLStatement().getDatabaseAdapter();
        if (expr instanceof CharacterLiteral) {
            char c = ((Character)((CharacterLiteral)expr).getValue()).charValue();
            BigInteger value = new BigInteger("" + c);
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        if (expr instanceof SQLLiteral) {
            BigInteger value = new BigInteger((String)((SQLLiteral)((Object)expr)).getValue());
            return (NumericExpression)factory.newLiteral(expr.getSQLStatement(), storeMgr.getMappingManager().getMapping(value.getClass()), value);
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        return new NumericExpression(expr.getJavaTypeMapping(), dba.getNumericConversionFunction(), args);
    }

    public static SQLExpression getLiteralForOne(SQLStatement stmt) {
        RDBMSManager storeMgr = stmt.getRDBMSManager();
        JavaTypeMapping mapping = storeMgr.getMappingManager().getMapping(BigInteger.class);
        return storeMgr.getSQLExpressionFactory().newLiteral(stmt, mapping, BigInteger.ONE);
    }

    public static StringExpression getStringExpression(SQLExpression expr) {
        RDBMSManager storeMgr = expr.getSQLStatement().getRDBMSManager();
        JavaTypeMapping m = storeMgr.getSQLExpressionFactory().getMappingForType(String.class, false);
        if (expr instanceof SQLLiteral) {
            return new StringLiteral(expr.getSQLStatement(), m, ((SQLLiteral)((Object)expr)).getValue().toString(), false);
        }
        ArrayList<SQLExpression> args = new ArrayList<SQLExpression>();
        args.add(expr);
        ArrayList<String> types = new ArrayList<String>();
        types.add("VARCHAR(4000)");
        return new StringExpression(m, "CAST", args, (List)types);
    }

    public static SQLExpression getEscapedPatternExpression(SQLExpression patternExpr) {
        if (patternExpr instanceof StringLiteral) {
            String value = (String)((StringLiteral)patternExpr).getValue();
            value = StringUtils.replaceAll((String)value, (String)"\\", (String)"\\\\");
            value = StringUtils.replaceAll((String)value, (String)"%", (String)"\\%");
            value = StringUtils.replaceAll((String)value, (String)"_", (String)"\\_");
            SQLExpressionFactory exprFactory = patternExpr.getSQLStatement().getSQLExpressionFactory();
            JavaTypeMapping m = exprFactory.getMappingForType(String.class, false);
            return exprFactory.newLiteral(patternExpr.getSQLStatement(), m, value);
        }
        return patternExpr;
    }

    public static int populatePrimaryKeyMappingsValuesForPCMapping(JavaTypeMapping[] pkMappings, Object[] pkFieldValues, int position, PersistenceCapableMapping pcMapping, AbstractClassMetaData cmd, AbstractMemberMetaData mmd, Object fieldValue, MappedStoreManager storeMgr, ClassLoaderResolver clr) {
        ObjectManager om = storeMgr.getApiAdapter().getObjectManager(fieldValue);
        JavaTypeMapping[] subMappings = pcMapping.getJavaTypeMapping();
        if (subMappings.length == 0) {
            DatastoreClass table = storeMgr.getDatastoreClass(cmd.getFullClassName(), clr);
            JavaTypeMapping ownerMapping = table.getMemberMapping(mmd);
            EmbeddedMapping embMapping = (EmbeddedMapping)ownerMapping;
            for (int k = 0; k < embMapping.getNumberOfJavaTypeMappings(); ++k) {
                JavaTypeMapping subMapping;
                pkMappings[position] = subMapping = embMapping.getJavaTypeMapping(k);
                pkFieldValues[position] = ExpressionUtils.getValueForMemberOfObject(om, subMapping.getMemberMetaData(), fieldValue);
                ++position;
            }
        } else {
            AbstractClassMetaData pcCmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcMapping.getType(), clr);
            int[] pcPkPositions = pcCmd.getPKMemberPositions();
            for (int k = 0; k < subMappings.length; ++k) {
                Object val;
                AbstractMemberMetaData pcMmd = pcCmd.getMetaDataForManagedMemberAtAbsolutePosition(pcPkPositions[k]);
                if (subMappings[k] instanceof PersistenceCapableMapping) {
                    val = ExpressionUtils.getValueForMemberOfObject(om, pcMmd, fieldValue);
                    position = ExpressionUtils.populatePrimaryKeyMappingsValuesForPCMapping(pkMappings, pkFieldValues, position, (PersistenceCapableMapping)subMappings[k], pcCmd, pcMmd, val, storeMgr, clr);
                    continue;
                }
                val = ExpressionUtils.getValueForMemberOfObject(om, pcMmd, fieldValue);
                pkMappings[position] = subMappings[k];
                pkFieldValues[position] = val;
                ++position;
            }
        }
        return position;
    }

    public static Object getValueForMemberOfObject(ObjectManager om, AbstractMemberMetaData mmd, Object object) {
        if (om == null) {
            return ClassUtils.getValueOfFieldByReflection((Object)object, (String)mmd.getName());
        }
        StateManager sm = om.findStateManager(object);
        if (!mmd.isPrimaryKey()) {
            om.getApiAdapter().isLoaded(sm, mmd.getAbsoluteFieldNumber());
        }
        SingleValueFieldManager fm = new SingleValueFieldManager();
        sm.provideFields(new int[]{mmd.getAbsoluteFieldNumber()}, (FieldManager)fm);
        return fm.fetchObjectField(mmd.getAbsoluteFieldNumber());
    }

    public static BooleanExpression getAppIdEqualityExpression(Object id, SQLExpression expr, MappedStoreManager storeMgr, ClassLoaderResolver clr, AbstractClassMetaData acmd, Integer index, BooleanExpression bExpr) {
        if (index == null) {
            index = new Integer(0);
        }
        String[] pkFieldNames = acmd.getPrimaryKeyMemberNames();
        for (int i = 0; i < pkFieldNames.length; ++i) {
            Object value = ClassUtils.getValueOfFieldByReflection((Object)id, (String)pkFieldNames[i]);
            String pcClassName = storeMgr.getClassNameForObjectID(value, clr, null);
            if (pcClassName != null) {
                AbstractClassMetaData scmd = storeMgr.getOMFContext().getMetaDataManager().getMetaDataForClass(pcClassName, clr);
                if (bExpr == null) {
                    bExpr = ExpressionUtils.getAppIdEqualityExpression(value, expr, storeMgr, clr, scmd, index, bExpr);
                    continue;
                }
                bExpr = bExpr.and(ExpressionUtils.getAppIdEqualityExpression(value, expr, storeMgr, clr, scmd, index, bExpr));
                continue;
            }
            ColumnExpression source = expr.subExprs.getExpression(index);
            JavaTypeMapping mapping = storeMgr.getMappingManager().getMappingWithDatastoreMapping(value.getClass(), false, false, clr);
            SQLExpression target = expr.getSQLStatement().getSQLExpressionFactory().newLiteral(expr.getSQLStatement(), mapping, value);
            bExpr = bExpr == null ? ((SQLExpression)source).eq(target) : bExpr.and(((SQLExpression)source).eq(target));
            if (target.subExprs.size() == 0) {
                Integer n = index;
                Integer n2 = index = Integer.valueOf(index + 1);
                continue;
            }
            index = index + target.subExprs.size();
        }
        return bExpr;
    }
}

