/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.ConditionalResolver;
import org.apache.hadoop.hive.ql.plan.ConditionalWork;
import org.apache.hadoop.hive.ql.plan.api.StageType;

public class ConditionalTask
extends Task<ConditionalWork>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private List<Task<? extends Serializable>> listTasks;
    private Task<? extends Serializable> resTask;
    private ConditionalResolver resolver;
    private Object resolverCtx;

    @Override
    public boolean isMapRedTask() {
        for (Task<? extends Serializable> task : this.listTasks) {
            if (!task.isMapRedTask()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasReduce() {
        for (Task<? extends Serializable> task : this.listTasks) {
            if (!task.hasReduce()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void initialize(HiveConf conf, QueryPlan queryPlan) {
        super.initialize(conf, queryPlan);
        this.resTask = this.listTasks.get(this.resolver.getTaskId(conf, this.resolverCtx));
        this.resTask.initialize(conf, queryPlan);
    }

    @Override
    public int execute() {
        return this.resTask.executeTask();
    }

    public ConditionalResolver getResolver() {
        return this.resolver;
    }

    public void setResolver(ConditionalResolver resolver) {
        this.resolver = resolver;
    }

    public Object getResolverCtx() {
        return this.resolverCtx;
    }

    public void setResolverCtx(Object resolverCtx) {
        this.resolverCtx = resolverCtx;
    }

    public List<Task<? extends Serializable>> getListTasks() {
        return this.listTasks;
    }

    public void setListTasks(List<Task<? extends Serializable>> listTasks) {
        this.listTasks = listTasks;
    }

    @Override
    public StageType getType() {
        return StageType.CONDITIONAL;
    }
}

