/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Task;
import org.apache.hadoop.hive.ql.plan.api.StageType;
import org.apache.hadoop.hive.ql.plan.explain;
import org.apache.hadoop.hive.ql.plan.explainWork;
import org.apache.hadoop.util.StringUtils;

public class ExplainTask
extends Task<explainWork>
implements Serializable {
    private static final long serialVersionUID = 1L;

    @Override
    public int execute() {
        try {
            FSDataOutputStream outS = ((explainWork)this.work).getResFile().getFileSystem((Configuration)this.conf).create(((explainWork)this.work).getResFile());
            PrintStream out = new PrintStream((OutputStream)outS);
            this.outputAST(((explainWork)this.work).getAstStringTree(), out, 0);
            out.println();
            this.outputDependencies(out, ((explainWork)this.work).getRootTasks(), 0);
            out.println();
            this.outputStagePlans(out, ((explainWork)this.work).getRootTasks(), 0);
            out.close();
            return 0;
        }
        catch (Exception e) {
            this.console.printError("Failed with exception " + e.getMessage(), "\n" + StringUtils.stringifyException((Throwable)e));
            return 1;
        }
    }

    private String indentString(int indent) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < indent; ++i) {
            sb.append(" ");
        }
        return sb.toString();
    }

    private void outputMap(Map<?, ?> mp, String header, PrintStream out, boolean extended, int indent) throws Exception {
        boolean first_el = true;
        for (Map.Entry<?, ?> ent : mp.entrySet()) {
            if (first_el) {
                out.println(header);
            }
            first_el = false;
            out.print(this.indentString(indent));
            out.printf("%s ", ent.getKey().toString());
            if (this.isPrintable(ent.getValue())) {
                out.print(ent.getValue());
                out.println();
                continue;
            }
            if (ent.getValue() instanceof List) {
                out.print(ent.getValue().toString());
                out.println();
                continue;
            }
            if (!(ent.getValue() instanceof Serializable)) continue;
            out.println();
            this.outputPlan((Serializable)ent.getValue(), out, extended, indent + 2);
        }
    }

    private void outputList(List<?> l, String header, PrintStream out, boolean extended, int indent) throws Exception {
        boolean first_el = true;
        boolean nl = false;
        for (Object o : l) {
            if (first_el) {
                out.print(header);
            }
            if (this.isPrintable(o)) {
                if (!first_el) {
                    out.print(", ");
                } else {
                    out.print(" ");
                }
                out.print(o);
                nl = true;
            } else if (o instanceof Serializable) {
                if (first_el) {
                    out.println();
                }
                this.outputPlan((Serializable)o, out, extended, indent + 2);
            }
            first_el = false;
        }
        if (nl) {
            out.println();
        }
    }

    private boolean isPrintable(Object val) {
        if (val instanceof Boolean || val instanceof String || val instanceof Integer || val instanceof Byte || val instanceof Float || val instanceof Double) {
            return true;
        }
        return val.getClass().isPrimitive();
    }

    private void outputPlan(Serializable work, PrintStream out, boolean extended, int indent) throws Exception {
        explain note = work.getClass().getAnnotation(explain.class);
        if (note instanceof explain) {
            explain xpl_note = note;
            if (extended || xpl_note.normalExplain()) {
                out.print(this.indentString(indent));
                out.println(xpl_note.displayName());
            }
        }
        if (work instanceof Operator) {
            Operator operator = (Operator)work;
            if (operator.getConf() != null) {
                this.outputPlan((Serializable)operator.getConf(), out, extended, indent);
            }
            if (operator.getChildOperators() != null) {
                for (Operator<Serializable> op : operator.getChildOperators()) {
                    this.outputPlan(op, out, extended, indent + 2);
                }
            }
            return;
        }
        Method[] methods = work.getClass().getMethods();
        Arrays.sort(methods, new MethodComparator());
        for (Method m : methods) {
            Object val;
            int prop_indents = indent + 2;
            note = m.getAnnotation(explain.class);
            if (!(note instanceof explain)) continue;
            explain xpl_note = note;
            if (!extended && !xpl_note.normalExplain() || (val = m.invoke((Object)work, new Object[0])) == null) continue;
            String header = null;
            if (!xpl_note.displayName().equals("")) {
                header = this.indentString(prop_indents) + xpl_note.displayName() + ":";
            } else {
                prop_indents = indent;
                header = this.indentString(prop_indents);
            }
            if (this.isPrintable(val)) {
                out.printf("%s ", header);
                out.println(val);
                continue;
            }
            try {
                Map mp = (Map)val;
                this.outputMap(mp, header, out, extended, prop_indents + 2);
            }
            catch (ClassCastException ce) {
                try {
                    List l = (List)val;
                    this.outputList(l, header, out, extended, prop_indents + 2);
                }
                catch (ClassCastException ce2) {
                    try {
                        Serializable s = (Serializable)val;
                        out.println(header);
                        this.outputPlan(s, out, extended, prop_indents + 2);
                    }
                    catch (ClassCastException ce3) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private void outputPlan(Task<? extends Serializable> task, PrintStream out, boolean extended, HashSet<Task<? extends Serializable>> displayedSet, int indent) throws Exception {
        if (displayedSet.contains(task)) {
            return;
        }
        displayedSet.add(task);
        out.print(this.indentString(indent));
        out.printf("Stage: %s\n", task.getId());
        this.outputPlan(task.getWork(), out, extended, indent + 2);
        out.println();
        if (task.getChildTasks() != null) {
            for (Task<Serializable> child : task.getChildTasks()) {
                this.outputPlan(child, out, extended, displayedSet, indent);
            }
        }
    }

    private void outputDependencies(Task<? extends Serializable> task, PrintStream out, int indent) throws Exception {
        out.print(this.indentString(indent));
        out.printf("%s", task.getId());
        if (task.getParentTasks() == null || task.getParentTasks().isEmpty()) {
            out.print(" is a root stage");
        } else {
            out.print(" depends on stages: ");
            boolean first = true;
            for (Task<Serializable> parent : task.getParentTasks()) {
                if (!first) {
                    out.print(", ");
                }
                first = false;
                out.print(parent.getId());
            }
        }
        out.println();
        if (task.getChildTasks() != null) {
            for (Task<Serializable> child : task.getChildTasks()) {
                this.outputDependencies(child, out, indent);
            }
        }
    }

    public void outputAST(String treeString, PrintStream out, int indent) {
        out.print(this.indentString(indent));
        out.println("ABSTRACT SYNTAX TREE:");
        out.print(this.indentString(indent + 2));
        out.println(treeString);
    }

    public void outputDependencies(PrintStream out, List<Task<? extends Serializable>> rootTasks, int indent) throws Exception {
        out.print(this.indentString(indent));
        out.println("STAGE DEPENDENCIES:");
        for (Task<? extends Serializable> rootTask : rootTasks) {
            this.outputDependencies(rootTask, out, indent + 2);
        }
    }

    public void outputStagePlans(PrintStream out, List<Task<? extends Serializable>> rootTasks, int indent) throws Exception {
        out.print(this.indentString(indent));
        out.println("STAGE PLANS:");
        HashSet<Task<? extends Serializable>> displayedSet = new HashSet<Task<? extends Serializable>>();
        for (Task<? extends Serializable> rootTask : rootTasks) {
            this.outputPlan(rootTask, out, ((explainWork)this.work).getExtended(), displayedSet, indent + 2);
        }
    }

    @Override
    public StageType getType() {
        return StageType.EXPLAIN;
    }

    public static class MethodComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            Method m1 = (Method)o1;
            Method m2 = (Method)o2;
            return m1.getName().compareTo(m2.getName());
        }
    }
}

