/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.AutoProgressor;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.api.OperatorType;
import org.apache.hadoop.hive.ql.plan.udtfDesc;
import org.apache.hadoop.hive.ql.udf.generic.UDTFCollector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StandardStructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;

public class UDTFOperator
extends Operator<udtfDesc>
implements Serializable {
    private static final long serialVersionUID = 1L;
    protected final Log LOG = LogFactory.getLog((String)this.getClass().getName());
    ObjectInspector[] udtfInputOIs = null;
    Object[] objToSendToUDTF = null;
    Object[] forwardObj = new Object[1];
    transient AutoProgressor autoProgressor;
    transient boolean closeCalled = false;

    @Override
    protected void initializeOp(Configuration hconf) throws HiveException {
        ((udtfDesc)this.conf).getGenericUDTF().setCollector(new UDTFCollector(this));
        List<? extends StructField> inputFields = ((StandardStructObjectInspector)this.inputObjInspectors[0]).getAllStructFieldRefs();
        this.udtfInputOIs = new ObjectInspector[inputFields.size()];
        for (int i = 0; i < inputFields.size(); ++i) {
            this.udtfInputOIs[i] = inputFields.get(i).getFieldObjectInspector();
        }
        this.objToSendToUDTF = new Object[inputFields.size()];
        StructObjectInspector udtfOutputOI = ((udtfDesc)this.conf).getGenericUDTF().initialize(this.udtfInputOIs);
        this.outputObjInspector = udtfOutputOI;
        if (HiveConf.getBoolVar(hconf, HiveConf.ConfVars.HIVEUDTFAUTOPROGRESS)) {
            this.autoProgressor = new AutoProgressor(this.getClass().getName(), this.reporter, Utilities.getDefaultNotificationInterval(hconf));
            this.autoProgressor.go();
        }
        super.initializeOp(hconf);
    }

    @Override
    public void processOp(Object row, int tag) throws HiveException {
        StandardStructObjectInspector soi = (StandardStructObjectInspector)this.inputObjInspectors[tag];
        List<? extends StructField> fields = soi.getAllStructFieldRefs();
        for (int i = 0; i < fields.size(); ++i) {
            this.objToSendToUDTF[i] = soi.getStructFieldData(row, fields.get(i));
        }
        ((udtfDesc)this.conf).getGenericUDTF().process(this.objToSendToUDTF);
    }

    public void forwardUDTFOutput(Object o) throws HiveException {
        if (this.closeCalled) {
            throw new HiveException("UDTF's should not output rows on close");
        }
        this.forward(o, this.outputObjInspector);
    }

    @Override
    public String getName() {
        return "UDTF";
    }

    @Override
    public OperatorType getType() {
        return OperatorType.UDTF;
    }

    @Override
    protected void closeOp(boolean abort) throws HiveException {
        this.closeCalled = true;
        ((udtfDesc)this.conf).getGenericUDTF().close();
    }
}

