/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec.persistence;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.persistence.RowContainer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.io.Writable;

public class MapJoinObjectValue
implements Externalizable {
    protected transient int metadataTag;
    protected transient RowContainer obj;
    protected transient Configuration conf;
    protected transient int bucketSize;

    public MapJoinObjectValue() {
        this.bucketSize = 100;
    }

    public MapJoinObjectValue(int metadataTag, RowContainer obj) {
        this.metadataTag = metadataTag;
        this.obj = obj;
        this.bucketSize = 100;
    }

    public boolean equals(Object o) {
        MapJoinObjectValue mObj;
        if (o instanceof MapJoinObjectValue && (mObj = (MapJoinObjectValue)o).getMetadataTag() == this.metadataTag) {
            if (this.obj == null && mObj.getObj() == null) {
                return true;
            }
            if (this.obj != null && mObj.getObj() != null && mObj.getObj().equals(this.obj)) {
                return true;
            }
        }
        return false;
    }

    public int hashCode() {
        return this.obj == null ? 0 : this.obj.hashCode();
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        try {
            this.metadataTag = in.readInt();
            MapJoinOperator.MapJoinObjectCtx ctx = MapJoinOperator.getMapMetadata().get(this.metadataTag);
            int sz = in.readInt();
            RowContainer<ArrayList> res = new RowContainer<ArrayList>(this.bucketSize);
            res.setSerDe(ctx.getSerDe(), ctx.getStandardOI());
            res.setTableDesc(ctx.getTblDesc());
            for (int pos = 0; pos < sz; ++pos) {
                Writable val = ctx.getSerDe().getSerializedClass().newInstance();
                val.readFields((DataInput)in);
                ArrayList memObj = (ArrayList)ObjectInspectorUtils.copyToStandardObject(ctx.getSerDe().deserialize(val), ctx.getSerDe().getObjectInspector(), ObjectInspectorUtils.ObjectInspectorCopyOption.WRITABLE);
                res.add(memObj);
            }
            this.obj = res;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        try {
            out.writeInt(this.metadataTag);
            MapJoinOperator.MapJoinObjectCtx ctx = MapJoinOperator.getMapMetadata().get(this.metadataTag);
            RowContainer v = this.obj;
            out.writeInt(v.size());
            ArrayList row = (ArrayList)v.first();
            while (row != null) {
                Writable outVal = ctx.getSerDe().serialize(row, ctx.getStandardOI());
                outVal.write((DataOutput)out);
                row = (ArrayList)v.next();
            }
        }
        catch (SerDeException e) {
            throw new IOException(e);
        }
    }

    public int getMetadataTag() {
        return this.metadataTag;
    }

    public void setMetadataTag(int metadataTag) {
        this.metadataTag = metadataTag;
    }

    public RowContainer getObj() {
        return this.obj;
    }

    public void setObj(RowContainer obj) {
        this.obj = obj;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
        this.bucketSize = HiveConf.getIntVar(conf, HiveConf.ConfVars.HIVEMAPJOINBUCKETCACHESIZE);
    }
}

