/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveOutputFormat;
import org.apache.hadoop.hive.ql.io.HiveSequenceFileOutputFormat;
import org.apache.hadoop.hive.ql.io.IgnoreKeyTextOutputFormat;
import org.apache.hadoop.hive.ql.io.InputFormatChecker;
import org.apache.hadoop.hive.ql.io.RCFileInputFormat;
import org.apache.hadoop.hive.ql.io.SequenceFileInputFormatChecker;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.OutputFormat;
import org.apache.hadoop.mapred.SequenceFileInputFormat;
import org.apache.hadoop.mapred.SequenceFileOutputFormat;
import org.apache.hadoop.mapred.TextInputFormat;

public class HiveFileFormatUtils {
    private static Map<Class<? extends OutputFormat>, Class<? extends HiveOutputFormat>> outputFormatSubstituteMap = new HashMap<Class<? extends OutputFormat>, Class<? extends HiveOutputFormat>>();
    private static Map<Class<? extends InputFormat>, Class<? extends InputFormatChecker>> inputFormatCheckerMap;
    private static Map<Class<? extends InputFormatChecker>, InputFormatChecker> inputFormatCheckerInstanceCache;

    public static synchronized void registerOutputFormatSubstitute(Class<? extends OutputFormat> origin, Class<? extends HiveOutputFormat> substitute) {
        outputFormatSubstituteMap.put(origin, substitute);
    }

    public static synchronized Class<? extends HiveOutputFormat> getOutputFormatSubstitute(Class<?> origin) {
        if (HiveOutputFormat.class.isAssignableFrom(origin)) {
            return origin;
        }
        Class<? extends HiveOutputFormat> result = outputFormatSubstituteMap.get(origin);
        return result;
    }

    public static Path getOutputFormatFinalPath(Path parent, JobConf jc, HiveOutputFormat<?, ?> hiveOutputFormat, boolean isCompressed, Path defaultFinalPath) throws IOException {
        if (hiveOutputFormat instanceof HiveIgnoreKeyTextOutputFormat) {
            return new Path(parent, Utilities.getTaskId((Configuration)jc) + Utilities.getFileExtension(jc, isCompressed));
        }
        return defaultFinalPath;
    }

    public static synchronized void registerInputFormatChecker(Class<? extends InputFormat> format, Class<? extends InputFormatChecker> checker) {
        inputFormatCheckerMap.put(format, checker);
    }

    public static synchronized Class<? extends InputFormatChecker> getInputFormatChecker(Class<?> inputFormat) {
        Class<? extends InputFormatChecker> result = inputFormatCheckerMap.get(inputFormat);
        return result;
    }

    public static boolean checkInputFormat(FileSystem fs, HiveConf conf, Class<? extends InputFormat> inputFormatCls, ArrayList<FileStatus> files) throws HiveException {
        if (files.size() > 0) {
            Class<? extends InputFormatChecker> checkerCls = HiveFileFormatUtils.getInputFormatChecker(inputFormatCls);
            if (checkerCls == null && inputFormatCls.isAssignableFrom(TextInputFormat.class)) {
                return HiveFileFormatUtils.checkTextInputFormat(fs, conf, files);
            }
            if (checkerCls != null) {
                InputFormatChecker checkerInstance = inputFormatCheckerInstanceCache.get(checkerCls);
                try {
                    if (checkerInstance == null) {
                        checkerInstance = checkerCls.newInstance();
                        inputFormatCheckerInstanceCache.put(checkerCls, checkerInstance);
                    }
                    return checkerInstance.validateInput(fs, conf, files);
                }
                catch (Exception e) {
                    throw new HiveException(e);
                }
            }
            return true;
        }
        return false;
    }

    private static boolean checkTextInputFormat(FileSystem fs, HiveConf conf, ArrayList<FileStatus> files) throws HiveException {
        Set<Class<? extends InputFormat>> inputFormatter = inputFormatCheckerMap.keySet();
        for (Class<? extends InputFormat> reg : inputFormatter) {
            boolean result = HiveFileFormatUtils.checkInputFormat(fs, conf, reg, files);
            if (!result) continue;
            return false;
        }
        return true;
    }

    static {
        HiveFileFormatUtils.registerOutputFormatSubstitute(IgnoreKeyTextOutputFormat.class, HiveIgnoreKeyTextOutputFormat.class);
        HiveFileFormatUtils.registerOutputFormatSubstitute(SequenceFileOutputFormat.class, HiveSequenceFileOutputFormat.class);
        inputFormatCheckerMap = new HashMap<Class<? extends InputFormat>, Class<? extends InputFormatChecker>>();
        HiveFileFormatUtils.registerInputFormatChecker(SequenceFileInputFormat.class, SequenceFileInputFormatChecker.class);
        HiveFileFormatUtils.registerInputFormatChecker(RCFileInputFormat.class, RCFileInputFormat.class);
        inputFormatCheckerInstanceCache = new HashMap<Class<? extends InputFormatChecker>, InputFormatChecker>();
    }
}

