/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.io.HiveRecordReader;
import org.apache.hadoop.hive.ql.plan.mapredWork;
import org.apache.hadoop.hive.ql.plan.partitionDesc;
import org.apache.hadoop.hive.serde2.ColumnProjectionUtils;
import org.apache.hadoop.hive.shims.ShimLoader;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.InputFormat;
import org.apache.hadoop.mapred.InputSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobConfigurable;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.util.ReflectionUtils;

public class HiveInputFormat<K extends WritableComparable, V extends Writable>
implements InputFormat<K, V>,
JobConfigurable {
    public static final Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.io.HiveInputFormat");
    JobConf job;
    private static Map<Class, InputFormat<WritableComparable, Writable>> inputFormats;
    private Map<String, partitionDesc> pathToPartitionInfo;
    mapredWork mrwork = null;

    public void configure(JobConf job) {
        this.job = job;
    }

    static InputFormat<WritableComparable, Writable> getInputFormatFromCache(Class inputFormatClass, JobConf job) throws IOException {
        if (inputFormats == null) {
            inputFormats = new HashMap<Class, InputFormat<WritableComparable, Writable>>();
        }
        if (!inputFormats.containsKey(inputFormatClass)) {
            try {
                InputFormat newInstance = (InputFormat)ReflectionUtils.newInstance((Class)inputFormatClass, (Configuration)job);
                inputFormats.put(inputFormatClass, (InputFormat<WritableComparable, Writable>)newInstance);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputFormat class " + inputFormatClass.getName() + " as specified in mapredWork!", e);
            }
        }
        return inputFormats.get(inputFormatClass);
    }

    public RecordReader getRecordReader(InputSplit split, JobConf job, Reporter reporter) throws IOException {
        HiveInputSplit hsplit = (HiveInputSplit)split;
        InputSplit inputSplit = hsplit.getInputSplit();
        String inputFormatClassName = null;
        Class inputFormatClass = null;
        try {
            inputFormatClassName = hsplit.inputFormatClassName();
            inputFormatClass = job.getClassByName(inputFormatClassName);
        }
        catch (Exception e) {
            throw new IOException("cannot find class " + inputFormatClassName);
        }
        JobConf cloneJobConf = new JobConf((Configuration)job);
        this.initColumnsNeeded(cloneJobConf, inputFormatClass, hsplit.getPath().toString(), hsplit.getPath().toUri().getPath());
        InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, cloneJobConf);
        return new HiveRecordReader(inputFormat.getRecordReader(inputSplit, cloneJobConf, reporter));
    }

    protected void init(JobConf job) {
        this.mrwork = Utilities.getMapRedWork((Configuration)job);
        this.pathToPartitionInfo = this.mrwork.getPathToPartitionInfo();
    }

    public InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        this.init(job);
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        JobConf newjob = new JobConf((Configuration)job);
        ArrayList<HiveInputSplit> result = new ArrayList<HiveInputSplit>();
        for (Path dir : dirs) {
            InputSplit[] iss;
            partitionDesc part = HiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            Class<? extends InputFormat> inputFormatClass = part.getInputFileFormatClass();
            InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(inputFormatClass, job);
            FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{dir});
            newjob.setInputFormat(inputFormat.getClass());
            for (InputSplit is : iss = inputFormat.getSplits(newjob, numSplits / dirs.length)) {
                result.add(new HiveInputSplit(is, inputFormatClass.getName()));
            }
        }
        return result.toArray(new HiveInputSplit[result.size()]);
    }

    public void validateInput(JobConf job) throws IOException {
        this.init(job);
        Path[] dirs = FileInputFormat.getInputPaths((JobConf)job);
        if (dirs.length == 0) {
            throw new IOException("No input paths specified in job");
        }
        JobConf newjob = new JobConf((Configuration)job);
        for (Path dir : dirs) {
            partitionDesc part = HiveInputFormat.getPartitionDescFromPath(this.pathToPartitionInfo, dir);
            InputFormat<WritableComparable, Writable> inputFormat = HiveInputFormat.getInputFormatFromCache(part.getInputFileFormatClass(), job);
            FileInputFormat.setInputPaths((JobConf)newjob, (Path[])new Path[]{dir});
            newjob.setInputFormat(inputFormat.getClass());
            ShimLoader.getHadoopShims().inputFormatValidateInput(inputFormat, newjob);
        }
    }

    protected static partitionDesc getPartitionDescFromPath(Map<String, partitionDesc> pathToPartitionInfo, Path dir) throws IOException {
        partitionDesc partDesc = pathToPartitionInfo.get(dir.toString());
        if (partDesc == null) {
            partDesc = pathToPartitionInfo.get(dir.toUri().getPath());
        }
        if (partDesc == null) {
            throw new IOException("cannot find dir = " + dir.toString() + " in partToPartitionInfo!");
        }
        return partDesc;
    }

    protected void initColumnsNeeded(JobConf jobConf, Class inputFormatClass, String splitPath, String splitPathWithNoSchema) {
        if (this.mrwork == null) {
            this.init(this.job);
        }
        ArrayList<String> aliases = new ArrayList<String>();
        for (Map.Entry<String, ArrayList<String>> entry : this.mrwork.getPathToAliases().entrySet()) {
            String key = entry.getKey();
            if (!splitPath.startsWith(key) && !splitPathWithNoSchema.startsWith(key)) continue;
            ArrayList<String> list = entry.getValue();
            for (String val : list) {
                aliases.add(val);
            }
        }
        for (String alias : aliases) {
            Operator<? extends Serializable> op = this.mrwork.getAliasToWork().get(alias);
            if (!(op instanceof TableScanOperator)) continue;
            TableScanOperator tableScan = (TableScanOperator)op;
            ArrayList<Integer> list = tableScan.getNeededColumnIDs();
            if (list != null) {
                ColumnProjectionUtils.appendReadColumnIDs((Configuration)jobConf, list);
                continue;
            }
            ColumnProjectionUtils.setFullyReadColumns((Configuration)jobConf);
        }
    }

    public static class HiveInputSplit
    extends FileSplit
    implements InputSplit,
    Configurable {
        InputSplit inputSplit;
        String inputFormatClassName;
        Configuration conf;

        public HiveInputSplit() {
            super((Path)null, 0L, 0L, (String[])null);
        }

        public HiveInputSplit(InputSplit inputSplit, String inputFormatClassName) {
            super((Path)null, 0L, 0L, (String[])null);
            this.inputSplit = inputSplit;
            this.inputFormatClassName = inputFormatClassName;
        }

        public InputSplit getInputSplit() {
            return this.inputSplit;
        }

        public String inputFormatClassName() {
            return this.inputFormatClassName;
        }

        public Path getPath() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getPath();
            }
            return new Path("");
        }

        public long getStart() {
            if (this.inputSplit instanceof FileSplit) {
                return ((FileSplit)this.inputSplit).getStart();
            }
            return 0L;
        }

        public String toString() {
            return this.inputFormatClassName + ":" + this.inputSplit.toString();
        }

        public long getLength() {
            long r = 0L;
            try {
                r = this.inputSplit.getLength();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            return r;
        }

        public String[] getLocations() throws IOException {
            return this.inputSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            String inputSplitClassName = in.readUTF();
            try {
                this.inputSplit = (InputSplit)ReflectionUtils.newInstance((Class)this.conf.getClassByName(inputSplitClassName), (Configuration)this.conf);
            }
            catch (Exception e) {
                throw new IOException("Cannot create an instance of InputSplit class = " + inputSplitClassName + ":" + e.getMessage());
            }
            this.inputSplit.readFields(in);
            this.inputFormatClassName = in.readUTF();
        }

        public void write(DataOutput out) throws IOException {
            out.writeUTF(this.inputSplit.getClass().getName());
            this.inputSplit.write(out);
            out.writeUTF(this.inputFormatClassName);
        }

        public Configuration getConf() {
            return this.conf;
        }

        public void setConf(Configuration conf) {
            this.conf = conf;
        }
    }
}

