/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.io;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.hadoop.io.WritableComparable;
import org.apache.hadoop.io.WritableComparator;

public class DoubleWritable
implements WritableComparable {
    private double value = 0.0;

    public DoubleWritable() {
    }

    public DoubleWritable(double value) {
        this.set(value);
    }

    public void readFields(DataInput in) throws IOException {
        this.value = in.readDouble();
    }

    public void write(DataOutput out) throws IOException {
        out.writeDouble(this.value);
    }

    public void set(double value) {
        this.value = value;
    }

    public double get() {
        return this.value;
    }

    public boolean equals(Object o) {
        if (!(o instanceof DoubleWritable)) {
            return false;
        }
        DoubleWritable other = (DoubleWritable)o;
        return this.value == other.value;
    }

    public int hashCode() {
        return (int)Double.doubleToLongBits(this.value);
    }

    public int compareTo(Object o) {
        DoubleWritable other = (DoubleWritable)o;
        return this.value < other.value ? -1 : (this.value == other.value ? 0 : 1);
    }

    public String toString() {
        return Double.toString(this.value);
    }

    static {
        WritableComparator.define(DoubleWritable.class, (WritableComparator)new Comparator());
    }

    public static class Comparator
    extends WritableComparator {
        public Comparator() {
            super(DoubleWritable.class);
        }

        public int compare(byte[] b1, int s1, int l1, byte[] b2, int s2, int l2) {
            double thatValue;
            double thisValue = Comparator.readDouble((byte[])b1, (int)s1);
            return thisValue < (thatValue = Comparator.readDouble((byte[])b2, (int)s2)) ? -1 : (thisValue == thatValue ? 0 : 1);
        }
    }
}

