/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2.lazy.objectinspector;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.serde2.lazy.LazyStruct;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;
import org.apache.hadoop.hive.serde2.objectinspector.StructField;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.io.Text;

public class LazySimpleStructObjectInspector
extends StructObjectInspector {
    public static final Log LOG = LogFactory.getLog((String)LazySimpleStructObjectInspector.class.getName());
    protected List<MyField> fields;
    byte separator;
    Text nullSequence;
    boolean lastColumnTakesRest;
    boolean escaped;
    byte escapeChar;

    @Override
    public String getTypeName() {
        return ObjectInspectorUtils.getStandardStructTypeName(this);
    }

    protected LazySimpleStructObjectInspector(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        this.init(structFieldNames, structFieldObjectInspectors, separator, nullSequence, lastColumnTakesRest, escaped, escapeChar);
    }

    protected void init(List<String> structFieldNames, List<ObjectInspector> structFieldObjectInspectors, byte separator, Text nullSequence, boolean lastColumnTakesRest, boolean escaped, byte escapeChar) {
        assert (structFieldNames.size() == structFieldObjectInspectors.size());
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.lastColumnTakesRest = lastColumnTakesRest;
        this.escaped = escaped;
        this.escapeChar = escapeChar;
        this.fields = new ArrayList<MyField>(structFieldNames.size());
        for (int i = 0; i < structFieldNames.size(); ++i) {
            this.fields.add(new MyField(i, structFieldNames.get(i), structFieldObjectInspectors.get(i)));
        }
    }

    protected LazySimpleStructObjectInspector(List<StructField> fields, byte separator, Text nullSequence) {
        this.init(fields, separator, nullSequence);
    }

    protected void init(List<StructField> fields, byte separator, Text nullSequence) {
        this.separator = separator;
        this.nullSequence = nullSequence;
        this.fields = new ArrayList<MyField>(fields.size());
        for (int i = 0; i < fields.size(); ++i) {
            this.fields.add(new MyField(i, fields.get(i).getFieldName(), fields.get(i).getFieldObjectInspector()));
        }
    }

    @Override
    public final ObjectInspector.Category getCategory() {
        return ObjectInspector.Category.STRUCT;
    }

    @Override
    public StructField getStructFieldRef(String fieldName) {
        return ObjectInspectorUtils.getStandardStructFieldRef(fieldName, this.fields);
    }

    @Override
    public List<? extends StructField> getAllStructFieldRefs() {
        return this.fields;
    }

    @Override
    public Object getStructFieldData(Object data, StructField fieldRef) {
        if (data == null) {
            return null;
        }
        LazyStruct struct = (LazyStruct)data;
        MyField f = (MyField)fieldRef;
        int fieldID = f.getFieldID();
        assert (fieldID >= 0 && fieldID < this.fields.size());
        return struct.getField(fieldID);
    }

    @Override
    public List<Object> getStructFieldsDataAsList(Object data) {
        if (data == null) {
            return null;
        }
        LazyStruct struct = (LazyStruct)data;
        return struct.getFieldsAsList();
    }

    public byte getSeparator() {
        return this.separator;
    }

    public Text getNullSequence() {
        return this.nullSequence;
    }

    public boolean getLastColumnTakesRest() {
        return this.lastColumnTakesRest;
    }

    public boolean isEscaped() {
        return this.escaped;
    }

    public byte getEscapeChar() {
        return this.escapeChar;
    }

    protected static class MyField
    implements StructField {
        protected int fieldID;
        protected String fieldName;
        protected ObjectInspector fieldObjectInspector;

        public MyField(int fieldID, String fieldName, ObjectInspector fieldObjectInspector) {
            this.fieldID = fieldID;
            this.fieldName = fieldName.toLowerCase();
            this.fieldObjectInspector = fieldObjectInspector;
        }

        public int getFieldID() {
            return this.fieldID;
        }

        @Override
        public String getFieldName() {
            return this.fieldName;
        }

        @Override
        public ObjectInspector getFieldObjectInspector() {
            return this.fieldObjectInspector;
        }

        public String toString() {
            return "" + this.fieldID + ":" + this.fieldName;
        }
    }
}

