/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.org.eclipse.jdt.internal.compiler.impl;

import org.aspectj.org.eclipse.jdt.internal.compiler.impl.Constant;

public class LongConstant
extends Constant {
    private static final LongConstant ZERO = new LongConstant(0L);
    private long value;

    public static Constant fromValue(long value) {
        if (value == 0L) {
            return ZERO;
        }
        return new LongConstant(value);
    }

    private LongConstant(long value) {
        this.value = value;
    }

    public byte byteValue() {
        return (byte)this.value;
    }

    public char charValue() {
        return (char)this.value;
    }

    public double doubleValue() {
        return this.value;
    }

    public float floatValue() {
        return this.value;
    }

    public int intValue() {
        return (int)this.value;
    }

    public long longValue() {
        return this.value;
    }

    public short shortValue() {
        return (short)this.value;
    }

    public String stringValue() {
        return String.valueOf(this.value);
    }

    public String toString() {
        return "(long)" + this.value;
    }

    public int typeID() {
        return 7;
    }
}

