/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.classfile.annotation;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.aspectj.apache.bcel.classfile.ConstantPool;
import org.aspectj.apache.bcel.classfile.ConstantUtf8;
import org.aspectj.apache.bcel.classfile.Utility;
import org.aspectj.apache.bcel.classfile.annotation.ElementNameValuePairGen;
import org.aspectj.apache.bcel.classfile.annotation.ElementValueGen;
import org.aspectj.apache.bcel.generic.ObjectType;

public class AnnotationGen {
    public static final AnnotationGen[] NO_ANNOTATIONS = new AnnotationGen[0];
    private int typeIndex;
    private List evs;
    private ConstantPool cpool;
    private boolean isRuntimeVisible = false;

    public AnnotationGen(AnnotationGen a, ConstantPool cpool, boolean copyPoolEntries) {
        this.cpool = cpool;
        this.typeIndex = copyPoolEntries ? cpool.addUtf8(a.getTypeSignature()) : a.getTypeIndex();
        this.isRuntimeVisible = a.isRuntimeVisible();
        this.evs = this.copyValues(a.getValues(), cpool, copyPoolEntries);
    }

    private List copyValues(List in, ConstantPool cpool, boolean copyPoolEntries) {
        ArrayList<ElementNameValuePairGen> out = new ArrayList<ElementNameValuePairGen>();
        Iterator iter = in.iterator();
        while (iter.hasNext()) {
            ElementNameValuePairGen nvp = (ElementNameValuePairGen)iter.next();
            out.add(new ElementNameValuePairGen(nvp, cpool, copyPoolEntries));
        }
        return out;
    }

    private AnnotationGen(ConstantPool cpool) {
        this.cpool = cpool;
        this.evs = new ArrayList();
    }

    public AnnotationGen(ObjectType type, List elements, boolean vis, ConstantPool cpool) {
        this.cpool = cpool;
        if (type != null) {
            this.typeIndex = cpool.addUtf8(type.getSignature());
        }
        this.evs = elements;
        this.isRuntimeVisible = vis;
    }

    public static AnnotationGen read(DataInputStream dis, ConstantPool cpool, boolean b) throws IOException {
        AnnotationGen a = new AnnotationGen(cpool);
        a.typeIndex = dis.readUnsignedShort();
        int elemValuePairCount = dis.readUnsignedShort();
        int i = 0;
        while (i < elemValuePairCount) {
            int nidx = dis.readUnsignedShort();
            a.addElementNameValuePair(new ElementNameValuePairGen(nidx, ElementValueGen.readElementValue(dis, cpool), cpool));
            ++i;
        }
        a.isRuntimeVisible(b);
        return a;
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.typeIndex);
        dos.writeShort(this.evs.size());
        int i = 0;
        while (i < this.evs.size()) {
            ElementNameValuePairGen envp = (ElementNameValuePairGen)this.evs.get(i);
            envp.dump(dos);
            ++i;
        }
    }

    public void addElementNameValuePair(ElementNameValuePairGen evp) {
        if (this.evs == null) {
            this.evs = new ArrayList();
        }
        this.evs.add(evp);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public String getTypeSignature() {
        ConstantUtf8 utf8 = (ConstantUtf8)this.cpool.getConstant(this.typeIndex);
        return utf8.getBytes();
    }

    public String getTypeName() {
        return Utility.signatureToString(this.getTypeSignature());
    }

    public List getValues() {
        return this.evs;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append("AnnotationGen:[" + this.getTypeName() + " #" + this.evs.size() + " {");
        int i = 0;
        while (i < this.evs.size()) {
            s.append(this.evs.get(i));
            if (i + 1 < this.evs.size()) {
                s.append(",");
            }
            ++i;
        }
        s.append("}]");
        return s.toString();
    }

    public String toShortString() {
        StringBuffer s = new StringBuffer();
        s.append("@" + this.getTypeName() + "(");
        int i = 0;
        while (i < this.evs.size()) {
            s.append(this.evs.get(i));
            if (i + 1 < this.evs.size()) {
                s.append(",");
            }
            ++i;
        }
        s.append(")");
        return s.toString();
    }

    private void isRuntimeVisible(boolean b) {
        this.isRuntimeVisible = b;
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public boolean hasNameValuePair(String n, String v) {
        int i = 0;
        while (i < this.evs.size()) {
            ElementNameValuePairGen pair = (ElementNameValuePairGen)this.evs.get(i);
            if (pair.getNameString().equals(n) && pair.getValue().stringifyValue().equals(v)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public boolean hasNamedValue(String n) {
        int i = 0;
        while (i < this.evs.size()) {
            ElementNameValuePairGen pair = (ElementNameValuePairGen)this.evs.get(i);
            if (pair.getNameString().equals(n)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

