/*
 * Decompiled with CFR 0.152.
 */
package org.aspectj.apache.bcel.generic;

import java.io.DataOutputStream;
import java.io.IOException;
import org.aspectj.apache.bcel.generic.ArrayType;
import org.aspectj.apache.bcel.generic.BasicType;
import org.aspectj.apache.bcel.generic.Instruction;
import org.aspectj.apache.bcel.generic.Type;

public class InstructionByte
extends Instruction {
    private final byte theByte;

    public InstructionByte(short opcode, byte b) {
        super(opcode);
        this.theByte = b;
    }

    public void dump(DataOutputStream out) throws IOException {
        out.writeByte(this.opcode);
        out.writeByte(this.theByte);
    }

    public String toString(boolean verbose) {
        return String.valueOf(super.toString(verbose)) + " " + this.theByte;
    }

    public final byte getTypecode() {
        return this.theByte;
    }

    public final Type getType() {
        return new ArrayType(BasicType.getType(this.theByte), 1);
    }
}

