/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.ql.exec.FunctionInfo;
import org.apache.hadoop.hive.ql.exec.UDAF;
import org.apache.hadoop.hive.ql.exec.UDF;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.parse.SemanticException;
import org.apache.hadoop.hive.ql.plan.exprNodeDesc;
import org.apache.hadoop.hive.ql.plan.exprNodeGenericFuncDesc;
import org.apache.hadoop.hive.ql.udf.UDAFMax;
import org.apache.hadoop.hive.ql.udf.UDAFMin;
import org.apache.hadoop.hive.ql.udf.UDFAbs;
import org.apache.hadoop.hive.ql.udf.UDFAcos;
import org.apache.hadoop.hive.ql.udf.UDFAscii;
import org.apache.hadoop.hive.ql.udf.UDFAsin;
import org.apache.hadoop.hive.ql.udf.UDFBin;
import org.apache.hadoop.hive.ql.udf.UDFCeil;
import org.apache.hadoop.hive.ql.udf.UDFConcat;
import org.apache.hadoop.hive.ql.udf.UDFConv;
import org.apache.hadoop.hive.ql.udf.UDFCos;
import org.apache.hadoop.hive.ql.udf.UDFDate;
import org.apache.hadoop.hive.ql.udf.UDFDateAdd;
import org.apache.hadoop.hive.ql.udf.UDFDateDiff;
import org.apache.hadoop.hive.ql.udf.UDFDateSub;
import org.apache.hadoop.hive.ql.udf.UDFDayOfMonth;
import org.apache.hadoop.hive.ql.udf.UDFExp;
import org.apache.hadoop.hive.ql.udf.UDFFindInSet;
import org.apache.hadoop.hive.ql.udf.UDFFloor;
import org.apache.hadoop.hive.ql.udf.UDFFromUnixTime;
import org.apache.hadoop.hive.ql.udf.UDFHex;
import org.apache.hadoop.hive.ql.udf.UDFHour;
import org.apache.hadoop.hive.ql.udf.UDFJson;
import org.apache.hadoop.hive.ql.udf.UDFLTrim;
import org.apache.hadoop.hive.ql.udf.UDFLength;
import org.apache.hadoop.hive.ql.udf.UDFLike;
import org.apache.hadoop.hive.ql.udf.UDFLn;
import org.apache.hadoop.hive.ql.udf.UDFLog;
import org.apache.hadoop.hive.ql.udf.UDFLog10;
import org.apache.hadoop.hive.ql.udf.UDFLog2;
import org.apache.hadoop.hive.ql.udf.UDFLower;
import org.apache.hadoop.hive.ql.udf.UDFLpad;
import org.apache.hadoop.hive.ql.udf.UDFMinute;
import org.apache.hadoop.hive.ql.udf.UDFMonth;
import org.apache.hadoop.hive.ql.udf.UDFOPAnd;
import org.apache.hadoop.hive.ql.udf.UDFOPBitAnd;
import org.apache.hadoop.hive.ql.udf.UDFOPBitNot;
import org.apache.hadoop.hive.ql.udf.UDFOPBitOr;
import org.apache.hadoop.hive.ql.udf.UDFOPBitXor;
import org.apache.hadoop.hive.ql.udf.UDFOPDivide;
import org.apache.hadoop.hive.ql.udf.UDFOPEqual;
import org.apache.hadoop.hive.ql.udf.UDFOPEqualOrGreaterThan;
import org.apache.hadoop.hive.ql.udf.UDFOPEqualOrLessThan;
import org.apache.hadoop.hive.ql.udf.UDFOPGreaterThan;
import org.apache.hadoop.hive.ql.udf.UDFOPLessThan;
import org.apache.hadoop.hive.ql.udf.UDFOPLongDivide;
import org.apache.hadoop.hive.ql.udf.UDFOPMinus;
import org.apache.hadoop.hive.ql.udf.UDFOPMod;
import org.apache.hadoop.hive.ql.udf.UDFOPMultiply;
import org.apache.hadoop.hive.ql.udf.UDFOPNegative;
import org.apache.hadoop.hive.ql.udf.UDFOPNot;
import org.apache.hadoop.hive.ql.udf.UDFOPNotEqual;
import org.apache.hadoop.hive.ql.udf.UDFOPOr;
import org.apache.hadoop.hive.ql.udf.UDFOPPlus;
import org.apache.hadoop.hive.ql.udf.UDFOPPositive;
import org.apache.hadoop.hive.ql.udf.UDFParseUrl;
import org.apache.hadoop.hive.ql.udf.UDFPosMod;
import org.apache.hadoop.hive.ql.udf.UDFPower;
import org.apache.hadoop.hive.ql.udf.UDFRTrim;
import org.apache.hadoop.hive.ql.udf.UDFRand;
import org.apache.hadoop.hive.ql.udf.UDFRegExp;
import org.apache.hadoop.hive.ql.udf.UDFRegExpExtract;
import org.apache.hadoop.hive.ql.udf.UDFRegExpReplace;
import org.apache.hadoop.hive.ql.udf.UDFRepeat;
import org.apache.hadoop.hive.ql.udf.UDFReverse;
import org.apache.hadoop.hive.ql.udf.UDFRound;
import org.apache.hadoop.hive.ql.udf.UDFRpad;
import org.apache.hadoop.hive.ql.udf.UDFSecond;
import org.apache.hadoop.hive.ql.udf.UDFSin;
import org.apache.hadoop.hive.ql.udf.UDFSpace;
import org.apache.hadoop.hive.ql.udf.UDFSqrt;
import org.apache.hadoop.hive.ql.udf.UDFSubstr;
import org.apache.hadoop.hive.ql.udf.UDFToBoolean;
import org.apache.hadoop.hive.ql.udf.UDFToByte;
import org.apache.hadoop.hive.ql.udf.UDFToDouble;
import org.apache.hadoop.hive.ql.udf.UDFToFloat;
import org.apache.hadoop.hive.ql.udf.UDFToInteger;
import org.apache.hadoop.hive.ql.udf.UDFToLong;
import org.apache.hadoop.hive.ql.udf.UDFToShort;
import org.apache.hadoop.hive.ql.udf.UDFToString;
import org.apache.hadoop.hive.ql.udf.UDFTrim;
import org.apache.hadoop.hive.ql.udf.UDFType;
import org.apache.hadoop.hive.ql.udf.UDFUnhex;
import org.apache.hadoop.hive.ql.udf.UDFUnixTimeStamp;
import org.apache.hadoop.hive.ql.udf.UDFUpper;
import org.apache.hadoop.hive.ql.udf.UDFWeekOfYear;
import org.apache.hadoop.hive.ql.udf.UDFYear;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFAverage;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFCount;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFEvaluator;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFResolver;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStd;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFStdSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFSum;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVariance;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDAFVarianceSample;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFArray;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBridge;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCase;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFCoalesce;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFConcatWS;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFElt;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFField;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFHash;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIf;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFIndex;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFInstr;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFLocate;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFMap;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNotNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFOPNull;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSize;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFSplit;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFWhen;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDTFExplode;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.ListTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.MapTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.util.ReflectionUtils;

public class FunctionRegistry {
    private static Log LOG = LogFactory.getLog((String)"org.apache.hadoop.hive.ql.exec.FunctionRegistry");
    static Map<String, FunctionInfo> mFunctions = new LinkedHashMap<String, FunctionInfo>();
    static Map<TypeInfo, Integer> numericTypes;
    static List<TypeInfo> numericTypeList;

    public static void registerTemporaryUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(false, functionName, UDFClass, isOperator);
    }

    static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator) {
        FunctionRegistry.registerUDF(isNative, functionName, UDFClass, isOperator, functionName.toLowerCase());
    }

    public static void registerUDF(String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        FunctionRegistry.registerUDF(true, functionName, UDFClass, isOperator, displayName);
    }

    public static void registerUDF(boolean isNative, String functionName, Class<? extends UDF> UDFClass, boolean isOperator, String displayName) {
        if (!UDF.class.isAssignableFrom(UDFClass)) {
            throw new RuntimeException("Registering UDF Class " + UDFClass + " which does not extend " + UDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, displayName, new GenericUDFBridge(displayName, isOperator, UDFClass));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static void registerTemporaryGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(false, functionName, genericUDFClass);
    }

    static void registerGenericUDF(String functionName, Class<? extends GenericUDF> genericUDFClass) {
        FunctionRegistry.registerGenericUDF(true, functionName, genericUDFClass);
    }

    public static void registerGenericUDF(boolean isNative, String functionName, Class<? extends GenericUDF> genericUDFClass) {
        if (!GenericUDF.class.isAssignableFrom(genericUDFClass)) {
            throw new RuntimeException("Registering GenericUDF Class " + genericUDFClass + " which does not extend " + GenericUDF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDF)ReflectionUtils.newInstance(genericUDFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static void registerTemporaryGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(false, functionName, genericUDTFClass);
    }

    static void registerGenericUDTF(String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        FunctionRegistry.registerGenericUDTF(true, functionName, genericUDTFClass);
    }

    public static void registerGenericUDTF(boolean isNative, String functionName, Class<? extends GenericUDTF> genericUDTFClass) {
        if (!GenericUDTF.class.isAssignableFrom(genericUDTFClass)) {
            throw new RuntimeException("Registering GenericUDTF Class " + genericUDTFClass + " which does not extend " + GenericUDTF.class);
        }
        FunctionInfo fI = new FunctionInfo(isNative, functionName, (GenericUDTF)ReflectionUtils.newInstance(genericUDTFClass, null));
        mFunctions.put(functionName.toLowerCase(), fI);
    }

    public static FunctionInfo getFunctionInfo(String functionName) {
        return mFunctions.get(functionName.toLowerCase());
    }

    public static Set<String> getFunctionNames() {
        return mFunctions.keySet();
    }

    public static Set<String> getFunctionNames(String funcPatternStr) {
        TreeSet<String> funcNames = new TreeSet<String>();
        Pattern funcPattern = null;
        try {
            funcPattern = Pattern.compile(funcPatternStr);
        }
        catch (PatternSyntaxException e) {
            return funcNames;
        }
        for (String funcName : mFunctions.keySet()) {
            if (!funcPattern.matcher(funcName).matches()) continue;
            funcNames.add(funcName);
        }
        return funcNames;
    }

    public static Set<String> getFunctionSynonyms(String funcName) {
        HashSet<String> synonyms = new HashSet<String>();
        FunctionInfo funcInfo = FunctionRegistry.getFunctionInfo(funcName);
        if (null == funcInfo) {
            return synonyms;
        }
        Class<?> funcClass = funcInfo.getFunctionClass();
        for (String name : mFunctions.keySet()) {
            if (name.equals(funcName) || !mFunctions.get(name).getFunctionClass().equals(funcClass)) continue;
            synonyms.add(name);
        }
        return synonyms;
    }

    static void registerNumericType(String typeName, int level) {
        TypeInfo t = TypeInfoFactory.getPrimitiveTypeInfo(typeName);
        numericTypeList.add(t);
        numericTypes.put(t, level);
    }

    public static TypeInfo getCommonClassForComparison(TypeInfo a, TypeInfo b) {
        if (a.equals(b)) {
            return a;
        }
        for (TypeInfo t : numericTypeList) {
            if (!FunctionRegistry.implicitConvertable(a, t) || !FunctionRegistry.implicitConvertable(b, t)) continue;
            return t;
        }
        return null;
    }

    public static TypeInfo getCommonClass(TypeInfo a, TypeInfo b) {
        Integer ai = numericTypes.get(a);
        Integer bi = numericTypes.get(b);
        if (ai == null || bi == null) {
            return null;
        }
        return ai > bi ? a : b;
    }

    public static boolean implicitConvertable(TypeInfo from, TypeInfo to) {
        if (from.equals(to)) {
            return true;
        }
        if (from.equals(TypeInfoFactory.stringTypeInfo) && to.equals(TypeInfoFactory.doubleTypeInfo)) {
            return true;
        }
        if (from.equals(TypeInfoFactory.voidTypeInfo)) {
            return true;
        }
        Integer f = numericTypes.get(from);
        Integer t = numericTypes.get(to);
        if (f == null || t == null) {
            return false;
        }
        return f <= t;
    }

    public static GenericUDAFEvaluator getGenericUDAFEvaluator(String name, List<TypeInfo> argumentTypeInfos) throws SemanticException {
        GenericUDAFResolver udaf = FunctionRegistry.getGenericUDAFResolver(name);
        if (udaf == null) {
            return null;
        }
        TypeInfo[] parameters = new TypeInfo[argumentTypeInfos.size()];
        for (int i = 0; i < parameters.length; ++i) {
            parameters[i] = argumentTypeInfos.get(i);
        }
        return udaf.getEvaluator(parameters);
    }

    public static <T> Method getMethodInternal(Class<? extends T> udfClass, String methodName, boolean exact, List<TypeInfo> argumentClasses) {
        ArrayList<Method> mlist = new ArrayList<Method>();
        for (Method m : Arrays.asList(udfClass.getMethods())) {
            if (!m.getName().equals(methodName)) continue;
            mlist.add(m);
        }
        return FunctionRegistry.getMethodInternal(mlist, exact, argumentClasses);
    }

    public static void registerTemporaryGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(false, functionName, genericUDAFResolver);
    }

    static void registerGenericUDAF(String functionName, GenericUDAFResolver genericUDAFResolver) {
        FunctionRegistry.registerGenericUDAF(true, functionName, genericUDAFResolver);
    }

    public static void registerGenericUDAF(boolean isNative, String functionName, GenericUDAFResolver genericUDAFResolver) {
        mFunctions.put(functionName.toLowerCase(), new FunctionInfo(isNative, functionName.toLowerCase(), genericUDAFResolver));
    }

    public static void registerTemporaryUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(false, functionName, udafClass);
    }

    static void registerUDAF(String functionName, Class<? extends UDAF> udafClass) {
        FunctionRegistry.registerUDAF(true, functionName, udafClass);
    }

    public static void registerUDAF(boolean isNative, String functionName, Class<? extends UDAF> udafClass) {
        mFunctions.put(functionName.toLowerCase(), new FunctionInfo(isNative, functionName.toLowerCase(), new GenericUDAFBridge((UDAF)ReflectionUtils.newInstance(udafClass, null))));
    }

    public static void unregisterTemporaryUDF(String functionName) throws HiveException {
        FunctionInfo fi = mFunctions.get(functionName.toLowerCase());
        if (fi != null) {
            if (!fi.isNative()) {
                mFunctions.remove(functionName.toLowerCase());
            } else {
                throw new HiveException("Function " + functionName + " is hive native, it can't be dropped");
            }
        }
    }

    public static GenericUDAFResolver getGenericUDAFResolver(String functionName) {
        LOG.debug((Object)("Looking up GenericUDAF: " + functionName));
        FunctionInfo finfo = mFunctions.get(functionName.toLowerCase());
        if (finfo == null) {
            return null;
        }
        GenericUDAFResolver result = finfo.getGenericUDAFResolver();
        return result;
    }

    public static Object invoke(Method m, Object thisObject, Object ... arguments) throws HiveException {
        Object o;
        try {
            o = m.invoke(thisObject, arguments);
        }
        catch (Exception e) {
            String thisObjectString = "" + thisObject + " of class " + (thisObject == null ? "null" : thisObject.getClass().getName());
            StringBuilder argumentString = new StringBuilder();
            if (arguments == null) {
                argumentString.append("null");
            } else {
                argumentString.append("{");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        argumentString.append(", ");
                    }
                    if (arguments[i] == null) {
                        argumentString.append("null");
                        continue;
                    }
                    argumentString.append("" + arguments[i] + ":" + arguments[i].getClass().getName());
                }
                argumentString.append("} of size " + arguments.length);
            }
            throw new HiveException("Unable to execute method " + m + " " + " on object " + thisObjectString + " with arguments " + argumentString.toString(), e);
        }
        return o;
    }

    public static int matchCost(TypeInfo argumentPassed, TypeInfo argumentAccepted, boolean exact) {
        if (argumentAccepted.equals(argumentPassed)) {
            return 0;
        }
        if (argumentPassed.equals(TypeInfoFactory.voidTypeInfo)) {
            return 0;
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.LIST) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.LIST)) {
            TypeInfo argumentPassedElement = ((ListTypeInfo)argumentPassed).getListElementTypeInfo();
            TypeInfo argumentAcceptedElement = ((ListTypeInfo)argumentAccepted).getListElementTypeInfo();
            return FunctionRegistry.matchCost(argumentPassedElement, argumentAcceptedElement, exact);
        }
        if (argumentPassed.getCategory().equals((Object)ObjectInspector.Category.MAP) && argumentAccepted.getCategory().equals((Object)ObjectInspector.Category.MAP)) {
            TypeInfo argumentPassedKey = ((MapTypeInfo)argumentPassed).getMapKeyTypeInfo();
            TypeInfo argumentAcceptedKey = ((MapTypeInfo)argumentAccepted).getMapKeyTypeInfo();
            TypeInfo argumentPassedValue = ((MapTypeInfo)argumentPassed).getMapValueTypeInfo();
            TypeInfo argumentAcceptedValue = ((MapTypeInfo)argumentAccepted).getMapValueTypeInfo();
            int cost1 = FunctionRegistry.matchCost(argumentPassedKey, argumentAcceptedKey, exact);
            int cost2 = FunctionRegistry.matchCost(argumentPassedValue, argumentAcceptedValue, exact);
            if (cost1 < 0 || cost2 < 0) {
                return -1;
            }
            return Math.max(cost1, cost2);
        }
        if (argumentAccepted.equals(TypeInfoFactory.unknownTypeInfo)) {
            return 1;
        }
        if (!exact && FunctionRegistry.implicitConvertable(argumentPassed, argumentAccepted)) {
            return 1;
        }
        return -1;
    }

    public static Method getMethodInternal(List<Method> mlist, boolean exact, List<TypeInfo> argumentsPassed) {
        int leastConversionCost = Integer.MAX_VALUE;
        Method udfMethod = null;
        for (Method m : mlist) {
            List<TypeInfo> argumentsAccepted = TypeInfoUtils.getParameterTypeInfos(m, argumentsPassed.size());
            if (argumentsAccepted == null) continue;
            boolean match = argumentsAccepted.size() == argumentsPassed.size();
            int conversionCost = 0;
            for (int i = 0; i < argumentsPassed.size() && match; ++i) {
                int cost = FunctionRegistry.matchCost(argumentsPassed.get(i), argumentsAccepted.get(i), exact);
                if (cost == -1) {
                    match = false;
                    continue;
                }
                conversionCost += cost;
            }
            LOG.debug((Object)("Method " + (match ? "did" : "didn't") + " match: passed = " + argumentsPassed + " accepted = " + argumentsAccepted + " method = " + m));
            if (!match) continue;
            if (conversionCost < leastConversionCost) {
                udfMethod = m;
                leastConversionCost = conversionCost;
                if (leastConversionCost != 0) continue;
                break;
            }
            if (conversionCost != leastConversionCost) continue;
            LOG.info((Object)("Ambigious methods: passed = " + argumentsPassed + " method 1 = " + udfMethod + " method 2 = " + m));
            udfMethod = null;
        }
        return udfMethod;
    }

    public static GenericUDF getGenericUDFForIndex() {
        return FunctionRegistry.getFunctionInfo("index").getGenericUDF();
    }

    public static GenericUDF getGenericUDFForAnd() {
        return FunctionRegistry.getFunctionInfo("and").getGenericUDF();
    }

    public static GenericUDF cloneGenericUDF(GenericUDF genericUDF) {
        if (null == genericUDF) {
            return null;
        }
        if (genericUDF instanceof GenericUDFBridge) {
            GenericUDFBridge bridge = (GenericUDFBridge)genericUDF;
            return new GenericUDFBridge(bridge.getUdfName(), bridge.isOperator(), bridge.getUdfClass());
        }
        return (GenericUDF)ReflectionUtils.newInstance(genericUDF.getClass(), null);
    }

    public static GenericUDTF cloneGenericUDTF(GenericUDTF genericUDTF) {
        if (null == genericUDTF) {
            return null;
        }
        return (GenericUDTF)ReflectionUtils.newInstance(genericUDTF.getClass(), null);
    }

    private static Class<? extends UDF> getUDFClassFromExprDesc(exprNodeDesc desc) {
        if (!(desc instanceof exprNodeGenericFuncDesc)) {
            return null;
        }
        exprNodeGenericFuncDesc genericFuncDesc = (exprNodeGenericFuncDesc)desc;
        if (!(genericFuncDesc.getGenericUDF() instanceof GenericUDFBridge)) {
            return null;
        }
        GenericUDFBridge bridge = (GenericUDFBridge)genericFuncDesc.getGenericUDF();
        return bridge.getUdfClass();
    }

    public static boolean isDeterministic(GenericUDF genericUDF) {
        GenericUDFBridge bridge;
        UDFType bridgeUDFType;
        UDFType genericUDFType = genericUDF.getClass().getAnnotation(UDFType.class);
        if (genericUDFType != null && !genericUDFType.deterministic()) {
            return false;
        }
        return !(genericUDF instanceof GenericUDFBridge) || (bridgeUDFType = (bridge = (GenericUDFBridge)genericUDF).getUdfClass().getAnnotation(UDFType.class)) == null || bridgeUDFType.deterministic();
    }

    public static boolean isOpAndOrNot(exprNodeDesc desc) {
        Class<? extends UDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(desc);
        return UDFOPAnd.class == udfClass || UDFOPOr.class == udfClass || UDFOPNot.class == udfClass;
    }

    public static boolean isOpAnd(exprNodeDesc desc) {
        Class<? extends UDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(desc);
        return UDFOPAnd.class == udfClass;
    }

    public static boolean isOpPositive(exprNodeDesc desc) {
        Class<? extends UDF> udfClass = FunctionRegistry.getUDFClassFromExprDesc(desc);
        return UDFOPPositive.class == udfClass;
    }

    static {
        FunctionRegistry.registerUDF("concat", UDFConcat.class, false);
        FunctionRegistry.registerUDF("substr", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("substring", UDFSubstr.class, false);
        FunctionRegistry.registerUDF("space", UDFSpace.class, false);
        FunctionRegistry.registerUDF("repeat", UDFRepeat.class, false);
        FunctionRegistry.registerUDF("ascii", UDFAscii.class, false);
        FunctionRegistry.registerUDF("lpad", UDFLpad.class, false);
        FunctionRegistry.registerUDF("rpad", UDFRpad.class, false);
        FunctionRegistry.registerGenericUDF("size", GenericUDFSize.class);
        FunctionRegistry.registerUDF("round", UDFRound.class, false);
        FunctionRegistry.registerUDF("floor", UDFFloor.class, false);
        FunctionRegistry.registerUDF("sqrt", UDFSqrt.class, false);
        FunctionRegistry.registerUDF("ceil", UDFCeil.class, false);
        FunctionRegistry.registerUDF("ceiling", UDFCeil.class, false);
        FunctionRegistry.registerUDF("rand", UDFRand.class, false);
        FunctionRegistry.registerUDF("abs", UDFAbs.class, false);
        FunctionRegistry.registerUDF("pmod", UDFPosMod.class, false);
        FunctionRegistry.registerUDF("ln", UDFLn.class, false);
        FunctionRegistry.registerUDF("log2", UDFLog2.class, false);
        FunctionRegistry.registerUDF("sin", UDFSin.class, false);
        FunctionRegistry.registerUDF("asin", UDFAsin.class, false);
        FunctionRegistry.registerUDF("cos", UDFCos.class, false);
        FunctionRegistry.registerUDF("acos", UDFAcos.class, false);
        FunctionRegistry.registerUDF("log10", UDFLog10.class, false);
        FunctionRegistry.registerUDF("log", UDFLog.class, false);
        FunctionRegistry.registerUDF("exp", UDFExp.class, false);
        FunctionRegistry.registerUDF("power", UDFPower.class, false);
        FunctionRegistry.registerUDF("pow", UDFPower.class, false);
        FunctionRegistry.registerUDF("conv", UDFConv.class, false);
        FunctionRegistry.registerUDF("bin", UDFBin.class, false);
        FunctionRegistry.registerUDF("hex", UDFHex.class, false);
        FunctionRegistry.registerUDF("unhex", UDFUnhex.class, false);
        FunctionRegistry.registerUDF("upper", UDFUpper.class, false);
        FunctionRegistry.registerUDF("lower", UDFLower.class, false);
        FunctionRegistry.registerUDF("ucase", UDFUpper.class, false);
        FunctionRegistry.registerUDF("lcase", UDFLower.class, false);
        FunctionRegistry.registerUDF("trim", UDFTrim.class, false);
        FunctionRegistry.registerUDF("ltrim", UDFLTrim.class, false);
        FunctionRegistry.registerUDF("rtrim", UDFRTrim.class, false);
        FunctionRegistry.registerUDF("length", UDFLength.class, false);
        FunctionRegistry.registerUDF("reverse", UDFReverse.class, false);
        FunctionRegistry.registerGenericUDF("field", GenericUDFField.class);
        FunctionRegistry.registerUDF("find_in_set", UDFFindInSet.class, false);
        FunctionRegistry.registerUDF("like", UDFLike.class, true);
        FunctionRegistry.registerUDF("rlike", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp", UDFRegExp.class, true);
        FunctionRegistry.registerUDF("regexp_replace", UDFRegExpReplace.class, false);
        FunctionRegistry.registerUDF("regexp_extract", UDFRegExpExtract.class, false);
        FunctionRegistry.registerUDF("parse_url", UDFParseUrl.class, false);
        FunctionRegistry.registerGenericUDF("split", GenericUDFSplit.class);
        FunctionRegistry.registerUDF("positive", UDFOPPositive.class, true, "+");
        FunctionRegistry.registerUDF("negative", UDFOPNegative.class, true, "-");
        FunctionRegistry.registerUDF("day", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("dayofmonth", UDFDayOfMonth.class, false);
        FunctionRegistry.registerUDF("month", UDFMonth.class, false);
        FunctionRegistry.registerUDF("year", UDFYear.class, false);
        FunctionRegistry.registerUDF("hour", UDFHour.class, false);
        FunctionRegistry.registerUDF("minute", UDFMinute.class, false);
        FunctionRegistry.registerUDF("second", UDFSecond.class, false);
        FunctionRegistry.registerUDF("from_unixtime", UDFFromUnixTime.class, false);
        FunctionRegistry.registerUDF("unix_timestamp", UDFUnixTimeStamp.class, false);
        FunctionRegistry.registerUDF("to_date", UDFDate.class, false);
        FunctionRegistry.registerUDF("weekofyear", UDFWeekOfYear.class, false);
        FunctionRegistry.registerUDF("date_add", UDFDateAdd.class, false);
        FunctionRegistry.registerUDF("date_sub", UDFDateSub.class, false);
        FunctionRegistry.registerUDF("datediff", UDFDateDiff.class, false);
        FunctionRegistry.registerUDF("get_json_object", UDFJson.class, false);
        FunctionRegistry.registerUDF("+", UDFOPPlus.class, true);
        FunctionRegistry.registerUDF("-", UDFOPMinus.class, true);
        FunctionRegistry.registerUDF("*", UDFOPMultiply.class, true);
        FunctionRegistry.registerUDF("/", UDFOPDivide.class, true);
        FunctionRegistry.registerUDF("%", UDFOPMod.class, true);
        FunctionRegistry.registerUDF("div", UDFOPLongDivide.class, true);
        FunctionRegistry.registerUDF("&", UDFOPBitAnd.class, true);
        FunctionRegistry.registerUDF("|", UDFOPBitOr.class, true);
        FunctionRegistry.registerUDF("^", UDFOPBitXor.class, true);
        FunctionRegistry.registerUDF("~", UDFOPBitNot.class, true);
        FunctionRegistry.registerUDF("=", UDFOPEqual.class, true);
        FunctionRegistry.registerUDF("==", UDFOPEqual.class, true, "=");
        FunctionRegistry.registerUDF("<>", UDFOPNotEqual.class, true);
        FunctionRegistry.registerUDF("!=", UDFOPNotEqual.class, true, "<>");
        FunctionRegistry.registerUDF("<", UDFOPLessThan.class, true);
        FunctionRegistry.registerUDF("<=", UDFOPEqualOrLessThan.class, true);
        FunctionRegistry.registerUDF(">", UDFOPGreaterThan.class, true);
        FunctionRegistry.registerUDF(">=", UDFOPEqualOrGreaterThan.class, true);
        FunctionRegistry.registerUDF("and", UDFOPAnd.class, true);
        FunctionRegistry.registerUDF("or", UDFOPOr.class, true);
        FunctionRegistry.registerUDF("not", UDFOPNot.class, true);
        FunctionRegistry.registerUDF("!", UDFOPNot.class, true, "not");
        FunctionRegistry.registerGenericUDF("isnull", GenericUDFOPNull.class);
        FunctionRegistry.registerGenericUDF("isnotnull", GenericUDFOPNotNull.class);
        FunctionRegistry.registerGenericUDF("if", GenericUDFIf.class);
        FunctionRegistry.registerUDF("boolean", UDFToBoolean.class, false, UDFToBoolean.class.getSimpleName());
        FunctionRegistry.registerUDF("tinyint", UDFToByte.class, false, UDFToByte.class.getSimpleName());
        FunctionRegistry.registerUDF("smallint", UDFToShort.class, false, UDFToShort.class.getSimpleName());
        FunctionRegistry.registerUDF("int", UDFToInteger.class, false, UDFToInteger.class.getSimpleName());
        FunctionRegistry.registerUDF("bigint", UDFToLong.class, false, UDFToLong.class.getSimpleName());
        FunctionRegistry.registerUDF("float", UDFToFloat.class, false, UDFToFloat.class.getSimpleName());
        FunctionRegistry.registerUDF("double", UDFToDouble.class, false, UDFToDouble.class.getSimpleName());
        FunctionRegistry.registerUDF("string", UDFToString.class, false, UDFToString.class.getSimpleName());
        FunctionRegistry.registerGenericUDAF("sum", new GenericUDAFSum());
        FunctionRegistry.registerGenericUDAF("count", new GenericUDAFCount());
        FunctionRegistry.registerGenericUDAF("avg", new GenericUDAFAverage());
        FunctionRegistry.registerGenericUDAF("std", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_pop", new GenericUDAFStd());
        FunctionRegistry.registerGenericUDAF("stddev_samp", new GenericUDAFStdSample());
        FunctionRegistry.registerGenericUDAF("variance", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_pop", new GenericUDAFVariance());
        FunctionRegistry.registerGenericUDAF("var_samp", new GenericUDAFVarianceSample());
        FunctionRegistry.registerUDAF("max", UDAFMax.class);
        FunctionRegistry.registerUDAF("min", UDAFMin.class);
        FunctionRegistry.registerGenericUDF("array", GenericUDFArray.class);
        FunctionRegistry.registerGenericUDF("map", GenericUDFMap.class);
        FunctionRegistry.registerGenericUDF("case", GenericUDFCase.class);
        FunctionRegistry.registerGenericUDF("when", GenericUDFWhen.class);
        FunctionRegistry.registerGenericUDF("hash", GenericUDFHash.class);
        FunctionRegistry.registerGenericUDF("coalesce", GenericUDFCoalesce.class);
        FunctionRegistry.registerGenericUDF("index", GenericUDFIndex.class);
        FunctionRegistry.registerGenericUDF("instr", GenericUDFInstr.class);
        FunctionRegistry.registerGenericUDF("locate", GenericUDFLocate.class);
        FunctionRegistry.registerGenericUDF("elt", GenericUDFElt.class);
        FunctionRegistry.registerGenericUDF("concat_ws", GenericUDFConcatWS.class);
        FunctionRegistry.registerGenericUDTF("explode", GenericUDTFExplode.class);
        numericTypes = new HashMap<TypeInfo, Integer>();
        numericTypeList = new ArrayList<TypeInfo>();
        FunctionRegistry.registerNumericType("tinyint", 1);
        FunctionRegistry.registerNumericType("smallint", 2);
        FunctionRegistry.registerNumericType("int", 3);
        FunctionRegistry.registerNumericType("bigint", 4);
        FunctionRegistry.registerNumericType("float", 5);
        FunctionRegistry.registerNumericType("double", 6);
        FunctionRegistry.registerNumericType("string", 7);
    }
}

